/*********************************************************************
 *
 *      Copyright (C) 1999 Nathan Fiedler
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * PROJECT:     JSwat
 * MODULE:      JSwat Actions
 * FILE:        FinishAction.java
 *
 * AUTHOR:      Nathan Fiedler
 *
 * REVISION HISTORY:
 *      Name    Date            Description
 *      ----    ----            -----------
 *      nf      8/29/99         Initial version
 *
 * DESCRIPTION:
 *      This file defines the finish action.
 *
 ********************************************************************/

package com.bluemarsh.jswat.action;

import com.bluemarsh.jswat.Session;
import com.sun.jdi.request.StepRequest;
import java.awt.event.ActionEvent;

/**
 * Implements the step instruction action.
 *
 * @author  Nathan Fiedler
 * @version 1.0  8/29/99
 */
public class FinishAction extends StepAction {

    /**
     * Creates a new FinishAction object with the default action
     * command string of "finish".
     */
    public FinishAction() {
        super("finish");
    } // FinishAction

    /**
     * Performs the finish action.
     *
     * @param  event  action event
     */
    public void actionPerformed(ActionEvent event) {
        Session session = getSession(event);
        if (session.isActive()) {
            // Step out of the current function.
            step(session, StepRequest.STEP_LINE, StepRequest.STEP_OUT);
        } else {
            session.getStatusLog().writeln
                (swat.getResourceString("noActiveSession"));
        }
    } // actionPerformed
} // StepAction
