/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AbstractStructureWithAttributes;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.attributes.CodeAttribute;
import org.gjt.jclasslib.structures.attributes.ConstantValueAttribute;
import org.gjt.jclasslib.structures.attributes.DeprecatedAttribute;
import org.gjt.jclasslib.structures.attributes.ExceptionsAttribute;
import org.gjt.jclasslib.structures.attributes.InnerClassesAttribute;
import org.gjt.jclasslib.structures.attributes.LineNumberTableAttribute;
import org.gjt.jclasslib.structures.attributes.LocalVariableTableAttribute;
import org.gjt.jclasslib.structures.attributes.SourceFileAttribute;
import org.gjt.jclasslib.structures.attributes.SyntheticAttribute;
import org.gjt.jclasslib.structures.constants.ConstantUtf8Info;

public class AttributeInfo
extends AbstractStructureWithAttributes {
    public static final String SYSTEM_PROPERTY_SKIP_ATTRIBUTES = "jclasslib.io.skipAttributes";
    private int attributeNameIndex;
    private int attributeLength;
    private byte[] info;
    static /* synthetic */ Class class$org$gjt$jclasslib$structures$AttributeInfo;

    public static AttributeInfo createOrSkip(DataInput dataInput, ClassFile classFile) throws InvalidByteCodeException, IOException {
        AttributeInfo attributeInfo = null;
        if (Boolean.getBoolean(SYSTEM_PROPERTY_SKIP_ATTRIBUTES)) {
            dataInput.skipBytes(2);
            dataInput.skipBytes(dataInput.readInt());
        } else {
            int n = dataInput.readUnsignedShort();
            int n2 = dataInput.readInt();
            ConstantUtf8Info constantUtf8Info = classFile.getConstantPoolUtf8Entry(n);
            String string = null;
            if (constantUtf8Info == null) {
                return null;
            }
            string = constantUtf8Info.getString();
            attributeInfo = "ConstantValue".equals(string) ? new ConstantValueAttribute() : ("Code".equals(string) ? new CodeAttribute() : ("Exceptions".equals(string) ? new ExceptionsAttribute() : ("InnerClasses".equals(string) ? new InnerClassesAttribute() : ("Synthetic".equals(string) ? new SyntheticAttribute() : ("SourceFile".equals(string) ? new SourceFileAttribute() : ("LineNumberTable".equals(string) ? new LineNumberTableAttribute() : ("LocalVariableTable".equals(string) ? new LocalVariableTableAttribute() : ("Deprecated".equals(string) ? new DeprecatedAttribute() : new AttributeInfo(n2)))))))));
            attributeInfo.setAttributeNameIndex(n);
            attributeInfo.setClassFile(classFile);
            attributeInfo.read(dataInput);
        }
        return attributeInfo;
    }

    protected AttributeInfo() {
    }

    private AttributeInfo(int n) {
        this.attributeLength = n;
    }

    public int getAttributeNameIndex() {
        return this.attributeNameIndex;
    }

    public void setAttributeNameIndex(int n) {
        this.attributeNameIndex = n;
    }

    public byte[] getInfo() {
        return this.info;
    }

    public void setInfo(byte[] byArray) {
        this.info = byArray;
    }

    public String getName() throws InvalidByteCodeException {
        return this.classFile.getConstantPoolUtf8Entry(this.attributeNameIndex).getString();
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        this.info = new byte[this.attributeLength];
        dataInput.readFully(this.info);
        if (this.debug) {
            this.debug("read " + this.getDebugMessage());
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        dataOutput.writeShort(this.attributeNameIndex);
        dataOutput.writeInt(this.getAttributeLength());
        if (this.getClass().equals(class$org$gjt$jclasslib$structures$AttributeInfo == null ? (class$org$gjt$jclasslib$structures$AttributeInfo = AttributeInfo.class$("org.gjt.jclasslib.structures.AttributeInfo")) : class$org$gjt$jclasslib$structures$AttributeInfo)) {
            dataOutput.write(this.info);
            if (this.debug) {
                this.debug("wrote " + this.getDebugMessage());
            }
        }
    }

    public int getAttributeLength() {
        return this.getLength(this.info);
    }

    private String getDebugMessage() {
        String string;
        try {
            string = this.classFile.getConstantPoolUtf8Entry(this.attributeNameIndex).getString();
        }
        catch (InvalidByteCodeException invalidByteCodeException) {
            string = "(unknown)";
        }
        return "uninterpreted attribute of reported type " + string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

