/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.test.remoting.transport.multiplex;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Random;
import org.apache.log4j.Level;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

import junit.framework.TestCase;

/**
 * <p/>
 * Copyright (c) 2005
 * <p/>
 *
 * @author <a href="mailto:r.sigal@computer.org">Ron Sigal</a>
 */
public class SimpleClientTest extends TestCase
{
   private static final Logger log = Logger.getLogger(SimpleClientTest.class);

   private Socket socket = null;

   private ObjectOutputStream oos = null;
   private ObjectInputStream ois = null;

   /**
    *
    */
   public SimpleClientTest()
   {
   }


   public static void main(String[] args)
   {
      org.apache.log4j.BasicConfigurator.configure();
      org.apache.log4j.Category.getRoot().setLevel(Level.DEBUG);

      new SimpleClientTest().testClient();
   }


   public void testClient()
   {
      log.info("Starting client test");

      try
      {
         socket = new VirtualSocket("127.0.0.1", 1999);
      }
      catch(UnknownHostException e)
      {
         log.error("UnknownHostException for \"localhost\"");
         e.printStackTrace();
      }
      catch(IOException e)
      {
         log.error("i/o exception creating VirtualSocket");
         e.printStackTrace();
      }

      try
      {
         oos = new ObjectOutputStream(socket.getOutputStream());
         ois = new ObjectInputStream(socket.getInputStream());

         for(int x = new Random().nextInt(100); x < 10; x++)
         {
            System.out.println("writing out value " + x);
            log.debug("writing out value " + x);
            oos.writeObject(new Integer(x));
            oos.flush();

            Integer i = (Integer) ois.readObject();
            System.out.println((x + 100) + " - " + i.intValue() + " are equal?  " + (((x + 100) == i.intValue()) ? "true" : "FALSE"));
            log.debug((x + 100) + " - " + i.intValue() + " are equal?  " + (((x + 100) == i.intValue()) ? "true" : "FALSE"));
            assertEquals(x + 100, i.intValue());
         }

      }
      catch(IOException e)
      {
         log.error("i/o error", e);
         e.printStackTrace();
      }
      catch(ClassNotFoundException e)
      {
         log.error("class not found", e);
         e.printStackTrace();
      }

      try
      {
         socket.close();
      }
      catch(IOException ignore)
      {
         log.error("i/o exception closing socket");
      }

      log.info("Ending client test (main thread)");
   }


}
