/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.test.remoting.transport.multiplex.ssl;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;

import javax.net.ServerSocketFactory;

import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.transport.Connector;
import org.jboss.test.remoting.transport.multiplex.MultiplexInvokerConfigTestClient;
import org.jboss.test.remoting.transport.multiplex.MultiplexInvokerTestServer;

public class MultiplexInvokerTestClient extends MultiplexInvokerConfigTestClient
{
   HashMap config;
   
   protected String getTransport()
   {
      return "sslmultiplex";
   }
   
   
   protected Map getConfiguration()
   {
      if (config == null)
      {
         config = new HashMap();
         config.put(SSLSocketBuilder.REMOTING_SERVER_SOCKET_USE_CLIENT_MODE, "true");
         config.put(SSLSocketBuilder.REMOTING_TRUST_STORE_TYPE, "JKS");
       String trustStoreFilePath = this.getClass().getResource(".truststore").getFile();
       config.put(SSLSocketBuilder.REMOTING_TRUST_STORE_FILE_PATH, trustStoreFilePath);
       config.put(SSLSocketBuilder.REMOTING_TRUST_STORE_PASSWORD, "unit-tests-client");
       
      }
      
      return new HashMap(config);
   }
   
      
   protected int getClientTimeout()
   {
      return 120000;
   }
   
   
   protected int getCallbackPort()
   {
      return 6040;
   }
   
   
   protected OneServerInvokerTester getTester()
   {
      return new SSLServerInvokerTester();
   }
   
   // For those cases where the callback Connector needs a ServerSocketFactory.
   static class SSLServerInvokerTester extends OneServerInvokerTester
   {
      public void setupServer(InvokerLocator locator, Map configuration) throws Exception
      {
         System.out.println("Starting remoting server with locator uri of: " + locator);
         callbackServerConnector = new Connector(locator.getLocatorURI(), configuration);
         callbackServerConnector.start();
         System.out.println("Started remoting server with original locator uri of: " + locator);
         System.out.println("Started remoting server with updated  locator uri of: " + callbackServerConnector.getInvokerLocator());

         // are using the same invocation handler as the one on the sample callback server
         MultiplexInvokerTestServer.SampleInvocationHandler invocationHandler
               = new MultiplexInvokerTestServer.SampleInvocationHandler(false);
         // first parameter is sub-system name.  can be any String value.
         callbackServerConnector.addInvocationHandler("sample", invocationHandler);
      }
   }
}
