/* 
 *   MOL adaption (2001/01/03)
 *
 *   Samuel Rydh, <samuel@ibrium.se>
 *
 */
/*
 * Copyright (c) 2000 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * The contents of this file constitute Original Code as defined in and
 * are subject to the Apple Public Source License Version 1.1 (the
 * "License").  You may not use this file except in compliance with the
 * License.  Please obtain a copy of the License at
 * http://www.apple.com/publicsource and read it before using this file.
 * 
 * This Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
 *  drivers.c - Driver Loading Functions.
 *
 *  Copyright (c) 2000 Apple Computer, Inc.
 *
 *  DRI: Josh de Cesare
 */

#include "mol_config.h"
#include <string.h>
#include <stdio.h>
#include "sl.h"
#include "bootx.h"
#include "res_manager.h"
#include "debugger.h"

#define kDriverPackageSignature1 'MKXT'
#define kDriverPackageSignature2 'MOSX'

struct DriversPackage {
	unsigned long signature1;
	unsigned long signature2;
	unsigned long length;
	unsigned long alder32;
	unsigned long version;
	unsigned long numDrivers;
	unsigned long reserved1;
	unsigned long reserved2;
};
typedef struct DriversPackage DriversPackage;


static unsigned long 
Alder32(unsigned char *buffer, long length)
{
	long          cnt;
	unsigned long result, lowHalf, highHalf;
  
	lowHalf = 1;
	highHalf = 0;
	
	for (cnt = 0; cnt < length; cnt++) {
		if ((cnt % 5000) == 0) {
			lowHalf  %= 65521L;
			highHalf %= 65521L;
		}
    
		lowHalf += buffer[cnt];
		highHalf += lowHalf;
	}

	lowHalf  %= 65521L;
	highHalf %= 65521L;
  
	result = (highHalf << 16) | lowHalf;
  
	return result;
}

// Assumes mkext driver has been loaded to kLoadAddr already
long 
AddDriverMKext( void )
{
	long driversAddr, driversLength;
	char segName[32];

	DriversPackage *package = (DriversPackage *)TO_LV(kLoadAddr);

	// Verify the MKext.
	if( (package->signature1 != kDriverPackageSignature1) ||
	    (package->signature2 != kDriverPackageSignature2)) return -1;
	if( package->length > kLoadSize) return -1;
	if( package->alder32 != Alder32((char *)&package->version,
					package->length - 0x10)) return -1;

	// Make space for the MKext.
	driversLength = package->length;
	driversAddr = AllocateKernelMemory(driversLength);

	// Copy the MKext.
	memcpy((void *)driversAddr, (void *)TO_LV(kLoadAddr), driversLength);
	
	// Add the MKext to the memory map.
	sprintf(segName, "DriversPackage-%x", TO_MAC(driversAddr));
	printm("DriversPackage-%x\n", TO_MAC(driversAddr));
	AllocateMemoryRange(segName, driversAddr, driversLength);
	
	return 0;
}
