#ifndef _H_MAC_KEYS
#define _H_MAC_KEYS

#define KEY_DETAIL(e)   ((e) & 0x7f)
#define KEY_UP(e)       ((e) & 0x80)

#define IS_POWER_KEY(x)         (KEY_DETAIL(x) == 0x7f)
#define IS_COMMAND_KEY(x)       (KEY_DETAIL(x) == 0x37)
#define IS_OPTION_KEY(x)        (KEY_DETAIL(x) == 0x3a)
#define IS_RIGHT_OPTION_KEY(x)  (KEY_DETAIL(x) == 0x7c)
#define IS_CAPS_LOCK_KEY(x)     (KEY_DETAIL(x) == 0x39)
#define IS_NUM_LOCK_KEY(x)      (KEY_DETAIL(x) == 0x47)
#define IS_SCROLL_LOCK_KEY(x)   (KEY_DETAIL(x) == 0x6b)
#define IS_LEFT_CTRL_KEY(X)     (KEY_DETAIL(X) == 0x36)
#define IS_RIGHT_CTRL_KEY(X)    (KEY_DETAIL(X) == 0x7d)

/* The keycodes for the right modifiers might be wrong sometimes */
#define KEY_LEFT_OPTION		0x3a
/*#define KEY_RIGHT_OPTION	0x7c*/
#define KEY_COMMAND		0x37
#define KEY_LEFT_CTRL		0x36
#define KEY_RIGHT_CTRL		0x7d
#define KEY_LEFT_SHIFT		0x38

#define KEY_F1 0x7a
#define KEY_F2 0x78
#define KEY_F3 0x63
#define KEY_F4 0x76
#define KEY_F5 0x60
#define KEY_F6 0x61
#define KEY_F7 0x62
#define KEY_F8 0x64
#define KEY_F9 0x65
#define KEY_F10 0x6d
#define KEY_F11 0x67
#define KEY_F12 0x6f    

#define MOUSE_ESCAPE    0x7e 


#endif   /* _H_MAC_KEYS */
