/* 
 *   Creation Date: <2001/05/06 17:12:45 samuel>
 *   Time-stamp: <2001/05/24 14:00:07 samuel>
 *   
 *	<fs_loader.h>
 *	
 *	Generic file system access
 *   
 *   Copyright (C) 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_FS
#define _H_FS


typedef struct fs_ops fs_ops_t;

typedef void *file_desc_t;

enum { FS_HFS=1, FS_HFS_PLUS, FS_NATIVE };

extern fs_ops_t *fs_open( int fs_type, char *path, ullong offs );
#define fs_close( fs ) 			(fs)->close_fs( fs )
#define fs_open_path( fs, path ) 	(fs)->open_path( fs, path )
#define fs_search_rom( fs )		(fs)->search_rom( fs )
#define fs_search_file( fs, name )	(fs)->search_file( fs, name )

struct fs_ops {
	void		*fs_data;
	char		*dev_name;

	void		(*close_fs)( fs_ops_t *fs );
	file_desc_t	(*open_path)( fs_ops_t *fs, char *path );
	file_desc_t	(*search_rom)( fs_ops_t *fs );
	file_desc_t	(*search_file)( fs_ops_t *fs, char *name );

	/* file ops */
	void		(*close)( file_desc_t fd );
	int		(*read)( file_desc_t fd, void *buf, size_t count );
	int		(*lseek)( file_desc_t fd, off_t offset, int whence );
	char		*(*get_path)( file_desc_t fd, char *buf, int len );
};


extern fs_ops_t *fs_hfsp_open( ullong offs, char *path );
extern fs_ops_t *fs_hfs_open( ullong offs, char *path );
extern fs_ops_t *fs_native_open( void );

#endif   /* _H_FS */
