/* 
 *   Creation Date: <1999/03/29 05:04:40 samuel>
 *   Time-stamp: <2000/06/17 16:13:27 samuel>
 *   
 *	<long_lseek.h>
 *	
 *	64bit lseek
 *   
 *   Copyright (C) 1999, 2000 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_LONG_LSEEK
#define _H_LONG_LSEEK

#include <unistd.h>
#include <linux/unistd.h>

/* this could be done through _llseek instead */

/*static inline int long_lseek( int fd, unsigned long pos_hi, unsigned long pos_lo );
  static inline int blk_lseek( int fd, long block, long offs );*/

extern int _llseek( uint fd, ulong offs_hi, ulong offs_lo, loff_t *res, uint wh );

static inline int 
long_lseek( int fd, ulong pos_hi, ulong pos_lo )
{
	loff_t res;
	return _llseek( fd, pos_hi, pos_lo, &res, SEEK_SET );
}

static inline int
blk_lseek( int fd, long block, long offs )
{
	loff_t res;

	if( offs & ~0x1ff ) {
		printm("blk_lseek: offs out of range\n");
		return -2;
	}
	return _llseek( fd, (block>>23), (block<<9) | offs, &res, SEEK_SET );
}

/* util */
extern ulong get_file_size_in_blks( int fd );

#endif   /* _H_LONG_LSEEK */
