/* 
 *   Creation Date: <1999/07/25 17:08:47 samuel>
 *   Time-stamp: <2001/04/08 19:20:49 samuel>
 *   
 *	<molif.h>
 *	
 *	Mac-On-Linux kernel interface
 *   
 *   Copyright (C) 1999, 2000, 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_HOOK_TABLE
#define _H_HOOK_TABLE

#include <linux/types.h>
#include "kernel_vars.h"

/* The module loads if the interface falls into this range: */
#define MIN_INTERFACE_VERSION		1
#define MAX_INTERFACE_VERSION		3

#define FLUSH_HASH_PAGE_HOOK_NUM   	10	/* v1..3 */

typedef struct molif
{
	int		vers;
	/* version 1,2 (16), version 3 (24) */
	ulong		hook[ 17 ];
} molif_t;

/* 
   0	data_access			(ver 1)
   1	inst_access
   2	program_check
   3	fpu_unavailable
   4	dec
   5	trace (or runmode)
   6	transfer_to_handler
   7	giveup_fpu 		[MMU]
   8	do_signal 		[MMU]
   9	int_return 		[MMU]
   10	flush_hash_page 	[MMU]
   11	iabr_hook			(ver 2)
   12	altivec_unavailable		(ver 3, CONFIG_ALTIVEC)
   13	giveup_altivec		[MMU]
   14	ITLBMiss (603)
   15	DTLBLoadMiss (603)
   16	DTLBStoreMiss (603)
 */


#endif   /* _H_HOOK_TABLE */
