/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.data.tuple.TupleSet;
import prefuse.visual.VisualItem;

public class CircleLayout
extends Layout {
    private double m_radius;

    public CircleLayout(String group) {
        super(group);
    }

    public CircleLayout(String group, double radius) {
        super(group);
        this.m_radius = radius;
    }

    public double getRadius() {
        return this.m_radius;
    }

    public void setRadius(double radius) {
        this.m_radius = radius;
    }

    public void run(double frac) {
        TupleSet ts = this.m_vis.getGroup(this.m_group);
        int nn = ts.getTupleCount();
        Rectangle2D r = this.getLayoutBounds();
        double height = r.getHeight();
        double width = r.getWidth();
        double cx = r.getCenterX();
        double cy = r.getCenterY();
        double radius = this.m_radius;
        if (radius <= 0.0) {
            radius = 0.45 * (height < width ? height : width);
        }
        Iterator items = ts.tuples();
        int i = 0;
        while (items.hasNext()) {
            VisualItem n = (VisualItem)items.next();
            double angle = Math.PI * 2 * (double)i / (double)nn;
            double x = Math.cos(angle) * radius + cx;
            double y = Math.sin(angle) * radius + cy;
            this.setX(n, null, x);
            this.setY(n, null, y);
            ++i;
        }
    }
}

