/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import prefuse.data.Tuple;
import prefuse.data.expression.Expression;
import prefuse.data.expression.IfExpression;
import prefuse.data.expression.ObjectLiteral;
import prefuse.data.expression.Predicate;

public class PredicateChain {
    private Expression m_head = new ObjectLiteral(null);
    private IfExpression m_tail = null;

    public Expression getExpression() {
        return this.m_head;
    }

    public Object get(Tuple t) {
        return this.m_head.get(t);
    }

    public void add(Predicate p, Object val) {
        if (this.m_tail == null) {
            this.m_tail = new IfExpression(p, new ObjectLiteral(val), this.m_head);
            this.m_head = this.m_tail;
        } else {
            IfExpression ie = new IfExpression(p, new ObjectLiteral(val), this.m_tail.getElseExpression());
            this.m_tail.setElseExpression(ie);
            this.m_tail = ie;
        }
    }

    public boolean remove(Predicate p) {
        if (p == null) {
            return false;
        }
        IfExpression prev = null;
        Expression expr = this.m_head;
        while (expr instanceof IfExpression) {
            IfExpression ifex = (IfExpression)expr;
            Predicate text = ifex.getTestPredicate();
            if (!p.equals(text)) continue;
            Expression elseex = ifex.getElseExpression();
            ifex.setElseExpression(new ObjectLiteral(null));
            if (prev != null) {
                prev.setElseExpression(elseex);
                if (ifex == this.m_tail) {
                    this.m_tail = prev;
                }
            } else {
                this.m_head = elseex;
                if (ifex == this.m_tail) {
                    this.m_tail = null;
                }
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this.m_head = new ObjectLiteral(null);
        this.m_tail = null;
    }
}

