/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import prefuse.Visualization;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.search.PrefixSearchTupleSet;
import prefuse.data.search.SearchTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ColorLib;

public class JSearchPanel
extends JPanel
implements DocumentListener,
ActionListener {
    private Object m_lock;
    private SearchTupleSet m_searcher;
    private JTextField m_queryF = new JTextField(15);
    private JLabel m_resultL = new JLabel("          ");
    private JLabel m_searchL = new JLabel("search >> ");
    private Box m_sbox = new Box(0);
    private String[] m_fields;
    private boolean m_includeHitCount = false;
    private boolean m_monitorKeys = false;
    private boolean m_autoIndex = true;
    private boolean m_showBorder = true;
    private boolean m_showCancel = true;

    public JSearchPanel(SearchTupleSet search, String field) {
        this(search, field, false);
    }

    public JSearchPanel(SearchTupleSet search, String field, boolean monitorKeystrokes) {
        this(null, search, new String[]{field}, false, monitorKeystrokes);
    }

    public JSearchPanel(TupleSet source, SearchTupleSet search, String[] fields, boolean autoIndex, boolean monitorKeystrokes) {
        this.m_lock = new Object();
        this.m_fields = fields;
        this.m_autoIndex = autoIndex;
        this.m_monitorKeys = monitorKeystrokes;
        this.m_searcher = search != null ? search : new PrefixSearchTupleSet();
        this.init(source);
    }

    public JSearchPanel(Visualization vis, String field) {
        this(vis, Visualization.ALL_ITEMS, field, true);
    }

    public JSearchPanel(Visualization vis, String group, String field) {
        this(vis, group, field, true);
    }

    public JSearchPanel(Visualization vis, String group, String field, boolean autoIndex) {
        this(vis, group, Visualization.SEARCH_ITEMS, new String[]{field}, autoIndex, false);
    }

    public JSearchPanel(Visualization vis, String group, String field, boolean autoIndex, boolean monitorKeystrokes) {
        this(vis, group, Visualization.SEARCH_ITEMS, new String[]{field}, autoIndex, true);
    }

    public JSearchPanel(Visualization vis, String group, String searchGroup, String field, boolean autoIndex, boolean monitorKeystrokes) {
        this(vis, group, searchGroup, new String[]{field}, autoIndex, monitorKeystrokes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSearchPanel(Visualization vis, String group, String searchGroup, String[] fields, boolean autoIndex, boolean monitorKeystrokes) {
        this.m_lock = vis;
        this.m_fields = fields;
        this.m_autoIndex = autoIndex;
        this.m_monitorKeys = monitorKeystrokes;
        TupleSet search = vis.getGroup(searchGroup);
        if (search != null) {
            if (!(search instanceof SearchTupleSet)) throw new IllegalStateException("Search focus set not instance of SearchTupleSet!");
            this.m_searcher = (SearchTupleSet)search;
        } else {
            this.m_searcher = new PrefixSearchTupleSet();
            vis.addFocusGroup(searchGroup, this.m_searcher);
        }
        this.init(vis.getGroup(group));
    }

    private void init(TupleSet source) {
        if (this.m_autoIndex && source != null) {
            for (int i = 0; i < this.m_fields.length; ++i) {
                this.m_searcher.index(source.tuples(), this.m_fields[i]);
            }
            source.addTupleSetListener(new TupleSetListener(){

                public void tupleSetChanged(TupleSet tset, Tuple[] add, Tuple[] rem) {
                    int j;
                    int i;
                    if (add != null) {
                        for (i = 0; i < add.length; ++i) {
                            for (j = 0; j < JSearchPanel.this.m_fields.length; ++j) {
                                JSearchPanel.this.m_searcher.index(add[i], JSearchPanel.this.m_fields[j]);
                            }
                        }
                    }
                    if (rem != null && JSearchPanel.this.m_searcher.isUnindexSupported()) {
                        for (i = 0; i < rem.length; ++i) {
                            for (j = 0; j < JSearchPanel.this.m_fields.length; ++j) {
                                JSearchPanel.this.m_searcher.unindex(rem[i], JSearchPanel.this.m_fields[j]);
                            }
                        }
                    }
                }
            });
        }
        this.m_queryF.addActionListener(this);
        if (this.m_monitorKeys) {
            this.m_queryF.getDocument().addDocumentListener(this);
        }
        this.m_queryF.setMaximumSize(new Dimension(400, 100));
        this.m_queryF.setPreferredSize(new Dimension(200, 20));
        this.m_queryF.setBorder(null);
        this.setBackground(Color.WHITE);
        this.initUI();
    }

    private void initUI() {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 0));
        this.m_sbox.removeAll();
        this.m_sbox.add(Box.createHorizontalStrut(3));
        this.m_sbox.add(this.m_queryF);
        this.m_sbox.add(Box.createHorizontalStrut(3));
        if (this.m_showCancel) {
            this.m_sbox.add(new CancelButton());
            this.m_sbox.add(Box.createHorizontalStrut(3));
        }
        if (this.m_showBorder) {
            this.m_sbox.setBorder(BorderFactory.createLineBorder(this.getForeground()));
        } else {
            this.m_sbox.setBorder(null);
        }
        this.m_sbox.setMaximumSize(new Dimension(400, 100));
        this.m_sbox.setPreferredSize(new Dimension(171, 20));
        Box b = new Box(0);
        if (this.m_includeHitCount) {
            b.add(this.m_resultL);
            b.add(Box.createHorizontalStrut(10));
        }
        b.add(this.m_searchL);
        b.add(Box.createHorizontalStrut(3));
        b.add(this.m_sbox);
        this.add(b);
    }

    public void requestFocus() {
        this.m_queryF.requestFocus();
    }

    public void setLock(Object lock) {
        this.m_lock = lock;
    }

    public void setShowResultCount(boolean b) {
        this.m_includeHitCount = b;
        this.initUI();
        this.validate();
    }

    public void setShowBorder(boolean b) {
        this.m_showBorder = b;
        this.initUI();
        this.validate();
    }

    public void setShowCancel(boolean b) {
        this.m_showCancel = b;
        this.initUI();
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void searchUpdate() {
        String query = this.m_queryF.getText();
        Object object = this.m_lock;
        synchronized (object) {
            this.m_searcher.search(query);
            if (this.m_searcher.getQuery().length() == 0) {
                this.m_resultL.setText(null);
            } else {
                int r = this.m_searcher.getTupleCount();
                this.m_resultL.setText(r + " match" + (r == 1 ? "" : "es"));
            }
        }
    }

    public void setQuery(String query) {
        Document d = this.m_queryF.getDocument();
        d.removeDocumentListener(this);
        this.m_queryF.setText(query);
        d.addDocumentListener(this);
        this.searchUpdate();
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.m_queryF != null) {
            this.m_queryF.setBackground(bg);
        }
        if (this.m_resultL != null) {
            this.m_resultL.setBackground(bg);
        }
        if (this.m_searchL != null) {
            this.m_searchL.setBackground(bg);
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.m_queryF != null) {
            this.m_queryF.setForeground(fg);
            this.m_queryF.setCaretColor(fg);
        }
        if (this.m_resultL != null) {
            this.m_resultL.setForeground(fg);
        }
        if (this.m_searchL != null) {
            this.m_searchL.setForeground(fg);
        }
        if (this.m_sbox != null && this.m_showBorder) {
            this.m_sbox.setBorder(BorderFactory.createLineBorder(fg));
        }
    }

    public void setFont(Font f) {
        super.setFont(f);
        if (this.m_queryF != null) {
            this.m_queryF.setFont(f);
        }
        if (this.m_resultL != null) {
            this.m_resultL.setFont(f);
        }
        if (this.m_searchL != null) {
            this.m_searchL.setFont(f);
        }
    }

    public void setLabelText(String text) {
        this.m_searchL.setText(text);
    }

    public void changedUpdate(DocumentEvent e) {
        this.searchUpdate();
    }

    public void insertUpdate(DocumentEvent e) {
        this.searchUpdate();
    }

    public void removeUpdate(DocumentEvent e) {
        this.searchUpdate();
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_queryF) {
            this.searchUpdate();
        }
    }

    public class CancelButton
    extends JComponent
    implements MouseListener {
        private boolean hover = false;
        private int[] outline = new int[]{0, 0, 2, 0, 4, 2, 5, 2, 7, 0, 9, 0, 9, 2, 7, 4, 7, 5, 9, 7, 9, 9, 7, 9, 5, 7, 4, 7, 2, 9, 0, 9, 0, 7, 2, 5, 2, 4, 0, 2, 0, 0};
        private int[] fill = new int[]{1, 1, 8, 8, 1, 2, 7, 8, 2, 1, 8, 7, 7, 1, 1, 7, 8, 2, 2, 8, 1, 8, 8, 1};

        public CancelButton() {
            Dimension d = new Dimension(10, 10);
            this.setPreferredSize(d);
            this.setMinimumSize(d);
            this.setMaximumSize(d);
            this.setFocusable(false);
            this.addMouseListener(this);
        }

        public void paintComponent(Graphics g) {
            int i;
            if (this.hover) {
                g.setColor(ColorLib.getColor(255, 75, 75));
                i = 0;
                while (i + 3 < this.fill.length) {
                    g.drawLine(this.fill[i], this.fill[i + 1], this.fill[i + 2], this.fill[i + 3]);
                    i += 4;
                }
            }
            g.setColor(JSearchPanel.this.getForeground());
            i = 0;
            while (i + 3 < this.outline.length) {
                g.drawLine(this.outline[i], this.outline[i + 1], this.outline[i + 2], this.outline[i + 3]);
                i += 2;
            }
        }

        public void mouseClicked(MouseEvent arg0) {
            JSearchPanel.this.setQuery(null);
        }

        public void mousePressed(MouseEvent arg0) {
        }

        public void mouseReleased(MouseEvent arg0) {
        }

        public void mouseEntered(MouseEvent arg0) {
            this.hover = true;
            this.repaint();
        }

        public void mouseExited(MouseEvent arg0) {
            this.hover = false;
            this.repaint();
        }
    }
}

