/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.InputEvent;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class UILib {
    private UILib() {
    }

    public static boolean isButtonPressed(InputEvent e, int button) {
        return (e.getModifiers() & button) == button;
    }

    public static final void setPlatformLookAndFeel() {
        try {
            String laf = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Box getBox(Component[] c, boolean horiz, int margin, int spacing) {
        return UILib.getBox(c, horiz, margin, margin, spacing);
    }

    public static Box getBox(Component[] c, boolean horiz, int margin1, int margin2, int spacing) {
        Box b = new Box(horiz ? 0 : 1);
        UILib.addStrut((JComponent)b, horiz, margin1);
        for (int i = 0; i < c.length; ++i) {
            if (i > 0) {
                UILib.addStrut((JComponent)b, horiz, spacing);
                UILib.addGlue((JComponent)b, horiz);
            }
            b.add(c[i]);
        }
        UILib.addStrut((JComponent)b, horiz, margin2);
        return b;
    }

    public static void addStrut(JComponent b, boolean horiz, int size) {
        if (size < 1) {
            return;
        }
        b.add(horiz ? Box.createHorizontalStrut(size) : Box.createVerticalStrut(size));
    }

    public static void addGlue(JComponent b, boolean horiz) {
        b.add(horiz ? Box.createHorizontalGlue() : Box.createVerticalGlue());
    }

    public static void addStrut(JComponent b, int layout, int size) {
        if (size < 1) {
            return;
        }
        b.add(UILib.getAxis(b, layout) == 0 ? Box.createHorizontalStrut(size) : Box.createVerticalStrut(size));
    }

    public static void addGlue(JComponent b, int layout) {
        b.add(UILib.getAxis(b, layout) == 0 ? Box.createHorizontalGlue() : Box.createVerticalGlue());
    }

    public static int getAxis(JComponent c, int layout) {
        ComponentOrientation o = c.getComponentOrientation();
        switch (layout) {
            case 2: {
                return o.isHorizontal() ? 0 : 1;
            }
            case 3: {
                return o.isHorizontal() ? 1 : 0;
            }
        }
        return layout;
    }

    public static void setColor(Component c, Color back, Color fore) {
        c.setBackground(back);
        c.setForeground(fore);
        if (c instanceof Container) {
            Container con = (Container)c;
            for (int i = 0; i < con.getComponentCount(); ++i) {
                UILib.setColor(con.getComponent(i), back, fore);
            }
        }
    }

    public static void setFont(Component c, Font font) {
        c.setFont(font);
        if (c instanceof Container) {
            Container con = (Container)c;
            for (int i = 0; i < con.getComponentCount(); ++i) {
                UILib.setFont(con.getComponent(i), font);
            }
        }
    }
}

