/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.DefaultMBeanInterceptor;
import com.sun.jdmk.MBeanInstantiator;
import com.sun.jdmk.MBeanInterceptor;
import com.sun.jdmk.MBeanServerDelegateImpl;
import com.sun.jdmk.MBeanServerInt;
import com.sun.jdmk.MetaData;
import com.sun.jdmk.MetaDataImpl;
import com.sun.jdmk.ModifiableClassLoaderRepository;
import com.sun.jdmk.defaults.Utils;
import com.sun.jdmk.interceptor.MBeanServerInterceptor;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public class MBeanServerImpl
implements MBeanServer,
MBeanServerInt {
    private transient MBeanInterceptor interceptor = null;
    private final String dbgTag = "MBeanServer";
    private MBeanInstantiator instantiator = null;
    private MetaData meta = null;
    private transient MBeanServerDelegate MBeanServerDelegateObject = null;
    private transient ObjectName MBeanServerDelegateObjectName = null;
    private transient SecureClassLoaderRepository secureClr = null;

    public MBeanServerImpl(MBeanInstantiator mBeanInstantiator) {
        this(mBeanInstantiator, null);
    }

    public MBeanServerImpl(MBeanInstantiator mBeanInstantiator, String string) {
        this(mBeanInstantiator, null, string);
    }

    public MBeanServerImpl(MBeanInstantiator mBeanInstantiator, MetaData metaData, String string) {
        this.initialize(mBeanInstantiator, metaData, string);
    }

    public MBeanInstantiator getMBeanInstantiator() {
        return this.instantiator;
    }

    public MetaData getMetaData() {
        return this.meta;
    }

    public synchronized MBeanInterceptor getDefaultMBeanInterceptor() {
        return this.interceptor;
    }

    public synchronized void setDefaultMBeanInterceptor(MBeanInterceptor mBeanInterceptor) throws IllegalArgumentException {
        if (mBeanInterceptor == null) {
            throw new IllegalArgumentException("Null MBeanInterceptor");
        }
        this.interceptor = mBeanInterceptor;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.interceptor.createMBean(string, objectName, null, null);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.interceptor.createMBean(string, objectName, objectName2, null, null);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.interceptor.createMBean(string, objectName, objectArray, stringArray);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.interceptor.createMBean(string, objectName, objectName2, objectArray, stringArray);
    }

    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.interceptor.registerMBean(object, objectName);
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.interceptor.unregisterMBean(objectName);
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        return this.interceptor.getObjectInstance(objectName);
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        return this.interceptor.queryMBeans(objectName, queryExp);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        return this.interceptor.queryNames(objectName, queryExp);
    }

    public boolean isRegistered(ObjectName objectName) {
        return this.interceptor.isRegistered(objectName);
    }

    public Integer getMBeanCount() {
        return this.interceptor.getMBeanCount();
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.interceptor.getAttribute(objectName, string);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        return this.interceptor.getAttributes(objectName, stringArray);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.interceptor.setAttribute(objectName, attribute);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        return this.interceptor.setAttributes(objectName, attributeList);
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.interceptor.invoke(objectName, string, objectArray, stringArray);
    }

    public String getDefaultDomain() {
        return this.interceptor.getDefaultDomain();
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        this.interceptor.addNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        this.interceptor.addNotificationListener(objectName, objectName2, notificationFilter, object);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.interceptor.removeNotificationListener(objectName, notificationListener);
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        this.interceptor.removeNotificationListener(objectName, objectName2);
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.interceptor.getMBeanInfo(objectName);
    }

    public Object instantiate(String string) throws ReflectionException, MBeanException {
        return this.instantiator.instantiate(string);
    }

    public Object instantiate(String string, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.instantiator.instantiate(string, objectName, this.getClass().getClassLoader());
    }

    public Object instantiate(String string, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException {
        return this.instantiator.instantiate(string, objectArray, stringArray, this.getClass().getClassLoader());
    }

    public Object instantiate(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.instantiator.instantiate(string, objectName, objectArray, stringArray, this.getClass().getClassLoader());
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        return this.interceptor.isInstanceOf(objectName, string);
    }

    public ObjectInputStream deserialize(ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException {
        return this.instantiator.deserialize(objectName, byArray);
    }

    public ObjectInputStream deserialize(String string, byte[] byArray) throws OperationsException, ReflectionException {
        return this.instantiator.deserialize(string, byArray);
    }

    public ObjectInputStream deserialize(String string, ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException, ReflectionException {
        return this.instantiator.deserialize(string, objectName, byArray, this.getClass().getClassLoader());
    }

    public ClassLoader getMBeanClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        return this.interceptor.getMBeanClassLoader(objectName);
    }

    private void initialize(MBeanInstantiator mBeanInstantiator, MetaData metaData, String string) {
        this.instantiator = mBeanInstantiator;
        if (mBeanInstantiator == null) {
            throw new IllegalArgumentException("instantiator must not be null.");
        }
        this.meta = metaData == null ? new MetaDataImpl(mBeanInstantiator) : metaData;
        this.secureClr = new SecureClassLoaderRepository(mBeanInstantiator.getClassLoaderRepository());
        this.interceptor = string != null ? new DefaultMBeanInterceptor(this, string) : new DefaultMBeanInterceptor(this);
        try {
            this.MBeanServerDelegateObject = new MBeanServerDelegateImpl(new MBeanServerDelegate());
            this.MBeanServerDelegateObjectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            this.interceptor.registerMBean(this.MBeanServerDelegateObject, this.MBeanServerDelegateObjectName);
        }
        catch (JMException jMException) {
            RuntimeException runtimeException = new RuntimeException("Unexpected JMException: " + jMException);
            Utils.initCause(runtimeException, jMException);
            throw runtimeException;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        ModifiableClassLoaderRepository modifiableClassLoaderRepository = mBeanInstantiator.getClassLoaderRepository();
        if (modifiableClassLoaderRepository != null && classLoader != null) {
            modifiableClassLoaderRepository.addClassLoader(classLoader);
        }
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        return this.secureClr;
    }

    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        return this.interceptor.getMBeanClassLoader(objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        ClassLoader classLoader;
        if (this.interceptor instanceof MBeanServerInterceptor) {
            return ((MBeanServerInterceptor)this.interceptor).getClassLoader(objectName);
        }
        ModifiableClassLoaderRepository modifiableClassLoaderRepository = this.instantiator.getClassLoaderRepository();
        MBeanInstantiator mBeanInstantiator = this.instantiator;
        synchronized (mBeanInstantiator) {
            classLoader = modifiableClassLoaderRepository.getClassLoader(objectName);
        }
        if (classLoader == null) {
            throw new InstanceNotFoundException("The loader named " + objectName + " is not registered in the MBeanServer");
        }
        return classLoader;
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.interceptor instanceof MBeanServerInterceptor) {
            ((MBeanServerInterceptor)this.interceptor).removeNotificationListener(objectName, notificationListener, notificationFilter, object);
            return;
        }
        throw new UnsupportedOperationException("Operation not supported in this implementation");
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.interceptor instanceof MBeanServerInterceptor) {
            ((MBeanServerInterceptor)this.interceptor).removeNotificationListener(objectName, objectName2, notificationFilter, object);
            return;
        }
        throw new UnsupportedOperationException("Operation not supported in this implementation");
    }

    public String[] getDomains() {
        if (this.interceptor instanceof MBeanServerInterceptor) {
            return ((MBeanServerInterceptor)this.interceptor).getDomains();
        }
        Set set = this.interceptor.queryNames(null, null);
        HashSet<String> hashSet = new HashSet<String>(1);
        String[] stringArray = set.iterator();
        while (stringArray.hasNext()) {
            ObjectName objectName = (ObjectName)stringArray.next();
            String string = objectName.getDomain();
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
        }
        stringArray = new String[hashSet.size()];
        return hashSet.toArray(stringArray);
    }

    public MBeanServerDelegate getMBeanServerDelegate() {
        return this.MBeanServerDelegateObject;
    }

    static final class SecureClassLoaderRepository
    implements ClassLoaderRepository {
        private final ClassLoaderRepository clr;

        public SecureClassLoaderRepository(ClassLoaderRepository classLoaderRepository) {
            this.clr = classLoaderRepository;
        }

        public final Class loadClass(String string) throws ClassNotFoundException {
            return this.clr.loadClass(string);
        }

        public final Class loadClassWithout(ClassLoader classLoader, String string) throws ClassNotFoundException {
            return this.clr.loadClassWithout(classLoader, string);
        }

        public final Class loadClassBefore(ClassLoader classLoader, String string) throws ClassNotFoundException {
            return this.clr.loadClassBefore(classLoader, string);
        }
    }
}

