/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpDefinitions;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.Timestamp;
import com.sun.management.snmp.manager.ReqRedirectSrv;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpRequest;
import com.sun.management.snmp.manager.SnmpRequestHandler;
import com.sun.management.snmp.manager.SnmpSession;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

final class SnmpTooBig
implements SnmpRequestHandler,
SnmpDefinitions,
ReqRedirectSrv,
Serializable {
    private static final long serialVersionUID = -4852815251485423081L;
    String dbgTag = "SnmpTooBig";
    private SnmpRequest _rootRequest;
    private Vector _subRequestList;
    static final String nl = "\n";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpTooBig");

    public SnmpTooBig(SnmpRequest snmpRequest, SnmpVarBindList snmpVarBindList) throws SnmpStatusException {
        int n;
        this._rootRequest = snmpRequest;
        if (logger.finerOn()) {
            logger.finer("constructor", "Initializing too-big handler");
        }
        if ((n = snmpVarBindList.size()) < 2) {
            throw new SnmpStatusException("VarBindList has only one element...");
        }
        SnmpVarBindList snmpVarBindList2 = new SnmpVarBindList(snmpVarBindList);
        this._subRequestList = new Vector();
        SnmpVarBindList snmpVarBindList3 = snmpVarBindList2.splitAt(n / 2);
        SnmpRequest snmpRequest2 = this.createRequest();
        SnmpRequest snmpRequest3 = this.createRequest();
        this._subRequestList.addElement(snmpRequest2);
        this._subRequestList.addElement(snmpRequest3);
        snmpRequest2.start(snmpVarBindList2, false, 0L);
        snmpRequest3.start(snmpVarBindList3, false, 0L);
        if (logger.finerOn()) {
            logger.finer("constructor", "Root = " + this._rootRequest.getRequestId() + ", Request = " + this.subRequestToString());
        }
    }

    public final SnmpPeer getPeer() {
        return this._rootRequest.getPeer();
    }

    public final SnmpSession getSnmpSession() {
        return this._rootRequest.getSnmpSession();
    }

    public final int getCommand() {
        return this._rootRequest.getCommand();
    }

    public synchronized void cancel() {
        Enumeration enumeration = this._subRequestList.elements();
        while (enumeration.hasMoreElements()) {
            SnmpRequest snmpRequest = (SnmpRequest)enumeration.nextElement();
            if (!snmpRequest.inProgress()) continue;
            snmpRequest.cancelRequest();
        }
    }

    public synchronized void cancel(SnmpRequest snmpRequest) {
        this.cancel();
    }

    private synchronized void doSubRequests(SnmpVarBindList snmpVarBindList, SnmpRequest snmpRequest) throws SnmpStatusException {
        int n = snmpVarBindList.size();
        if (n < 2) {
            throw new SnmpStatusException("VarBindList has only one element...");
        }
        SnmpVarBindList snmpVarBindList2 = snmpVarBindList.splitAt(n / 2);
        if (logger.finerOn()) {
            logger.finer("doSubRequests", "Root = " + this._rootRequest.getRequestId() + "\nAfter spliting varBind: first half:" + snmpVarBindList.varBindListToString() + "\nsecond half:" + snmpVarBindList2.varBindListToString());
        }
        SnmpRequest snmpRequest2 = this.createRequest();
        if (snmpRequest == null) {
            snmpRequest = this.createRequest();
        }
        this.addRequest(snmpRequest, snmpRequest2);
        snmpRequest.start(snmpVarBindList, false, 0L);
        snmpRequest2.start(snmpVarBindList2, false, 0L);
        if (logger.finerOn()) {
            logger.finer("doSubRequests", "Root = " + this._rootRequest.getRequestId() + ", Request = " + this.subRequestToString());
        }
    }

    private synchronized void addRequest(SnmpRequest snmpRequest, SnmpRequest snmpRequest2) {
        int n = this._subRequestList.indexOf(snmpRequest);
        if (n < 0) {
            this._subRequestList.addElement(snmpRequest);
            this._subRequestList.addElement(snmpRequest2);
        } else {
            this._subRequestList.insertElementAt(snmpRequest2, ++n);
        }
    }

    private synchronized SnmpRequest createRequest() throws SnmpStatusException {
        SnmpRequest snmpRequest = null;
        snmpRequest = new SnmpRequest(this.getSnmpSession(), this.getPeer(), this, this.getCommand());
        int n = this._rootRequest.getOptions();
        snmpRequest.setOptions(n & 0xFFFFFFFB);
        snmpRequest.setInternalRequest();
        if (logger.finerOn()) {
            logger.finer("createRequest", "Root = " + this._rootRequest.getRequestId() + ", Created a new sub-request for toobig handling");
        }
        return snmpRequest;
    }

    public final synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(500);
        boolean bl = false;
        return stringBuffer.toString();
    }

    public synchronized void processSnmpPollData(SnmpRequest snmpRequest, int n, int n2, SnmpVarBindList snmpVarBindList) {
        switch (n) {
            case 0: {
                this.handleSuccess(snmpRequest, snmpVarBindList);
                break;
            }
            case 1: 
            case 228: 
            case 231: {
                if (snmpVarBindList.size() > 2) {
                    if (logger.finerOn()) {
                        logger.finer("processSnmpPollData", "Root = " + this._rootRequest.getRequestId() + ", Too-big error within too-big handler");
                    }
                    try {
                        this.doSubRequests(snmpVarBindList, snmpRequest);
                    }
                    catch (Exception exception) {
                        if (logger.finestOn()) {
                            logger.finest("processSnmpPollData", exception);
                        }
                        this.processSnmpInternalError(snmpRequest, "Creating sub-requests to handle too-big error");
                    }
                    break;
                }
                if (logger.finerOn()) {
                    logger.finer("processSnmpPollData", "Root = " + this._rootRequest.getRequestId() + ", Too-big error within too-big handler : varBindList size = 1");
                }
                this.handleError(snmpRequest, 232, 0);
                break;
            }
            default: {
                this.handleError(snmpRequest, n, n2);
            }
        }
    }

    public synchronized void processSnmpPollTimeout(SnmpRequest snmpRequest) {
        this.cancel();
        this.operationComplete(224, 0, snmpRequest.getPollTimestamp());
    }

    public synchronized void processSnmpInternalError(SnmpRequest snmpRequest, String string) {
        this.cancel();
        this.operationComplete(240, 0, snmpRequest.getPollTimestamp());
    }

    synchronized void handleError(SnmpRequest snmpRequest, int n, int n2) {
        int n3 = 0;
        this.cancel();
        if (n2 >= 0) {
            n3 = this.determineRealIndex(snmpRequest) + n2;
        }
        if (logger.finestOn()) {
            logger.finest("handleError", "Root = " + this._rootRequest.getRequestId() + ", Error occured while handling too-big error");
        }
        this.operationComplete(n, n3, snmpRequest.getPollTimestamp());
    }

    synchronized void handleSuccess(SnmpRequest snmpRequest, SnmpVarBindList snmpVarBindList) {
        if (this.checkRemainingRequests(snmpRequest)) {
            Timestamp timestamp = snmpVarBindList.getTimestamp();
            this._rootRequest.getVarBindList().setTimestamp(timestamp);
            this.operationComplete(0, 0, snmpRequest.getPollTimestamp());
            return;
        }
    }

    synchronized boolean checkRemainingRequests(SnmpRequest snmpRequest) {
        Enumeration enumeration = this._subRequestList.elements();
        while (enumeration.hasMoreElements()) {
            SnmpRequest snmpRequest2 = (SnmpRequest)enumeration.nextElement();
            if (snmpRequest2 == snmpRequest || !snmpRequest2.inProgress()) continue;
            return false;
        }
        return true;
    }

    synchronized int determineRealIndex(SnmpRequest snmpRequest) {
        SnmpRequest snmpRequest2;
        int n = 0;
        Enumeration enumeration = this._subRequestList.elements();
        while (enumeration.hasMoreElements() && (snmpRequest2 = (SnmpRequest)enumeration.nextElement()) != snmpRequest) {
            n += snmpRequest2.getVarBindList().size();
        }
        return n;
    }

    synchronized String subRequestToString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        Enumeration enumeration = this._subRequestList.elements();
        while (enumeration.hasMoreElements()) {
            SnmpRequest snmpRequest = (SnmpRequest)enumeration.nextElement();
            stringBuffer.append("/" + snmpRequest.getRequestId());
        }
        return stringBuffer.toString();
    }

    private void operationComplete(int n, int n2, long l) {
        this._rootRequest.setErrorStatusAndIndex(n, n2);
        this._rootRequest.setPreviousPollTimestamp(l);
        this._rootRequest.invokeOnResponse(null);
    }
}

