/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.mpm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpDecryptedPdu;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.internal.snmp.SnmpIncomingRequest;
import com.sun.management.internal.snmp.SnmpSecurityCache;
import com.sun.management.internal.snmp.SnmpSecuritySubSystem;
import com.sun.management.snmp.SnmpBadSecurityLevelException;
import com.sun.management.snmp.SnmpMsg;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpScopedPduRequest;
import com.sun.management.snmp.SnmpSecurityException;
import com.sun.management.snmp.SnmpSecurityParameters;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.SnmpUnknownSecModelException;
import com.sun.management.snmp.mpm.SnmpMsgTranslator;
import java.net.InetAddress;

class SnmpIncomingRequestImpl
implements SnmpIncomingRequest {
    SnmpMsg req = null;
    SnmpMsg resp = null;
    SnmpSecuritySubSystem secureSubSys = null;
    SnmpMsgTranslator translator = null;
    String principal = null;
    SnmpSecurityCache cache = null;
    boolean isReport = false;
    boolean isResponse = true;
    SnmpSecurityParameters secParams = null;
    SnmpPduFactory factory = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpIncomingRequestImpl");
    String dbgTag = "SnmpIncomingRequestImpl";

    public SnmpIncomingRequestImpl(SnmpSecuritySubSystem snmpSecuritySubSystem, SnmpPduFactory snmpPduFactory, SnmpMsg snmpMsg, SnmpMsg snmpMsg2, SnmpMsgTranslator snmpMsgTranslator) {
        this.secureSubSys = snmpSecuritySubSystem;
        this.factory = snmpPduFactory;
        this.req = snmpMsg;
        this.resp = snmpMsg2;
        this.translator = snmpMsgTranslator;
    }

    public SnmpSecurityParameters getSecurityParameters() {
        return this.secParams;
    }

    public boolean isReport() {
        return this.isReport;
    }

    public boolean isResponse() {
        return this.isResponse;
    }

    public void noResponse() {
        this.isResponse = false;
    }

    public int getSecurityLevel() {
        return this.translator.getSecurityLevel(this.req);
    }

    public byte[] getContextEngineId() {
        return this.translator.getContextEngineId(this.req);
    }

    public int getSecurityModel() {
        return this.translator.getMsgSecurityModel(this.req);
    }

    private void handleReport(SnmpMsg snmpMsg, SnmpSecurityException snmpSecurityException) throws SnmpStatusException {
        if ((this.translator.getMsgFlags(snmpMsg) & 2) != 0) {
            if ((this.translator.getMsgFlags(snmpMsg) & 4) != 0) {
                if (logger.finestOn()) {
                    logger.finest("handleReport", "Report to send. Encryption + flag set");
                }
                this.constructReport(snmpMsg, snmpSecurityException, null);
                return;
            }
            if (logger.finestOn()) {
                logger.finest("handleReport", "No Report to send. No flag set");
            }
            throw new SnmpStatusException("Security failed");
        }
        SnmpPdu snmpPdu = this.factory.decodeSnmpPdu(snmpMsg);
        if (snmpPdu == null && (this.translator.getMsgFlags(snmpMsg) & 4) != 0) {
            if (logger.finestOn()) {
                logger.finest("handleReport", "Can't decode pdu. Flag set");
            }
            this.constructReport(snmpMsg, snmpSecurityException, null);
            return;
        }
        if (snmpPdu.type != 160 && snmpPdu.type != 161 && snmpPdu.type != 163 && snmpPdu.type != 165 && snmpPdu.type != 166) {
            if (logger.finestOn()) {
                logger.finest("handleReport", "Not a confirmed pdu class [ " + snmpPdu.type + "]. No report to send");
            }
            throw new SnmpStatusException("Security failed");
        }
        this.constructReport(this.req, snmpSecurityException, snmpPdu);
    }

    private void constructReport(SnmpMsg snmpMsg, SnmpSecurityException snmpSecurityException, SnmpPdu snmpPdu) throws SnmpStatusException {
        if (logger.finerOn()) {
            logger.finer("constructReport", "Report to send. Exception: " + snmpSecurityException + " Security parameters : " + snmpSecurityException.params);
        }
        this.isReport = true;
        SnmpScopedPduRequest snmpScopedPduRequest = new SnmpScopedPduRequest();
        snmpScopedPduRequest.address = snmpMsg.address;
        snmpScopedPduRequest.port = snmpMsg.port;
        if (snmpPdu != null) {
            snmpScopedPduRequest.requestId = snmpPdu.requestId;
        }
        snmpScopedPduRequest.version = 3;
        snmpScopedPduRequest.msgId = this.translator.getMsgId(snmpMsg);
        snmpScopedPduRequest.type = 168;
        snmpScopedPduRequest.varBindList = snmpSecurityException.list;
        snmpScopedPduRequest.contextEngineId = snmpSecurityException.contextEngineId;
        snmpScopedPduRequest.contextName = snmpSecurityException.contextName;
        snmpScopedPduRequest.msgFlags = (byte)(snmpSecurityException.flags & 3);
        snmpScopedPduRequest.msgMaxSize = this.translator.getMsgMaxSize(snmpMsg);
        snmpScopedPduRequest.msgSecurityModel = this.translator.getMsgSecurityModel(snmpMsg);
        snmpScopedPduRequest.securityParameters = snmpSecurityException.params;
        if (logger.finerOn()) {
            logger.finer("constructReport", " Security parameters : " + snmpScopedPduRequest.securityParameters);
        }
        snmpScopedPduRequest.setErrorIndex(0);
        snmpScopedPduRequest.setErrorStatus(0);
        try {
            this.resp.encodeSnmpPdu(snmpScopedPduRequest, this.translator.getMsgMaxSize(snmpMsg));
        }
        catch (SnmpTooBigException snmpTooBigException) {
            throw new SnmpStatusException("Too Big when sending report");
        }
    }

    public byte[] getContextName() {
        return this.translator.getContextName(this.req);
    }

    public byte[] getAccessContext() {
        return this.translator.getAccessContext(this.req);
    }

    public String getPrincipal() {
        return this.secParams.getPrincipal();
    }

    public int encodeMessage(byte[] byArray) throws SnmpTooBigException {
        int n = 0;
        try {
            n = this.secureSubSys.generateResponseMsg(this.cache, this.resp.version, this.translator.getMsgId(this.resp), this.translator.getMsgMaxSize(this.resp), (byte)(this.translator.getMsgFlags(this.resp) & 3), this.translator.getMsgSecurityModel(this.resp), this.translator.getSecurityParameters(this.resp), this.translator.getContextEngineId(this.resp), this.translator.getRawContextName(this.resp), this.resp.data, this.resp.dataLength, byArray);
            this.secureSubSys.releaseSecurityCache(this.translator.getMsgSecurityModel(this.req), this.cache);
        }
        catch (SnmpStatusException snmpStatusException) {
            this.isResponse = false;
        }
        catch (SnmpSecurityException snmpSecurityException) {
            this.isResponse = false;
        }
        catch (SnmpUnknownSecModelException snmpUnknownSecModelException) {
            this.isResponse = false;
        }
        return n;
    }

    public void decodeMessage(byte[] byArray, int n, InetAddress inetAddress, int n2) throws SnmpStatusException, SnmpUnknownSecModelException, SnmpBadSecurityLevelException {
        this.req.address = inetAddress;
        this.req.port = n2;
        this.req.decodeMessage(byArray, n);
        this.cache = this.secureSubSys.createSecurityCache(this.translator.getMsgSecurityModel(this.req));
        SnmpDecryptedPdu snmpDecryptedPdu = new SnmpDecryptedPdu();
        SnmpEngineImpl.checkSecurityLevel(this.translator.getMsgFlags(this.req));
        try {
            this.secParams = this.secureSubSys.processIncomingRequest(this.cache, this.req.version, this.translator.getMsgId(this.req), this.translator.getMsgMaxSize(this.req), this.translator.getMsgFlags(this.req), this.translator.getMsgSecurityModel(this.req), this.translator.getFlatSecurityParameters(this.req), this.translator.getContextEngineId(this.req), this.translator.getContextName(this.req), this.req.data, this.translator.getEncryptedPdu(this.req), snmpDecryptedPdu);
        }
        catch (SnmpSecurityException snmpSecurityException) {
            if (logger.finestOn()) {
                logger.finest("decodeMessage", "Security error: " + snmpSecurityException + ", Msg flags: " + this.translator.getMsgFlags(this.req));
            }
            this.isResponse = false;
            this.handleReport(this.req, snmpSecurityException);
            return;
        }
        catch (SnmpStatusException snmpStatusException) {
            this.isResponse = false;
            throw snmpStatusException;
        }
        this.req.securityParameters = this.secParams;
        if (snmpDecryptedPdu.data != null) {
            this.req.data = snmpDecryptedPdu.data;
            this.translator.setContextName(this.req, snmpDecryptedPdu.contextName);
            this.translator.setContextEngineId(this.req, snmpDecryptedPdu.contextEngineId);
        }
    }

    public SnmpMsg encodeSnmpPdu(SnmpPdu snmpPdu, int n) throws SnmpStatusException, SnmpTooBigException {
        this.resp = this.factory.encodeSnmpPdu(snmpPdu, n);
        return this.resp;
    }

    public SnmpPdu decodeSnmpPdu() throws SnmpStatusException {
        return this.factory.decodeSnmpPdu(this.req);
    }

    public String printRequestMessage() {
        return this.req.printMessage();
    }

    public String printResponseMessage() {
        return this.resp.printMessage();
    }
}

