/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.Time;
import com.sun.perseus.model.TimeInstance;
import com.sun.perseus.model.TimeInterval;
import com.sun.perseus.model.TimedElementSupport;

final class IntervalTimeInstance
extends TimeInstance {
    long offset;
    TimeInterval timeInterval;
    boolean isBeginSync;
    TimedElementSupport syncBase;

    IntervalTimeInstance(TimedElementSupport timedElement, TimedElementSupport syncBase, long offset, boolean clearOnReset, boolean isBegin, boolean isBeginSync) {
        super(timedElement, IntervalTimeInstance.getTime(syncBase.currentInterval, isBeginSync, offset, timedElement, syncBase), clearOnReset, isBegin);
        this.offset = offset;
        this.syncBase = syncBase;
        this.timeInterval = syncBase.currentInterval;
        this.isBeginSync = isBeginSync;
        this.timeInterval.addDependent(this);
    }

    void dispose() {
        this.timeInterval.removeDependent(this);
    }

    private static Time getTime(TimeInterval interval, boolean isBeginSync, long offset, TimedElementSupport timedElement, TimedElementSupport syncBase) {
        if (isBeginSync && !interval.begin.isResolved()) {
            throw new IllegalStateException();
        }
        Time t = interval.begin;
        if (!isBeginSync) {
            t = interval.end;
        }
        if (!t.isResolved()) {
            return t;
        }
        Time time = new Time(t.value + offset);
        return timedElement.toContainerSimpleTime(syncBase.toRootContainerSimpleTime(time));
    }

    void syncTime() {
        this.setTime(IntervalTimeInstance.getTime(this.timeInterval, this.isBeginSync, this.offset, this.timedElement, this.syncBase));
    }

    void onIntervalUpdate() {
        this.setTime(IntervalTimeInstance.getTime(this.timeInterval, this.isBeginSync, this.offset, this.timedElement, this.syncBase));
    }
}

