/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev.gen;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class WriteIfDifferentOutputStream
extends OutputStream {
    private RandomAccessFile randFile;
    private long initialRandFileLength;
    private boolean justWrite = false;
    private byte[] writeBuf;
    private int lastLen = -1;

    public WriteIfDifferentOutputStream(RandomAccessFile randFile) throws IOException {
        this.randFile = randFile;
        this.initialRandFileLength = randFile.length();
    }

    public WriteIfDifferentOutputStream(String filename) throws IOException {
        this(new RandomAccessFile(filename, "rw"));
    }

    public WriteIfDifferentOutputStream(File file) throws IOException {
        this(new RandomAccessFile(file, "rw"));
    }

    public void write(int b) throws IOException {
        if (this.justWrite) {
            this.randFile.write(b);
            return;
        }
        long fp = this.randFile.getFilePointer();
        if (fp + 1L > this.initialRandFileLength) {
            this.justWrite = true;
            this.randFile.write(b);
            return;
        }
        int fromFile = this.randFile.read();
        if (fromFile != b) {
            this.randFile.seek(fp);
            this.randFile.write(b);
            this.justWrite = true;
            return;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.justWrite) {
            this.randFile.write(b, off, len);
            return;
        }
        long fp = this.randFile.getFilePointer();
        if (fp + (long)len > this.initialRandFileLength) {
            this.justWrite = true;
            this.randFile.write(b, off, len);
            return;
        }
        if (len > this.lastLen) {
            this.writeBuf = new byte[len];
            this.lastLen = len;
        }
        this.randFile.read(this.writeBuf, 0, len);
        int i = off;
        for (int j = 0; j < len; ++j) {
            if (this.writeBuf[j] != b[i]) {
                this.randFile.seek(fp);
                this.randFile.write(b, off, len);
                this.justWrite = true;
                return;
            }
            ++i;
        }
    }

    public boolean isChanged() {
        return this.justWrite;
    }

    public void close() throws IOException {
        if (this.randFile.getFilePointer() < this.randFile.length()) {
            this.justWrite = true;
            this.randFile.setLength(this.randFile.getFilePointer());
        }
        this.randFile.close();
    }
}

