/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.workflow.model.impl;

import com.sun.jbi.workflow.model.LocalNotification;
import com.sun.jbi.workflow.model.ModelElement;
import com.sun.jbi.workflow.model.ModelException;
import com.sun.jbi.workflow.model.ModelUtil;
import com.sun.jbi.workflow.model.Task;
import com.sun.jbi.workflow.model.Timeout;
import com.sun.jbi.workflow.model.impl.LocalNotificationImpl;
import com.sun.jbi.workflow.model.impl.ModelElementImpl;
import com.sun.jbi.workflow.model.xmlbeans.TDeadlineExpr;
import com.sun.jbi.workflow.model.xmlbeans.TDurationExpr;
import com.sun.jbi.workflow.model.xmlbeans.TLocalNotification;
import com.sun.jbi.workflow.model.xmlbeans.TTimeout;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.xmlbeans.GDuration;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeoutImpl
extends ModelElementImpl
implements Timeout {
    private TTimeout mTimeout;
    private Task mParent;
    private Date mDeadline;
    private GDuration mDuration;
    private List<LocalNotification> mLocalNotifications = new ArrayList<LocalNotification>();

    public TimeoutImpl(TTimeout timeout, Task parent) {
        super((XmlObject)timeout, parent);
        this.mTimeout = timeout;
        this.mParent = parent;
    }

    @Override
    public Date getDeadlineObject() throws ModelException {
        try {
            if (this.mDeadline == null) {
                TDeadlineExpr deadlineExp = this.mTimeout.getDeadline();
                this.mDeadline = ModelUtil.getDeadlineObject(deadlineExp, this.getTask().getJXpathContext());
            }
        }
        catch (Exception ex) {
            throw new ModelException(ex);
        }
        return this.mDeadline;
    }

    @Override
    public GDuration getDurationObject() throws ModelException {
        try {
            if (this.mDuration == null) {
                TDurationExpr durationExp = this.mTimeout.getDuration();
                this.mDuration = ModelUtil.getDurationObject(durationExp, this.getTask().getJXpathContext());
            }
        }
        catch (Exception ex) {
            throw new ModelException(ex);
        }
        return this.mDuration;
    }

    @Override
    public Date getDurationDate() throws ModelException {
        return ModelUtil.getDurationDate(this.getDurationObject());
    }

    @Override
    public List<LocalNotification> getLocalNotifications() {
        if (this.mLocalNotifications.size() == 0) {
            List lnList = this.mTimeout.getLocalNotificationList();
            for (TLocalNotification ln : lnList) {
                LocalNotificationImpl localNotification = new LocalNotificationImpl(ln, (ModelElement)this);
                this.mLocalNotifications.add(localNotification);
            }
        }
        return this.mLocalNotifications;
    }

    @Override
    public Task getTask() {
        return (Task)this.getParent();
    }
}

