/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import java.io.PrintWriter;
import org.netbeans.apitest.ErrorMessage;
import org.netbeans.apitest.SignatureConstants;

class ErrorFormatter
implements SignatureConstants {
    String[] messages = new String[]{"Required class not found in implementation: ", "Definition required but not found in ", "Definition required but not found in ", "Definition required but not found in ", "Definition required but not found in ", "Definition required but not found in ", "Found class not permitted in implementation: ", "Definition found but not permitted in ", "Definition found but not permitted in ", "Definition found but not permitted in ", "Definition found but not permitted in ", "Definition found but not permitted in ", "LinkageError does not allow to track definition in "};
    PrintWriter out;
    int size;

    public ErrorFormatter(PrintWriter out) {
        this.out = out;
        this.size = 0;
    }

    public ErrorFormatter(PrintWriter out, String[] messages) {
        this.out = out;
        this.size = 0;
        this.messages = messages;
    }

    public void addError(String errorType, String className, String def, String tail) {
        this.out.println(this.createError(errorType, className, def, tail));
        ++this.size;
    }

    public void addError(ErrorMessage msg) {
        this.out.println(msg);
        ++this.size;
    }

    public void setMessages(String[] messages) {
        this.messages = messages;
    }

    protected ErrorMessage createError(String errorType, String className, String def, String tail) {
        int errorDeg = 0;
        if (def != null) {
            if (def.startsWith("innr ") || def.startsWith("CLSS ")) {
                errorDeg = 1;
            }
            if (def.startsWith("supr ") || def.startsWith("intf ")) {
                errorDeg = 2;
            }
            if (def.startsWith("fld  ")) {
                errorDeg = 3;
            }
            if (def.startsWith("cons ")) {
                errorDeg = 4;
            }
            if (def.startsWith("meth ")) {
                errorDeg = 5;
            }
        }
        if (!errorType.equals("Missing")) {
            errorDeg += 6;
        }
        if (errorType.equals("LinkageError")) {
            errorDeg = 12;
        }
        ErrorMessage er = new ErrorMessage(errorDeg, className, def, tail);
        er.setMessages(this.messages);
        return er;
    }

    public int printErrors() {
        return this.size;
    }

    public static String toString(String label) {
        for (int i = 0; i < prefixes.length; ++i) {
            if (!label.startsWith(prefixes[i][0])) continue;
            return prefixes[i][1] + label.substring(prefixes[i][0].length());
        }
        return label;
    }
}

