/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import org.netbeans.apitest.ClassConstants;
import org.netbeans.apitest.ClassFinder;
import org.netbeans.apitest.DefinitionFormat;
import org.netbeans.apitest.MemberEntry;

final class SignatureClass
implements ClassConstants {
    Class classObject;
    protected DefinitionFormat filter;
    protected Properties details;
    private ClassFinder loader;

    SignatureClass(Class classObject, DefinitionFormat filter, ClassFinder loader, Properties details) {
        this.details = details;
        this.classObject = classObject;
        this.filter = filter;
        this.loader = loader;
    }

    protected SignatureClass() {
    }

    public MemberEntry getMemberEntry(boolean isNestedClass) {
        return new MemberEntry(this, this.filter, isNestedClass);
    }

    public MemberEntry[] getDeclaredMethods() {
        Method[] methods = this.classObject.getDeclaredMethods();
        MemberEntry[] retVal = new MemberEntry[methods.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = new MemberEntry(methods[i], this.filter);
        }
        return retVal;
    }

    public MemberEntry[] getDeclaredFields() {
        Field[] fields = this.classObject.getDeclaredFields();
        MemberEntry[] retVal = new MemberEntry[fields.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = new MemberEntry(fields[i], this.filter);
        }
        return retVal;
    }

    public SignatureClass[] getDeclaredClasses() {
        Class<?>[] nested = this.classObject.getDeclaredClasses();
        SignatureClass[] retVal = new SignatureClass[nested.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = new SignatureClass(nested[i], this.filter, this.loader, this.details);
        }
        return retVal;
    }

    public MemberEntry[] getDeclaredConstructors() {
        Constructor<?>[] ctors = this.classObject.getDeclaredConstructors();
        MemberEntry[] retVal = new MemberEntry[ctors.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = new MemberEntry(ctors[i], this.filter);
        }
        return retVal;
    }

    public SignatureClass[] getInterfaces() {
        Class<?>[] interfaces = this.classObject.getInterfaces();
        SignatureClass[] retVal = new SignatureClass[interfaces.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = new SignatureClass(interfaces[i], this.filter, this.loader, this.details);
        }
        return retVal;
    }

    public MemberEntry[] getMethods() {
        Method[] methods = this.classObject.getMethods();
        MemberEntry[] retVal = new MemberEntry[methods.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = new MemberEntry(methods[i], this.filter);
        }
        return retVal;
    }

    public MemberEntry[] getFields() {
        Field[] fields = this.classObject.getFields();
        MemberEntry[] retVal = new MemberEntry[fields.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = new MemberEntry(fields[i], this.filter);
        }
        return retVal;
    }

    public SignatureClass[] getClasses() {
        Class<?>[] nested = this.classObject.getClasses();
        SignatureClass[] retVal = new SignatureClass[nested.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = new SignatureClass(nested[i], this.filter, this.loader, this.details);
        }
        return retVal;
    }

    public MemberEntry[] getConstructors() {
        Constructor<?>[] ctors = this.classObject.getConstructors();
        MemberEntry[] retVal = new MemberEntry[ctors.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = new MemberEntry(ctors[i], this.filter);
        }
        return retVal;
    }

    public SignatureClass getSuperclass() {
        Class spr = this.classObject.getSuperclass();
        if (spr == null) {
            return null;
        }
        return new SignatureClass(spr, this.filter, this.loader, this.details);
    }

    public SignatureClass getDeclaringClass() {
        Class<?> declClass = this.classObject.getDeclaringClass();
        if (declClass == null) {
            return null;
        }
        return new SignatureClass(this.classObject.getDeclaringClass(), this.filter, this.loader, this.details);
    }

    public String getName() {
        return this.classObject.getName();
    }

    public int getModifiers() {
        String value = this.details.getProperty("NestedProtected");
        int m = 1585;
        m = value == null ? m + 4 : m;
        value = this.details.getProperty("NestedStatic");
        m = value == null ? m + 8 : m;
        return this.classObject.getModifiers() & m;
    }

    public boolean equals(Object o) {
        if (o instanceof SignatureClass) {
            return this.classObject.equals(((SignatureClass)o).classObject);
        }
        return super.equals(o);
    }

    public SignatureClass loadClass(String name) throws ClassNotFoundException {
        return this.loader.loadClass(name);
    }
}

