/*
 * Decompiled with CFR 0.152.
 */
package ricoh.ant.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import ricoh.ant.http.Prop;

public class PostTask
extends Task {
    private static HttpClient httpClient = null;
    private PostMethod postMethod = null;
    private Hashtable props = new Hashtable();
    private Hashtable uploadFiles = new Hashtable();
    private URL to = null;
    private String user = null;
    private String password = null;
    private File propsFile = null;
    private String textProps = null;
    private String encoding = "UTF-8";
    private File log = null;
    private boolean append = true;
    private boolean verbose = true;
    private boolean wantResponse = true;
    private String property = null;
    private long maxwait = 180000L;
    private boolean failOnError = false;
    private Thread currentRunner = null;

    public void setTo(URL name) {
        this.to = name;
    }

    public void setUser(String name) {
        this.user = name;
    }

    public void setPassword(String pw) {
        this.password = pw;
    }

    public void setFile(File f) {
        this.propsFile = f;
    }

    public void setLogfile(File f) {
        this.log = f;
    }

    public void setAppend(boolean b) {
        this.append = b;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public void setWantresponse(boolean b) {
        this.wantResponse = b;
    }

    public void setProperty(String name) {
        this.property = name;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setMaxwait(int wait) {
        this.maxwait = wait * 1000;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void addConfiguredProp(Prop p) throws BuildException {
        String name = p.getName();
        if (name == null) {
            throw new BuildException("name is null", this.getLocation());
        }
        if (p.getFile() != null) {
            this.uploadFiles.put(name, p);
        } else {
            String value = p.getValue();
            if (value == null) {
                value = this.getProject().getProperty(name);
            }
            if (value == null) {
                throw new BuildException("value is null", this.getLocation());
            }
            this.props.put(name, value);
        }
    }

    public void addText(String text) {
        this.textProps = text;
    }

    public void execute() throws BuildException {
        block11: {
            if (this.to == null) {
                throw new BuildException("'to' attribute is required", this.getLocation());
            }
            String content = this.getContent();
            try {
                if (this.verbose) {
                    this.log("Opening connection for post to " + this.to.toString() + "...");
                }
                Thread runner = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        FilterOutputStream out = null;
                        try {
                            if (PostTask.this.verbose) {
                                PostTask.this.log("Connected, sending data...");
                            }
                            if (httpClient == null) {
                                httpClient = new HttpClient();
                                HostConfiguration hostConfiguration = new HostConfiguration();
                                hostConfiguration.setHost(PostTask.this.to.toString());
                                httpClient.setHostConfiguration(hostConfiguration);
                            }
                            if (PostTask.this.to.getUserInfo() != null) {
                                PostTask.this.user = PostTask.this.to.getUserInfo().substring(0, PostTask.this.to.getUserInfo().indexOf(58));
                                PostTask.this.password = PostTask.this.to.getUserInfo().substring(PostTask.this.to.getUserInfo().indexOf(58) + 1);
                                if (PostTask.this.verbose) {
                                    PostTask.this.log("The user info section of the 'to' URL is " + PostTask.this.to.getUserInfo());
                                }
                            }
                            if (PostTask.this.user != null && PostTask.this.password != null) {
                                if (PostTask.this.verbose) {
                                    PostTask.this.log("Set credentials to " + PostTask.this.user + " : " + PostTask.this.password);
                                }
                                httpClient.getParams().setAuthenticationPreemptive(true);
                                UsernamePasswordCredentials theCredentials = new UsernamePasswordCredentials(PostTask.this.user, PostTask.this.password);
                                httpClient.getState().setCredentials(new AuthScope(PostTask.this.to.getHost(), PostTask.this.to.getPort(), AuthScope.ANY_REALM), (Credentials)theCredentials);
                            }
                            PostTask.this.postMethod = new PostMethod(PostTask.this.to.toString());
                            if (PostTask.this.uploadFiles.size() == 0) {
                                Enumeration en = PostTask.this.props.keys();
                                while (en.hasMoreElements()) {
                                    String itemName = (String)en.nextElement();
                                    String itemValue = (String)PostTask.this.props.get(itemName);
                                    PostTask.this.postMethod.addParameter(itemName, itemValue);
                                    if (!PostTask.this.verbose) continue;
                                    PostTask.this.log(itemName + "=" + itemValue);
                                }
                            } else {
                                ArrayList<Object> partList = new ArrayList<Object>();
                                Enumeration en = PostTask.this.props.keys();
                                while (en.hasMoreElements()) {
                                    String itemName = (String)en.nextElement();
                                    String itemValue = (String)PostTask.this.props.get(itemName);
                                    partList.add(new StringPart(itemName, itemValue));
                                    if (!PostTask.this.verbose) continue;
                                    PostTask.this.log(itemName + "=" + itemValue);
                                }
                                Enumeration uploadEn = PostTask.this.uploadFiles.keys();
                                while (uploadEn.hasMoreElements()) {
                                    String itemName = (String)uploadEn.nextElement();
                                    Prop itemValue = (Prop)PostTask.this.uploadFiles.get(itemName);
                                    FilePart currentPart = new FilePart(itemName, itemValue.getFilename(), itemValue.getFile(), itemValue.getContentType(), "ISO-8859-1");
                                    partList.add(currentPart);
                                    if (!PostTask.this.verbose) continue;
                                    PostTask.this.log(itemName + "=File upload " + itemValue.getFilename() + "; content-type=" + itemValue.getContentType());
                                }
                                Part[] partArray = partList.toArray(new Part[0]);
                                MultipartRequestEntity requestEntity = new MultipartRequestEntity(partArray, PostTask.this.postMethod.getParams());
                                PostTask.this.postMethod.setRequestEntity((RequestEntity)requestEntity);
                            }
                            int status = httpClient.executeMethod((HttpMethod)PostTask.this.postMethod);
                            if (PostTask.this.verbose) {
                                PostTask.this.log("Data sent.  Response headers are: " + Arrays.asList(PostTask.this.postMethod.getResponseHeaders()));
                            }
                        }
                        catch (Exception e) {
                            if (PostTask.this.verbose) {
                                PostTask.this.log("Connection failed: " + e.toString());
                            }
                            if (PostTask.this.failOnError) {
                                throw new BuildException((Throwable)e, PostTask.this.getLocation());
                            }
                        }
                        finally {
                            try {
                                out.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                };
                runner.start();
                runner.join(this.maxwait);
                if (runner.isAlive()) {
                    runner.interrupt();
                    if (this.failOnError) {
                        throw new BuildException("maxwait exceeded, unable to send data", this.getLocation());
                    }
                    return;
                }
                if (this.wantResponse) {
                    if (this.verbose) {
                        this.log("Waiting for response...");
                    }
                    this.currentRunner = runner = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            PrintWriter fw = null;
                            StringWriter sw = null;
                            PrintWriter pw = null;
                            BufferedReader in = null;
                            try {
                                String line;
                                in = new BufferedReader(new InputStreamReader(PostTask.this.postMethod.getResponseBodyAsStream()));
                                if (PostTask.this.log != null) {
                                    fw = new PrintWriter(new FileWriter(PostTask.this.log, PostTask.this.append));
                                }
                                if (PostTask.this.property != null) {
                                    sw = new StringWriter();
                                    pw = new PrintWriter(sw);
                                }
                                while (null != (line = in.readLine())) {
                                    if (PostTask.this.currentRunner != this) {
                                        break;
                                    }
                                    if (PostTask.this.verbose) {
                                        PostTask.this.log(line);
                                    }
                                    if (fw != null) {
                                        fw.println(line);
                                    }
                                    if (pw == null) continue;
                                    pw.println(line);
                                }
                            }
                            catch (Exception e) {
                                if (PostTask.this.failOnError) {
                                    throw new BuildException((Throwable)e, PostTask.this.getLocation());
                                }
                            }
                            finally {
                                try {
                                    in.close();
                                }
                                catch (Exception e) {}
                                try {
                                    if (fw != null) {
                                        fw.flush();
                                        fw.close();
                                    }
                                }
                                catch (Exception e) {}
                            }
                            if (PostTask.this.property != null && sw != null) {
                                PostTask.this.getProject().setProperty(PostTask.this.property, sw.toString());
                            }
                        }
                    };
                    runner.start();
                    runner.join(this.maxwait);
                    if (runner.isAlive()) {
                        this.currentRunner = null;
                        runner.interrupt();
                        if (this.failOnError) {
                            throw new BuildException("maxwait exceeded, unable to receive data", this.getLocation());
                        }
                    }
                }
                if (this.verbose) {
                    this.log("Post complete.");
                }
            }
            catch (Exception e) {
                if (!this.failOnError) break block11;
                throw new BuildException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(File file) throws BuildException {
        block9: {
            Properties fileprops = new Properties();
            try {
                if (file.exists()) {
                    FileInputStream fis = new FileInputStream(file);
                    try {
                        fileprops.load(fis);
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    this.addProperties(fileprops);
                } else {
                    this.log("Unable to find property file: " + file.getAbsolutePath(), 3);
                }
                this.log("Post complete.");
            }
            catch (Exception e) {
                if (!this.failOnError) break block9;
                throw new BuildException((Throwable)e);
            }
        }
    }

    private String getContent() {
        StringBuffer content;
        block5: {
            if (this.propsFile != null) {
                this.loadFile(this.propsFile);
            }
            if (this.textProps != null) {
                this.loadTextProps(this.textProps);
            }
            content = new StringBuffer();
            try {
                Enumeration en = this.props.keys();
                while (en.hasMoreElements()) {
                    String name = (String)en.nextElement();
                    String value = (String)this.props.get(name);
                    content.append(URLEncoder.encode(name, this.encoding));
                    content.append("=");
                    content.append(URLEncoder.encode(value, this.encoding));
                    if (!en.hasMoreElements()) continue;
                    content.append("&");
                }
            }
            catch (IOException ex) {
                if (!this.failOnError) break block5;
                throw new BuildException((Throwable)ex, this.getLocation());
            }
        }
        return content.toString();
    }

    private void loadTextProps(String tp) {
        Properties p = new Properties();
        Project project = this.getProject();
        StringTokenizer st = new StringTokenizer(tp, "$");
        while (st.hasMoreTokens()) {
            String name;
            String value;
            String token = st.nextToken();
            int start = token.indexOf("{");
            int end = token.indexOf("}");
            if (start <= -1 || end <= -1 || end <= start || (value = project.getProperty(name = token.substring(start + 1, end - start))) == null) continue;
            p.setProperty(name, value);
        }
        this.addProperties(p);
    }

    private void addProperties(Properties fileprops) {
        this.resolveAllProperties(fileprops);
        Enumeration<Object> e = fileprops.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = fileprops.getProperty(name);
            this.props.put(name, value);
        }
    }

    private void resolveAllProperties(Properties fileprops) throws BuildException {
        Enumeration<Object> e = fileprops.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = fileprops.getProperty(name);
            boolean resolved = false;
            while (!resolved) {
                Vector fragments = new Vector();
                Vector propertyRefs = new Vector();
                ProjectHelper.parsePropertyString((String)value, fragments, propertyRefs);
                resolved = true;
                if (propertyRefs.size() == 0) continue;
                StringBuffer sb = new StringBuffer();
                Enumeration i = fragments.elements();
                Enumeration j = propertyRefs.elements();
                while (i.hasMoreElements()) {
                    String fragment = (String)i.nextElement();
                    if (fragment == null) {
                        String propertyName = (String)j.nextElement();
                        if (propertyName.equals(name)) {
                            throw new BuildException("Property " + name + " was circularly " + "defined.");
                        }
                        fragment = this.getProject().getProperty(propertyName);
                        if (fragment == null) {
                            if (fileprops.containsKey(propertyName)) {
                                fragment = fileprops.getProperty(propertyName);
                                resolved = false;
                            } else {
                                fragment = "${" + propertyName + "}";
                            }
                        }
                    }
                    sb.append(fragment);
                }
                value = sb.toString();
                fileprops.put(name, value);
            }
        }
    }
}

