/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.tests.jfluid.perf;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.netbeans.junit.NbPerformanceTest;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.Instrumentor;
import org.netbeans.lib.profiler.tests.jfluid.CommonProfilerTestCase;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupResponse;
import org.netbeans.lib.profiler.wireprotocol.RootClassLoadedCommand;

public class InstrumentationTest
extends CommonProfilerTestCase
implements NbPerformanceTest {
    ArrayList<NbPerformanceTest.PerformanceData> data = new ArrayList();
    ProfilerEngineSettings settings;
    String[] classNames;
    byte[][] classesBytes;

    public InstrumentationTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(InstrumentationTest.class);
        return suite;
    }

    public NbPerformanceTest.PerformanceData[] getPerformanceData() {
        return this.data.toArray(new NbPerformanceTest.PerformanceData[this.data.size()]);
    }

    public void reportPerformance(String name, long value, String unit) {
        NbPerformanceTest.PerformanceData d = new NbPerformanceTest.PerformanceData();
        d.name = name;
        d.value = value;
        d.unit = unit;
        d.threshold = 0L;
        this.data.add(d);
    }

    public void testJ2SE() {
        try {
            String jarPath = "/perfdata/j2se-simple.jar";
            File f = new File(this.getDataDir(), jarPath);
            InstrumentationTest.assertTrue((String)"Instrumented jar file doesn't exist.", (boolean)f.exists());
            this.initTest(f.getAbsolutePath());
            this.startInstrumentationTest(f.getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InstrumentationTest.fail();
        }
    }

    public void testJaxb() {
        try {
            String jarPath = "/perfdata/jaxb-xjc.jar";
            File f = new File(this.getDataDir(), jarPath);
            InstrumentationTest.assertTrue((String)"Instrumented jar file doesn't exist.", (boolean)f.exists());
            this.initTest(f.getAbsolutePath());
            this.startInstrumentationTest(f.getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InstrumentationTest.fail();
        }
    }

    public void testJaxbNoGettersEmpties() {
        try {
            String jarPath = "/perfdata/jaxb-xjc.jar";
            File f = new File(this.getDataDir(), jarPath);
            InstrumentationTest.assertTrue((String)"Instrumented jar file doesn't exist.", (boolean)f.exists());
            this.initTest(f.getAbsolutePath());
            this.settings.setInstrumentGetterSetterMethods(false);
            this.settings.setInstrumentEmptyMethods(false);
            this.startInstrumentationTest(f.getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InstrumentationTest.fail();
        }
    }

    public void testSimple() {
        try {
            String jarPath = "/perfdata/oneclass.jar";
            File f = new File(this.getDataDir(), jarPath);
            InstrumentationTest.assertTrue((String)"Instrumented jar file doesn't exist.", (boolean)f.exists());
            this.initTest(f.getAbsolutePath());
            this.startInstrumentationTest(f.getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InstrumentationTest.fail();
        }
    }

    public void testSimpleNoEmpties() {
        try {
            String jarPath = "/perfdata/oneclass.jar";
            File f = new File(this.getDataDir(), jarPath);
            InstrumentationTest.assertTrue((String)"Instrumented jar file doesn't exist.", (boolean)f.exists());
            this.initTest(f.getAbsolutePath());
            this.settings.setInstrumentEmptyMethods(false);
            this.startInstrumentationTest(f.getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InstrumentationTest.fail();
        }
    }

    public void testSimpleNoGetters() {
        try {
            String jarPath = "/perfdata/oneclass.jar";
            File f = new File(this.getDataDir(), jarPath);
            InstrumentationTest.assertTrue((String)"Instrumented jar file doesn't exist.", (boolean)f.exists());
            this.initTest(f.getAbsolutePath());
            this.settings.setInstrumentGetterSetterMethods(false);
            this.startInstrumentationTest(f.getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InstrumentationTest.fail();
        }
    }

    protected void setClasses(String jarPath) throws Exception {
        ArrayList<String> names = new ArrayList<String>(16);
        ArrayList<byte[]> bytes = new ArrayList<byte[]>(16);
        JarFile file = new JarFile(jarPath);
        Enumeration<JarEntry> entries = file.entries();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        int read = 0;
        byte[] buffer = new byte[1024];
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            String nm = entry.getName();
            nm = nm.substring(0, nm.lastIndexOf("."));
            names.add(nm);
            BufferedInputStream bis = new BufferedInputStream(file.getInputStream(entry));
            while ((read = bis.read(buffer)) > -1) {
                bos.write(buffer, 0, read);
            }
            bis.close();
            bytes.add(bos.toByteArray());
            bos.reset();
        }
        this.classNames = names.toArray(new String[names.size()]);
        this.classesBytes = (byte[][])bytes.toArray((T[])new byte[bytes.size()][]);
    }

    protected void setRootMethods(String jarFile) throws Exception {
        JarFile file = new JarFile(jarFile);
        HashSet<String> list = new HashSet<String>(8);
        Enumeration<JarEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            String name = entry.getName();
            int idx = name.lastIndexOf(47);
            String packageName = idx == -1 ? name : name.substring(0, idx);
            packageName = packageName.replace('/', '.');
            list.add(packageName);
        }
        ClientUtils.SourceCodeSelection[] ret = new ClientUtils.SourceCodeSelection[list.size()];
        String[] cls = list.toArray(new String[list.size()]);
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = new ClientUtils.SourceCodeSelection(cls[i] + ".", "", "");
        }
        this.settings.setInstrumentationRootMethods(ret);
    }

    protected boolean checkBytes(String className, byte[] bytes) {
        String clnm = className.replace(".", "/");
        int clindex = -1;
        for (int i = 0; i < this.classNames.length; ++i) {
            if (!this.classNames[i].equals(clnm)) continue;
            clindex = i;
            break;
        }
        if (clindex == -1) {
            throw new IllegalStateException("Class " + className + " has not original.");
        }
        byte[] origbytes = this.classesBytes[clindex];
        if (origbytes.length != bytes.length) {
            return false;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == origbytes[i]) continue;
            return false;
        }
        return true;
    }

    protected ProfilerEngineSettings initTest(String pathToJar) throws Exception {
        this.settings = new ProfilerEngineSettings();
        this.settings.setPortNo(5140);
        this.settings.setSeparateConsole(false);
        this.settings.setCPUProfilingType(0);
        this.settings.setInstrScheme(3);
        this.settings.setInstrumentEmptyMethods(true);
        this.settings.setInstrumentGetterSetterMethods(true);
        this.settings.setInstrumentMethodInvoke(true);
        this.settings.setInstrumentSpawnedThreads(true);
        this.settings.setJVMArgs("");
        this.setRootMethods(pathToJar);
        this.setTargetVM(this.settings);
        this.setProfilerHome(this.settings);
        this.setStatus(0);
        return this.settings;
    }

    protected void startInstrumentationTest(String jarFile) throws Exception {
        ProfilingSessionStatus status = new ProfilingSessionStatus();
        status.targetJDKVersionString = this.settings.getTargetJDKVersionString();
        PrintStream oldOutStream = System.out;
        PrintStream oldErrStream = System.err;
        System.setOut(this.getLogStream());
        System.setErr(this.getLogStream());
        Instrumentor instr = new Instrumentor(status, this.settings);
        instr.setStatusInfoFromSourceCodeSelection(this.settings.getInstrumentationRootMethods());
        status.currentInstrType = 2;
        this.setClasses(jarFile);
        int[] loadersIDs = new int[this.classNames.length];
        for (int i = 0; i < this.classNames.length; ++i) {
            loadersIDs[i] = 20;
        }
        int[] parentloadersIDs = new int[this.classNames.length];
        for (int i = 0; i < this.classNames.length; ++i) {
            parentloadersIDs[i] = 0;
        }
        RootClassLoadedCommand cmd = new RootClassLoadedCommand(this.classNames, loadersIDs, this.classesBytes, this.classNames.length, parentloadersIDs, null);
        this.log("Start instrumenting ...");
        InstrumentMethodGroupResponse resp = null;
        long time = System.currentTimeMillis();
        resp = instr.createInitialInstrumentMethodGroupResponse(cmd);
        time = System.currentTimeMillis() - time;
        this.ref("Number of Classes: " + this.classNames.length);
        byte[][] clbytes = resp.getReplacementClassFileBytes();
        this.ref("Instrumented Classes: " + resp.getBase().getNClasses());
        this.ref("Instrumented Methods: " + resp.getBase().getNMethods());
        if (resp.getErrorMessage() != null) {
            this.log("Error Message: " + resp.getErrorMessage());
        }
        String[] clnames = resp.getMethodClasses();
        byte[][] bts = resp.getReplacementClassFileBytes();
        boolean comp = false;
        for (int i = 0; i < clnames.length; ++i) {
            if (!this.checkBytes(clnames[i], bts[i])) continue;
            this.log("Equals bytes: " + clnames[i]);
        }
        System.setOut(oldOutStream);
        System.setErr(oldErrStream);
        this.reportPerformance(this.getName(), time, "ms");
    }
}

