/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoEllipse;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoNode;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoText;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class JGoBasicNode
extends JGoNode {
    private static Dimension DefaultPortSize = new Dimension(7, 7);
    private static Dimension DefaultDrawableMargin = new Dimension(7, 7);
    public static final int ChangedLabelSpot = 2101;
    public static final int ChangedDrawable = 2102;
    public static final int ChangedLabel = 2103;
    public static final int ChangedPort = 2104;
    public static final int ChangedInsets = 2105;
    public static final int ChangedAutoResize = 2106;
    private static final int flagAutoResize = 65536;
    private JGoDrawable myDrawable = null;
    private JGoText myLabel = null;
    private JGoPort myPort = null;
    private int myLabelSpot = 2;
    private Insets myInsets = new Insets(5, 10, 5, 10);

    public JGoBasicNode() {
        this.initCommon();
    }

    public JGoBasicNode(String s) {
        this.initCommon();
        this.init(s);
    }

    private void initCommon() {
        this.setInternalFlags(this.getInternalFlags() & 0xFFFFFFEF | 0x10000);
    }

    private void init(String s) {
        this.setInitializing(true);
        this.myPort = this.createPort();
        this.myDrawable = this.createDrawable(this.myPort);
        this.myLabel = this.createLabel(s);
        this.addObjectAtHead(this.myDrawable);
        this.addObjectAtTail(this.myPort);
        this.addObjectAtTail(this.myLabel);
        if (this.myPort != null) {
            this.myPort.setPortObject(this.myDrawable);
        }
        this.setInitializing(false);
        this.layoutChildren(null);
    }

    public JGoPort createPort() {
        JGoPort p = new JGoPort();
        if (this.getLabelSpot() == 0) {
            p.setStyle(0);
        } else {
            p.setStyle(2);
        }
        p.setFromSpot(-1);
        p.setToSpot(-1);
        p.setSize(DefaultPortSize);
        return p;
    }

    public JGoDrawable createDrawable(JGoPort p) {
        JGoEllipse e = new JGoEllipse();
        Dimension d = DefaultDrawableMargin;
        e.setSize(p.getWidth() + 2 * d.width, p.getHeight() + 2 * d.height);
        e.setSelectable(false);
        e.setResizable(false);
        e.setBrush(JGoBrush.white);
        return e;
    }

    public JGoText createLabel(String s) {
        if (s != null) {
            JGoText l = new JGoText(s);
            l.setSelectable(false);
            l.setDraggable(false);
            l.setEditable(false);
            l.setEditOnSingleClick(true);
            l.setTransparent(true);
            return l;
        }
        return null;
    }

    protected void copyChildren(JGoArea newarea, JGoCopyEnvironment env) {
        JGoBasicNode newobj = (JGoBasicNode)newarea;
        newobj.myLabelSpot = this.myLabelSpot;
        newobj.myInsets = new Insets(this.myInsets.top, this.myInsets.left, this.myInsets.bottom, this.myInsets.right);
        super.copyChildren(newarea, env);
        newobj.myDrawable = (JGoDrawable)env.get(this.myDrawable);
        newobj.myPort = (JGoPort)env.get(this.myPort);
        newobj.myLabel = (JGoText)env.get(this.myLabel);
    }

    public JGoObject removeObjectAtPos(JGoListPosition pos) {
        JGoObject child = super.removeObjectAtPos(pos);
        if (child == this.myDrawable) {
            this.myDrawable = null;
        } else if (child == this.myLabel) {
            this.myLabel = null;
        } else if (child == this.myPort) {
            this.myPort = null;
        }
        return child;
    }

    public Point getLocation(Point result) {
        if (this.getDrawable() != null) {
            return this.getDrawable().getSpotLocation(0, result);
        }
        return this.getSpotLocation(0, result);
    }

    public void setLocation(int x, int y) {
        if (this.getDrawable() != null) {
            Rectangle r = this.getDrawable().getBoundingRect();
            int cx = r.x + r.width / 2;
            int cy = r.y + r.height / 2;
            if (x != cx || y != cy) {
                int nx = this.getLeft();
                int ny = this.getTop();
                this.setTopLeft(x - (cx - nx), y - (cy - ny));
            }
        } else {
            Rectangle r = this.getBoundingRect();
            int cx = r.x + r.width / 2;
            int cy = r.y + r.height / 2;
            if (x != cx || y != cy) {
                this.setTopLeft(x - r.width / 2, y - r.height / 2);
            }
        }
    }

    public void layoutChildren(JGoObject childchanged) {
        if (this.isInitializing()) {
            return;
        }
        JGoDrawable shape = this.getDrawable();
        if (shape == null) {
            return;
        }
        JGoText label = this.getLabel();
        if (label != null) {
            int spot = this.getLabelSpot();
            if (spot == 0) {
                int cx = shape.getLeft() + shape.getWidth() / 2;
                int cy = shape.getTop() + shape.getHeight() / 2;
                Insets insets = this.getInsets();
                if (this.isAutoResize()) {
                    int w = label.getWidth() + insets.left + insets.right;
                    int h = label.getHeight() + insets.top + insets.bottom;
                    shape.setBoundingRect(cx - label.getWidth() / 2 - insets.left, cy - label.getHeight() / 2 - insets.top, w, h);
                } else {
                    int maxLabelWidth = Math.max(shape.getWidth() - (insets.left + insets.right), 0);
                    int maxLabelHeight = Math.max(shape.getHeight() - (insets.top + insets.bottom), 0);
                    label.setWidth(maxLabelWidth);
                    label.setWrappingWidth(maxLabelWidth);
                    label.recalcBoundingRect();
                    int labelHeight = Math.min(label.getHeight(), maxLabelHeight);
                    int labelLeft = shape.getLeft() + insets.left;
                    int labelTop = shape.getTop() + insets.top + (maxLabelHeight - labelHeight) / 2;
                    label.setBoundingRect(labelLeft, labelTop, maxLabelWidth, labelHeight);
                }
                label.setAlignment(0);
                label.setSpotLocation(0, cx, cy);
                if (this.getPort() != null) {
                    this.getPort().setBoundingRect(shape.getBoundingRect());
                }
            } else {
                label.setAlignment(JGoBasicNode.spotOpposite(spot));
                label.setSpotLocation(JGoBasicNode.spotOpposite(spot), shape, spot);
            }
        }
        if (this.getPort() != null) {
            this.getPort().setSpotLocation(0, shape, 0);
        }
    }

    public int getLabelSpot() {
        return this.myLabelSpot;
    }

    public void setLabelSpot(int s) {
        this.internalSetLabelSpot(s, false);
    }

    private void internalSetLabelSpot(int s, boolean undoing) {
        int old = this.myLabelSpot;
        if (old != s) {
            this.myLabelSpot = s;
            this.update(2101, old, null);
            if (!undoing) {
                this.labelSpotChanged(old);
            }
        }
    }

    public void labelSpotChanged(int old) {
        JGoPort p = this.getPort();
        if (p != null) {
            if (this.getLabelSpot() == 0) {
                p.setStyle(0);
                this.setResizable(false);
            } else if (old == 0) {
                p.setStyle(2);
                JGoDrawable shape = this.getDrawable();
                int cx = shape.getLeft() + shape.getWidth() / 2;
                int cy = shape.getTop() + shape.getHeight() / 2;
                Rectangle prect = new Rectangle(cx - JGoBasicNode.DefaultPortSize.width / 2, cy - JGoBasicNode.DefaultPortSize.height / 2, JGoBasicNode.DefaultPortSize.width, JGoBasicNode.DefaultPortSize.height);
                shape.setBoundingRect(cx - prect.width / 2 - JGoBasicNode.DefaultDrawableMargin.width, cy - prect.height / 2 - JGoBasicNode.DefaultDrawableMargin.height, prect.width + 2 * JGoBasicNode.DefaultDrawableMargin.width, prect.height + 2 * JGoBasicNode.DefaultDrawableMargin.height);
                p.setBoundingRect(prect);
            }
        }
        this.layoutChildren(this.getLabel());
    }

    public Insets getInsets() {
        return this.myInsets;
    }

    public void setInsets(Insets x) {
        this.internalSetInsets(x, false);
    }

    private void internalSetInsets(Insets x, boolean undoing) {
        Insets s = this.myInsets;
        if (!s.equals(x)) {
            Insets oldInsets = new Insets(s.top, s.left, s.bottom, s.right);
            this.myInsets.top = x.top;
            this.myInsets.left = x.left;
            this.myInsets.bottom = x.bottom;
            this.myInsets.right = x.right;
            this.update(2105, 0, oldInsets);
            if (!undoing) {
                this.layoutChildren(null);
            }
        }
    }

    public void setAutoResize(boolean bFlag) {
        this.internalSetAutoResize(bFlag, false);
    }

    private void internalSetAutoResize(boolean bFlag, boolean undoing) {
        boolean old;
        boolean bl = old = (this.getInternalFlags() & 0x10000) != 0;
        if (old != bFlag) {
            if (bFlag) {
                this.setInternalFlags(this.getInternalFlags() | 0x10000);
            } else {
                this.setInternalFlags(this.getInternalFlags() & 0xFFFEFFFF);
            }
            this.update(2106, old ? 1 : 0, null);
            if (!undoing) {
                this.onAutoResizeChanged(old);
            }
        }
    }

    public boolean isAutoResize() {
        return (this.getInternalFlags() & 0x10000) != 0;
    }

    public void onAutoResizeChanged(boolean old) {
        JGoText l = this.getLabel();
        if (l != null) {
            l.setMultiline(old);
            l.setWrapping(old);
            l.setClipping(old);
        }
    }

    public JGoPen getPen() {
        return this.getDrawable().getPen();
    }

    public void setPen(JGoPen p) {
        this.getDrawable().setPen(p);
    }

    public JGoBrush getBrush() {
        return this.getDrawable().getBrush();
    }

    public void setBrush(JGoBrush b) {
        this.getDrawable().setBrush(b);
    }

    public String getText() {
        if (this.getLabel() != null) {
            return this.getLabel().getText();
        }
        return "";
    }

    public void setText(String s) {
        if (s == null) {
            this.removeObject(this.myLabel);
        } else if (this.getLabel() == null) {
            this.setLabel(this.createLabel(s));
        } else {
            this.getLabel().setText(s);
        }
    }

    public JGoDrawable getDrawable() {
        return this.myDrawable;
    }

    public void setDrawable(JGoDrawable shape) {
        JGoDrawable old = this.myDrawable;
        if (old != shape) {
            JGoBasicNode.copyProperties(old, shape);
            if (old != null) {
                this.removeObject(old);
            }
            this.myDrawable = shape;
            if (shape != null) {
                if (old == null) {
                    shape.setSelectable(false);
                    shape.setResizable(false);
                }
                this.addObjectAtHead(shape);
            }
            this.update(2102, 0, old);
            if (this.getPort() != null && this.getPort().getPortObject() == old) {
                this.getPort().setPortObject(shape);
            }
        }
    }

    public JGoText getLabel() {
        return this.myLabel;
    }

    public void setLabel(JGoText lab) {
        JGoText old = this.myLabel;
        if (old != lab) {
            if (old != null) {
                this.removeObject(old);
            }
            this.myLabel = lab;
            if (lab != null) {
                this.addObjectAtTail(lab);
            }
            this.update(2103, 0, old);
        }
    }

    public JGoPort getPort() {
        return this.myPort;
    }

    public void setPort(JGoPort p) {
        JGoPort old = this.myPort;
        if (old != p) {
            if (old != null) {
                this.removeObject(old);
            }
            this.myPort = p;
            if (p != null) {
                this.addObjectAtTail(p);
            }
            this.update(2104, 0, old);
            if (p != null && p.getPortObject() == null) {
                p.setPortObject(this.getDrawable());
            }
        }
    }

    public void SVGUpdateReference(String attr, Object referencedObject) {
        super.SVGUpdateReference(attr, referencedObject);
        if (attr.equals("drawable")) {
            this.myDrawable = (JGoDrawable)referencedObject;
        } else if (attr.equals("label")) {
            this.myLabel = (JGoText)referencedObject;
        } else if (attr.equals("port")) {
            this.myPort = (JGoPort)referencedObject;
        }
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jJGoBasicNode = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoBasicNode", jGoElementGroup);
            jJGoBasicNode.setAttribute("labelspot", Integer.toString(this.myLabelSpot));
            jJGoBasicNode.setAttribute("insets_top", Integer.toString(this.myInsets.top));
            jJGoBasicNode.setAttribute("insets_right", Integer.toString(this.myInsets.right));
            jJGoBasicNode.setAttribute("insets_bottom", Integer.toString(this.myInsets.bottom));
            jJGoBasicNode.setAttribute("insets_left", Integer.toString(this.myInsets.left));
            if (this.myDrawable != null) {
                svgDoc.registerReferencingNode(jJGoBasicNode, "drawable", this.myDrawable);
            }
            if (this.myLabel != null) {
                svgDoc.registerReferencingNode(jJGoBasicNode, "label", this.myLabel);
            }
            if (this.myPort != null) {
                svgDoc.registerReferencingNode(jJGoBasicNode, "port", this.myPort);
            }
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            String insets_left;
            String insets_bottom;
            String insets_right;
            this.myLabelSpot = Integer.parseInt(jGoChildElement.getAttribute("labelspot"));
            String insets_top = jGoChildElement.getAttribute("insets_top");
            if (insets_top.length() > 0) {
                this.myInsets.top = Integer.parseInt(insets_top);
            }
            if ((insets_right = jGoChildElement.getAttribute("insets_right")).length() > 0) {
                this.myInsets.right = Integer.parseInt(insets_right);
            }
            if ((insets_bottom = jGoChildElement.getAttribute("insets_bottom")).length() > 0) {
                this.myInsets.bottom = Integer.parseInt(insets_bottom);
            }
            if ((insets_left = jGoChildElement.getAttribute("insets_left")).length() > 0) {
                this.myInsets.left = Integer.parseInt(insets_left);
            }
            String drawable = jGoChildElement.getAttribute("drawable");
            svgDoc.registerReferencingObject(this, "drawable", drawable);
            String label = jGoChildElement.getAttribute("label");
            svgDoc.registerReferencingObject(this, "label", label);
            String port = jGoChildElement.getAttribute("port");
            svgDoc.registerReferencingObject(this, "port", port);
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
        }
        return svgElement.getNextSibling();
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 2101: {
                e.setNewValueInt(this.getLabelSpot());
                return;
            }
            case 2102: {
                e.setNewValue(this.getDrawable());
                return;
            }
            case 2103: {
                e.setNewValue(this.getLabel());
                return;
            }
            case 2104: {
                e.setNewValue(this.getPort());
                return;
            }
            case 2105: {
                Insets insets = this.getInsets();
                e.setNewValue(new Insets(insets.top, insets.left, insets.bottom, insets.right));
                return;
            }
            case 2106: {
                e.setNewValueBoolean(this.isAutoResize());
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 2101: {
                this.internalSetLabelSpot(e.getValueInt(undo), true);
                return;
            }
            case 2102: {
                this.setDrawable((JGoDrawable)e.getValue(undo));
                return;
            }
            case 2103: {
                this.setLabel((JGoText)e.getValue(undo));
                return;
            }
            case 2104: {
                this.setPort((JGoPort)e.getValue(undo));
                return;
            }
            case 2105: {
                this.internalSetInsets((Insets)e.getValue(undo), true);
                return;
            }
            case 2106: {
                this.internalSetAutoResize(e.getValueBoolean(undo), true);
                return;
            }
        }
        super.changeValue(e, undo);
    }
}

