/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoStroke;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class JGoEllipse
extends JGoDrawable {
    public JGoEllipse() {
    }

    public JGoEllipse(Rectangle rect) {
        super(rect);
    }

    public JGoEllipse(Point location, Dimension size) {
        super(location, size);
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        JGoEllipse newobj = (JGoEllipse)super.copyObject(env);
        if (newobj != null) {
            // empty if block
        }
        return newobj;
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoEllipse = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoEllipse", jGoElementGroup);
        }
        if (svgDoc.SVGOutputEnabled()) {
            DomElement element = svgDoc.createElement("ellipse");
            this.SVGWriteAttributes(element);
            jGoElementGroup.appendChild(element);
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
        } else if (svgElement.getTagName().equalsIgnoreCase("ellipse")) {
            this.SVGReadAttributes(svgElement);
        } else if (svgElement.getTagName().equalsIgnoreCase("circle")) {
            this.SVGReadAttributes(svgElement);
        }
        return svgElement.getNextSibling();
    }

    public void SVGWriteAttributes(DomElement svgElement) {
        super.SVGWriteAttributes(svgElement);
        int cx = this.getTopLeft().x + this.getWidth() / 2;
        int cy = this.getTopLeft().y + this.getHeight() / 2;
        int rx = this.getWidth() / 2;
        int ry = this.getHeight() / 2;
        svgElement.setAttribute("rx", Integer.toString(rx));
        svgElement.setAttribute("ry", Integer.toString(ry));
        svgElement.setAttribute("cx", Integer.toString(cx));
        svgElement.setAttribute("cy", Integer.toString(cy));
    }

    public void SVGReadAttributes(DomElement svgElement) {
        super.SVGReadAttributes(svgElement);
        String sCX = svgElement.getAttribute("cx");
        String sCY = svgElement.getAttribute("cy");
        String sRX = svgElement.getAttribute("rx");
        String sRY = svgElement.getAttribute("ry");
        String sR = svgElement.getAttribute("r");
        if (sR.length() > 0) {
            sRX = sR;
            sRY = sR;
        }
        int x = new Double(sCX).intValue() - new Double(sRX).intValue();
        int y = new Double(sCY).intValue() - new Double(sRY).intValue();
        int width = new Double(sRX).intValue() * 2;
        int height = new Double(sRY).intValue() * 2;
        this.setTopLeft(new Point(x, y));
        this.setWidth(width);
        this.setHeight(height);
    }

    public void paint(Graphics2D g, JGoView view) {
        this.drawEllipse(g, this.getBoundingRect());
    }

    public boolean isPointInObj(Point pnt) {
        if (!super.isPointInObj(pnt)) {
            return false;
        }
        double a = (double)this.getWidth() / 2.0;
        double x = (double)pnt.x - ((double)this.getLeft() + a);
        double b = (double)this.getHeight() / 2.0;
        double y = (double)pnt.y - ((double)this.getTop() + b);
        return x * x / (a * a) + y * y / (b * b) <= 1.0;
    }

    public static boolean getNearestIntersectionPoint(int left, int top, int width, int height, int px, int py, Point R) {
        double a = (double)width / 2.0;
        double b = (double)height / 2.0;
        double cx = (double)left + a;
        double cy = (double)top + b;
        double x = (double)px - cx;
        double y = (double)py - cy;
        double a2 = a * a;
        double b2 = b * b;
        if (-0.01 < x && x < 0.01) {
            x = 0.01;
        }
        if (-0.01 < y && y < 0.01) {
            y = 0.01;
        }
        double t2 = y * y / (x * x);
        double rx = Math.sqrt(a2 * b2 / (b2 + a2 * t2));
        double ry = Math.abs(rx * y / x);
        R.x = (int)Math.rint(x > 0.0 ? cx + rx : cx - rx);
        R.y = (int)Math.rint(y > 0.0 ? cy + ry : cy - ry);
        return true;
    }

    public static boolean getNearestIntersectionPoint(int left, int top, int width, int height, int px, int py, int cx, int cy, Point result) {
        if (width == 0) {
            return JGoStroke.getNearestIntersectionOnLine(left, top, left, top + height, px, py, cx, cy, result);
        }
        if (height == 0) {
            return JGoStroke.getNearestIntersectionOnLine(left, top, left + width, top, px, py, cx, cy, result);
        }
        double p1X = px;
        double p1Y = py;
        double p2X = cx;
        double p2Y = cy;
        double Rx = width / 2;
        double Ry = height / 2;
        double Cx = (double)left + Rx;
        double Cy = (double)top + Ry;
        if (p1X != p2X) {
            double distminus;
            double b;
            double m = p1X > p2X ? (p1Y - p2Y) / (p1X - p2X) : (p2Y - p1Y) / (p2X - p1X);
            if (Rx * Rx * (m * m) + Ry * Ry - (b = p1Y - Cy - m * (p1X - Cx)) * b < 0.0) {
                result.x = 0;
                result.y = 0;
                return false;
            }
            double sqrt = Math.sqrt(Rx * Rx * (m * m) + Ry * Ry - b * b);
            double xplus = (-(Rx * Rx * m * b) + Rx * Ry * sqrt) / (Ry * Ry + Rx * Rx * (m * m)) + Cx;
            double xminus = (-(Rx * Rx * m * b) - Rx * Ry * sqrt) / (Ry * Ry + Rx * Rx * (m * m)) + Cx;
            double yplus = m * (xplus - Cx) + b + Cy;
            double yminus = m * (xminus - Cx) + b + Cy;
            double distplus = Math.abs((p1X - xplus) * (p1X - xplus)) + Math.abs((p1Y - yplus) * (p1Y - yplus));
            if (distplus < (distminus = Math.abs((p1X - xminus) * (p1X - xminus)) + Math.abs((p1Y - yminus) * (p1Y - yminus)))) {
                result.x = Math.round((float)xplus);
                result.y = Math.round((float)yplus);
            } else {
                result.x = Math.round((float)xminus);
                result.y = Math.round((float)yminus);
            }
        } else {
            double distminus;
            double sqrt = Math.sqrt(Ry * Ry - Ry * Ry / (Rx * Rx) * ((p1X - Cx) * (p1X - Cx)));
            double yplus = Cy + sqrt;
            double yminus = Cy - sqrt;
            double distplus = Math.abs(yplus - p1Y);
            if (distplus < (distminus = Math.abs(yminus - p1Y))) {
                result.x = px;
                result.y = Math.round((float)yplus);
            } else {
                result.x = px;
                result.y = Math.round((float)yminus);
            }
        }
        return true;
    }

    public boolean getNearestIntersectionPoint(int px, int py, int cx, int cy, Point result) {
        Rectangle r = this.getBoundingRect();
        int penw = 1;
        if (this.getPen() != null) {
            penw = this.getPen().getWidth();
        }
        return JGoEllipse.getNearestIntersectionPoint(r.x - penw, r.y - penw, r.width + 2 * penw, r.height + 2 * penw, px, py, cx, cy, result);
    }
}

