/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoSubGraph;
import com.nwoods.jgo.JGoView;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class JGoSubGraphHandle
extends JGoRectangle {
    public JGoSubGraphHandle() {
        this.setSize(10, 10);
        this.setDragsNode(true);
        this.setSelectable(false);
        this.setResizable(false);
        this.setBrush(JGoBrush.yellow);
    }

    public void paint(Graphics2D g, JGoView view) {
        super.paint(g, view);
        this.paintHandle(g, view);
    }

    public void paintHandle(Graphics2D g, JGoView view) {
        JGoSubGraph parent = (JGoSubGraph)this.getParent();
        if (parent == null) {
            return;
        }
        Rectangle rect = this.getBoundingRect();
        if (parent.isCollapsible()) {
            int midY = rect.y + rect.height / 2;
            JGoSubGraphHandle.drawLine(g, JGoPen.black, rect.x + rect.width / 4, midY, rect.x + rect.width * 3 / 4, midY);
            if (!parent.isExpanded()) {
                int midX = rect.x + rect.width / 2;
                JGoSubGraphHandle.drawLine(g, JGoPen.black, midX, rect.y + rect.height / 4, midX, rect.y + rect.height * 3 / 4);
            }
        } else {
            JGoSubGraphHandle.drawEllipse(g, JGoPen.black, null, rect.x + rect.width / 4, rect.y + rect.height / 4, rect.width / 2, rect.height / 2);
        }
    }

    public boolean doMouseClick(int modifiers, Point dc, Point vc, JGoView view) {
        JGoSubGraph sg = (JGoSubGraph)this.getParent();
        if (sg == null || !sg.isCollapsible()) {
            return false;
        }
        if (view != null) {
            view.getDocument().startTransaction();
        }
        String transresult = null;
        if (sg.isExpanded()) {
            sg.collapse();
            transresult = "Collapsed JGoSubGraph";
        } else if ((modifiers & 2) != 0) {
            sg.expandAll();
            transresult = "Expanded All JGoSubGraphs";
        } else {
            sg.expand();
            transresult = "Expand JGoSubGraph";
        }
        if (view != null) {
            view.getDocument().endTransaction(transresult);
            view.getSelection().restoreSelectionHandles(sg);
        }
        return true;
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement domElement = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoSubGraphHandle", jGoElementGroup);
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingElement());
        }
        return svgElement.getNextSibling();
    }
}

