/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.Sequence;
import org.axiondb.VariableContext;

public class SequenceEvaluator
implements Selectable {
    public static final String CURRVAL = "CURRVAL";
    public static final String NEXTVAL = "NEXTVAL";
    private String _method;
    private String _alias;
    private VariableContext _ctx;
    private boolean _nextval;
    private Sequence _seq;

    public SequenceEvaluator(Sequence seq, String method) throws AxionException {
        this._seq = seq;
        this._method = method;
        if (NEXTVAL.equalsIgnoreCase(method)) {
            this._nextval = true;
        } else if (CURRVAL.equalsIgnoreCase(method)) {
            this._nextval = false;
        } else {
            throw new AxionException("Pseudocolumn " + method + " not recognized.");
        }
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        if (this._nextval) {
            Object val = this._seq.evaluate();
            this._ctx.put(this._seq, val);
            return val;
        }
        if (this._ctx.containsKey(this._seq)) {
            return this._ctx.get(this._seq);
        }
        throw new AxionException("Sequence " + this.getName() + " not yet evaluated in this context.");
    }

    public String getAlias() {
        if (this._alias != null) {
            return this._alias;
        }
        return this._seq.getName();
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public DataType getDataType() {
        return this._seq.getDataType();
    }

    public String getLabel() {
        if (this._alias != null) {
            return this._alias;
        }
        return this._seq.getName() + "_" + this._method;
    }

    public String getName() {
        return this._seq.getName();
    }

    public void setVariableContext(VariableContext ctx) {
        this._ctx = ctx;
    }
}

