/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.primitives.IntCollection;
import org.apache.commons.collections.primitives.IntListIterator;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Constraint;
import org.axiondb.Function;
import org.axiondb.Index;
import org.axiondb.Literal;
import org.axiondb.Row;
import org.axiondb.RowCollection;
import org.axiondb.RowComparator;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.RowSource;
import org.axiondb.Selectable;
import org.axiondb.Sequence;
import org.axiondb.Table;
import org.axiondb.TransactableTable;
import org.axiondb.engine.ArrayIndexFactory;
import org.axiondb.engine.BTreeIndexFactory;
import org.axiondb.engine.rowcollection.IntRowMap;
import org.axiondb.engine.rowcollection.IntSet;
import org.axiondb.engine.rowiterators.AbstractAcceptingRowIterator;
import org.axiondb.engine.rowiterators.ChainedRowIterator;
import org.axiondb.engine.rowiterators.CollatingRowIterator;
import org.axiondb.engine.rowiterators.DelegatingRowIterator;
import org.axiondb.engine.rowiterators.LazyRowRowIterator;
import org.axiondb.engine.rowiterators.TransformingRowIterator;
import org.axiondb.engine.rowiterators.UnmodifiableRowIterator;
import org.axiondb.engine.tables.AbstractBaseTable;
import org.axiondb.event.RowDeletedEvent;
import org.axiondb.event.RowInsertedEvent;
import org.axiondb.event.RowUpdatedEvent;
import org.axiondb.functions.ComparisonFunction;

public final class TransactableTableImpl
extends AbstractBaseTable
implements TransactableTable {
    private Table _table;
    private RowDecorator _dec;
    List _constraints;
    List _indices;
    private IntRowMap _insertedRows = new IntRowMap();
    private IntRowMap _updatedRows = new IntRowMap();
    private IntSet _deletedRows = new IntSet();
    private static ArrayIndexFactory ARRAY_INDEX_FACTORY = new ArrayIndexFactory();
    private static BTreeIndexFactory BTREE_INDEX_FACTORY = new BTreeIndexFactory();
    private int _state = 0;
    private boolean _deferAll = false;

    public TransactableTableImpl(Table table) {
        this._table = table;
    }

    public final String getName() {
        return this._table.getName();
    }

    public final Table getTable() {
        return this._table;
    }

    public final String getType() {
        return this._table.getType();
    }

    public final RowDecorator makeRowDecorator() {
        if (this._dec == null) {
            this._dec = this._table.makeRowDecorator();
        }
        return this._dec;
    }

    public void addConstraint(Constraint constraint) throws AxionException {
        this._table.addConstraint(constraint);
    }

    public Constraint removeConstraint(String name) {
        return this._table.removeConstraint(name);
    }

    public final Constraint getConstraint(String name) {
        return this._table.getConstraint(name);
    }

    public final Iterator getConstraints() {
        return this._table.getConstraints();
    }

    public boolean isUniqueConstraintExists(String columnName) {
        return this._table.isUniqueConstraintExists(columnName);
    }

    public boolean isPrimaryKeyConstraintExists(String columnName) {
        return this._table.isPrimaryKeyConstraintExists(columnName);
    }

    public void addIndex(Index index) throws AxionException {
        this._table.addIndex(index);
    }

    public void removeIndex(Index index) throws AxionException {
        this._table.removeIndex(index);
        this._insertedRows.clearIndexes();
        this._updatedRows.clearIndexes();
    }

    public final boolean hasIndex(String name) throws AxionException {
        return this._table.hasIndex(name);
    }

    public final void populateIndex(Index index) throws AxionException {
        this._table.populateIndex(index);
    }

    public final Index getIndexForColumn(Column column) {
        return this._table.getIndexForColumn(column);
    }

    public final boolean isColumnIndexed(Column column) {
        return this._table.isColumnIndexed(column);
    }

    public void addColumn(Column col) throws AxionException {
        this._table.addColumn(col);
    }

    public final Column getColumn(int index) {
        return this._table.getColumn(index);
    }

    public final Column getColumn(String name) {
        return this._table.getColumn(name);
    }

    public final boolean hasColumn(ColumnIdentifier id) {
        return this._table.hasColumn(id);
    }

    public final int getColumnIndex(String name) throws AxionException {
        return this._table.getColumnIndex(name);
    }

    public final List getColumnIdentifiers() {
        return this._table.getColumnIdentifiers();
    }

    public final int getColumnCount() {
        return this._table.getColumnCount();
    }

    public final Iterator getIndices() {
        return this._table.getIndices();
    }

    public void addRow(Row row) throws AxionException {
        int rowid = this._table.getNextRowId();
        row.setIdentifier(rowid);
        RowInsertedEvent event = new RowInsertedEvent(this, null, row);
        try {
            this.checkConstraints(event, this.makeRowDecorator());
        }
        catch (AxionException e) {
            this.freeRowId(rowid);
            throw e;
        }
        this._insertedRows.addRow(this, row);
        this.publishEvent(event);
    }

    public RowIterator getRowIterator(boolean readOnly) throws AxionException {
        if (!readOnly || this.hasUpdates() || this.hasDeletes() || this.hasInserts()) {
            ChainedRowIterator chain = new ChainedRowIterator();
            chain.addRowIterator(this.excludeDeletedTransformUpdated(this._table.getRowIterator(readOnly)));
            chain.addRowIterator(new InsertedRowIterator(this._insertedRows.rowIterator()));
            return chain;
        }
        return UnmodifiableRowIterator.wrap(this._table.getRowIterator(readOnly));
    }

    public RowIterator getIndexedRows(Selectable node, boolean readOnly) throws AxionException {
        return this.getIndexedRows(this.getTable(), node, readOnly);
    }

    public RowIterator getIndexedRows(RowSource source, Selectable node, boolean readOnly) throws AxionException {
        RowIterator rows = this._table.getIndexedRows(source, node, readOnly);
        if (null != rows) {
            if (!readOnly || this.hasUpdates() || this.hasDeletes() || this.hasInserts()) {
                Selectable col = this.getIndexColumn(node);
                RowComparator comparator = new RowComparator(col, this.makeRowDecorator());
                CollatingRowIterator collator = new CollatingRowIterator(comparator);
                collator.addRowIterator(this.excludeDeletedAndUpdated(rows));
                Column column = this.getColumn(col.getName());
                Index basendx = this.getIndexForColumn(column);
                this.addUpdatedRowIterator(basendx, node, collator, readOnly);
                this.addInsertedRowIterator(basendx, node, collator, readOnly);
                rows = collator;
            } else {
                rows = UnmodifiableRowIterator.wrap(rows);
            }
        }
        return rows;
    }

    private Selectable getIndexColumn(Selectable node) {
        Selectable column;
        Function fn;
        if (node instanceof ColumnIdentifier) {
            return node;
        }
        if (node instanceof ComparisonFunction) {
            ComparisonFunction fn2 = (ComparisonFunction)node;
            Selectable left = fn2.getArgument(0);
            Selectable right = fn2.getArgument(1);
            if (left instanceof ColumnIdentifier && right instanceof Literal) {
                return left;
            }
            if (left instanceof Literal && right instanceof ColumnIdentifier) {
                return right;
            }
        } else if (node instanceof Function && (fn = (Function)node).getArgumentCount() == 1 && (column = fn.getArgument(0)) instanceof ColumnIdentifier) {
            return column;
        }
        return null;
    }

    private void addUpdatedRowIterator(Index basendx, Selectable node, CollatingRowIterator collator, boolean readOnly) throws AxionException {
        this.makeIndexForRowsInTransaction(basendx, this._updatedRows);
        collator.addRowIterator(this._updatedRows.getIndexedRows(this, node, readOnly));
    }

    private void addInsertedRowIterator(Index basendx, Selectable node, CollatingRowIterator collator, boolean readOnly) throws AxionException {
        this.makeIndexForRowsInTransaction(basendx, this._insertedRows);
        collator.addRowIterator(new InsertedRowIterator(this._insertedRows.getIndexedRows(this, node, readOnly)));
    }

    private void makeIndexForRowsInTransaction(Index basendx, IntRowMap rowMap) throws AxionException {
        if (rowMap.getIndexForColumn(basendx.getIndexedColumn()) == null) {
            Index index = null;
            index = basendx.getType().equals("array") ? ARRAY_INDEX_FACTORY.makeNewInstance(basendx.getName(), basendx.getIndexedColumn(), false, true) : BTREE_INDEX_FACTORY.makeNewInstance(basendx.getName(), basendx.getIndexedColumn(), false, true);
            rowMap.addIndex(index);
            rowMap.populateIndex(this, index);
        }
    }

    public final int getRowCount() {
        return this._table.getRowCount() + this._insertedRows.size() - this._deletedRows.size();
    }

    public final int getNextRowId() {
        return this._table.getNextRowId();
    }

    public final void freeRowId(int id) {
        this._table.freeRowId(id);
    }

    public void drop() throws AxionException {
        this._table.drop();
        this._table = null;
        this._dec = null;
        this._insertedRows = null;
        this._updatedRows = null;
        this._deletedRows = null;
    }

    public void checkpoint() throws AxionException {
        this._table.checkpoint();
    }

    public void shutdown() throws AxionException {
        if (this.hasInserts()) {
            this.freeRowIds();
            this._insertedRows.shutdown();
        }
        if (this.hasUpdates()) {
            this._updatedRows.shutdown();
        }
        if (this.hasDeletes()) {
            this._deletedRows.clear();
        }
        if (this._dec != null) {
            this._dec = null;
        }
        if (this._table != null) {
            this._table.shutdown();
        }
    }

    public void setDeferAllConstraints(boolean deferAll) {
        this._deferAll = deferAll;
    }

    public void setSequence(Sequence seq) throws AxionException {
        this._table.setSequence(seq);
    }

    public final Sequence getSequence() {
        return this._table.getSequence();
    }

    public void remount(File dir, boolean dataOnly) throws AxionException {
        this._table.remount(dir, dataOnly);
    }

    public void rename(String oldName, String newName) throws AxionException {
        this._table.rename(oldName, newName);
    }

    public Row getRow(int id) throws AxionException {
        if (this.isDeleted(id)) {
            return null;
        }
        Row row = this._updatedRows.getRow(id);
        if (null != row) {
            return row;
        }
        row = this.getInsertedRow(id);
        if (null != row) {
            return row;
        }
        return this._table.getRow(id);
    }

    public final void applyInserts(RowCollection rows) throws AxionException {
        this._table.applyInserts(rows);
    }

    public final void applyDeletes(IntCollection rowids) throws AxionException {
        this._table.applyDeletes(rowids);
    }

    public final void applyUpdates(RowCollection rows) throws AxionException {
        this._table.applyUpdates(rows);
    }

    public void commit() throws AxionException {
        this.assertOpen();
        if (this.hasDeferredConstraint()) {
            if (this.hasInserts()) {
                this.checkConstraints(null, this._insertedRows.rowIterator());
            }
            if (this.hasDeletes()) {
                this.checkConstraints(new LazyRowRowIterator(this._table, this._deletedRows.listIterator(), this._deletedRows.size()), null);
            }
            if (this.hasUpdates()) {
                this.checkConstraints(new LazyRowRowIterator(this._table, this._updatedRows.keyIterator(), this._updatedRows.size()), this._updatedRows.rowIterator());
            }
        }
        this._state = 1;
    }

    public void rollback() throws AxionException {
        this.assertOpenOrCommitted();
        this.freeRowIds();
        this._table = null;
        this._dec = null;
        this._insertedRows = null;
        this._updatedRows = null;
        this._deletedRows = null;
        this._state = 2;
    }

    private void freeRowIds() {
        IntListIterator itr = this._insertedRows.keyIterator();
        while (itr.hasNext()) {
            this.freeRowId(itr.next());
        }
    }

    public void apply() throws AxionException {
        this.assertCommitted();
        if (!this._deletedRows.isEmpty()) {
            this._table.applyDeletes(this._deletedRows);
            this._deletedRows.clear();
        }
        if (!this._updatedRows.isEmpty()) {
            this._table.applyUpdates(this._updatedRows.rowValues());
            this._updatedRows.clear();
        }
        if (!this._insertedRows.isEmpty()) {
            this._table.applyInserts(this._insertedRows.rowValues());
            this._insertedRows.clear();
        }
        this._state = 3;
    }

    public final TransactableTable makeTransactableTable() {
        return new TransactableTableImpl(this);
    }

    public void deleteRow(Row row) throws AxionException {
        RowDeletedEvent event = new RowDeletedEvent(this, row, null);
        this.checkConstraints(event, this.makeRowDecorator());
        if (this._deletedRows.add(row.getIdentifier())) {
            this._updatedRows.deleteRow(this, row);
            this.publishEvent(event);
        }
    }

    public void updateRow(Row oldrow, Row newrow) throws AxionException {
        newrow.setIdentifier(oldrow.getIdentifier());
        RowUpdatedEvent event = new RowUpdatedEvent(this, oldrow, newrow);
        this.checkConstraints(event, this.makeRowDecorator());
        this._updatedRows.updateRow(this, oldrow, newrow);
        this.publishEvent(event);
    }

    private final Row getInsertedRow(int id) {
        return this._insertedRows.getRow(id);
    }

    private void assertOpen() throws AxionException {
        if (0 != this._state) {
            throw new AxionException("Already committed or rolled back [" + this._state + "].");
        }
    }

    private void assertOpenOrCommitted() throws AxionException {
        if (0 != this._state && 1 != this._state) {
            throw new AxionException("Already committed or rolled back [" + this._state + "].");
        }
    }

    private void assertCommitted() throws AxionException {
        if (1 != this._state) {
            throw new AxionException("Not committed [" + this._state + "].");
        }
    }

    private final boolean isDeleted(int rowid) {
        return this._deletedRows.contains(rowid);
    }

    protected final boolean isDeferAll() {
        return this._deferAll;
    }

    private RowIterator excludeDeletedTransformUpdated(RowIterator base) {
        if (null == base) {
            return null;
        }
        return new TransactableTableRowIterator(new ExcludeDeleted(new TransformUpdated(base)));
    }

    private RowIterator excludeDeletedAndUpdated(RowIterator base) {
        if (null == base) {
            return null;
        }
        return new TransactableTableRowIterator(new ExcludeDeleted(new ExcludeUpdated(base)));
    }

    private final boolean hasUpdates() {
        return this._updatedRows != null && !this._updatedRows.isEmpty();
    }

    private final boolean hasDeletes() {
        return this._deletedRows != null && !this._deletedRows.isEmpty();
    }

    private final boolean hasInserts() {
        return this._insertedRows != null && !this._insertedRows.isEmpty();
    }

    public void truncate() throws AxionException {
        this._insertedRows.clear();
        this._updatedRows.clear();
        this._deletedRows.clear();
        this._table.truncate();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(10);
        buf.append("TransactableTable[");
        buf.append("name=").append(this._table.getName()).append(":");
        buf.append("inserted=").append(this._insertedRows.size()).append(",");
        buf.append("updated=").append(this._updatedRows.size()).append(",");
        buf.append("deleted=").append(this._deletedRows.size()).append("]");
        return buf.toString();
    }

    private class InsertedRowIterator
    extends DelegatingRowIterator {
        public InsertedRowIterator(RowIterator iter) {
            super(iter);
        }

        public void add(Row row) throws AxionException {
            TransactableTableImpl.this.addRow(row);
        }

        public void remove() throws AxionException {
            TransactableTableImpl.this._table.freeRowId(this.current().getIdentifier());
            super.remove();
        }

        public void set(Row row) throws AxionException {
            TransactableTableImpl.this.updateRow(this.current(), row);
        }
    }

    private class TransformUpdated
    extends TransformingRowIterator {
        public TransformUpdated(RowIterator iter) {
            super(iter);
        }

        protected Row transform(Row row) {
            Row updated = TransactableTableImpl.this._updatedRows.getRow(row.getIdentifier());
            if (null != updated) {
                return updated;
            }
            return row;
        }
    }

    private class ExcludeUpdated
    extends AbstractAcceptingRowIterator {
        public ExcludeUpdated(RowIterator iter) {
            super(iter);
        }

        protected boolean acceptable(int rowindex, Row row) throws AxionException {
            return !TransactableTableImpl.this._updatedRows.containsKey(row.getIdentifier());
        }

        public int size() throws AxionException {
            return this.getDelegate().size() - TransactableTableImpl.this._updatedRows.size();
        }
    }

    private class ExcludeDeleted
    extends AbstractAcceptingRowIterator {
        public ExcludeDeleted(RowIterator iter) {
            super(iter);
        }

        protected boolean acceptable(int rowindex, Row row) throws AxionException {
            return !TransactableTableImpl.this.isDeleted(row.getIdentifier());
        }

        public int size() throws AxionException {
            return this.getDelegate().size() - TransactableTableImpl.this._deletedRows.size();
        }
    }

    private class TransactableTableRowIterator
    extends DelegatingRowIterator {
        public TransactableTableRowIterator(RowIterator iter) {
            super(iter);
        }

        public void add(Row row) throws AxionException {
            TransactableTableImpl.this.addRow(row);
        }

        public void remove() throws AxionException {
            TransactableTableImpl.this.deleteRow(this.current());
        }

        public void set(Row row) throws AxionException {
            TransactableTableImpl.this.updateRow(this.current(), row);
        }
    }
}

