/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.axiondb.AxionException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Database;
import org.axiondb.OrderNode;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.TableIdentifier;
import org.axiondb.engine.commands.AxionQueryContext;
import org.axiondb.engine.commands.AxionQueryPlanner;
import org.axiondb.engine.commands.BaseAxionCommand;
import org.axiondb.engine.rowiterators.RowIteratorRowDecoratorIterator;
import org.axiondb.engine.visitors.AmbiguousColumnReferenceVisitor;
import org.axiondb.engine.visitors.AssertGroupByRulesVisitor;
import org.axiondb.engine.visitors.FindAggregateFunctionVisitor;
import org.axiondb.engine.visitors.FindBindVariableVisitor;
import org.axiondb.engine.visitors.ResolveFromNodeVisitor;
import org.axiondb.jdbc.AxionResultSet;
import org.axiondb.types.StringType;

public class SelectCommand
extends BaseAxionCommand {
    protected AxionQueryContext _context;
    protected Database _currentDatabase;
    protected AxionQueryPlanner _planner;

    public SelectCommand(AxionQueryContext context) {
        this._context = context;
        this._planner = new AxionQueryPlanner(context);
    }

    public boolean execute(Database database) throws AxionException {
        this.setResultSet(this.executeQuery(database));
        return this.getResultSet() != null;
    }

    public AxionResultSet executeQuery(Database db) throws AxionException {
        return this.executeQuery(db, true);
    }

    public AxionResultSet executeQuery(Database db, boolean isReadOnly) throws AxionException {
        RowIterator rows = this.makeRowIterator(db, isReadOnly);
        if (this._context.isExplain()) {
            return this.makeExplainResultSet(rows);
        }
        return new AxionResultSet(new RowIteratorRowDecoratorIterator(rows, new RowDecorator(this._planner.getColumnIdToFieldMap())), this._context.getSelected(), null);
    }

    public int executeUpdate(Database database) throws AxionException {
        throw new UnsupportedOperationException("Use executeQuery, not executeUpdate.");
    }

    public Map getColumnIdToFieldMap() {
        return this._planner.getColumnIdToFieldMap();
    }

    public AxionQueryContext getQueryContext() {
        return this._context;
    }

    public String toString() {
        return this._context.toString();
    }

    protected void buildTableList(Database db) throws AxionException {
        this._context.setTables(this._context.getFromArray());
    }

    protected void buildBindVariables() {
        this.setBindVariableVisitor(new FindBindVariableVisitor());
        this.getBindVariableVisitor().visit(this);
    }

    public RowIterator makeRowIterator(Database db, boolean isReadOnly) throws AxionException {
        return this.makeRowIterator(db, isReadOnly, false);
    }

    public RowIterator makeRowIterator(Database db, boolean isReadOnly, boolean refresh) throws AxionException {
        this.resolve(db);
        if (refresh || this._currentDatabase != db || this._context.foundAggregateFunction() || this._context.getGroupByCount() > 0) {
            this._context.setSelected(this.generateSelectArrayForResultSet());
            this._context.setRows(this._planner.makeRowIterator(db, isReadOnly));
        } else {
            this._context.getRows().reset();
        }
        this._currentDatabase = db;
        return this._context.getRows();
    }

    protected void resolve(Database db) throws AxionException {
        if (!this._context.isResolved()) {
            AssertGroupByRulesVisitor gpVisitor;
            boolean foundScalar;
            ResolveFromNodeVisitor fnVisitor = new ResolveFromNodeVisitor();
            fnVisitor.resolveFromNode(this._context.getFrom(), db);
            this.buildTableList(db);
            ArrayList<Selectable> tempList = new ArrayList<Selectable>();
            int I = this._context.getSelectCount();
            for (int i = 0; i < I; ++i) {
                Selectable selectable = this.resolveSelectable(this._context.getSelect(i), db, tempList, this._context.getTables());
                this._context.setSelect(i, selectable);
                tempList.add(selectable);
            }
            tempList = null;
            Selectable sel = this._context.getSelect(0);
            if (sel instanceof ColumnIdentifier && "*".equals(((ColumnIdentifier)sel).getName())) {
                this.addColumnIdentifiersForStar(db, this._context.getResolvedSelect(), this._context.getTables(), (ColumnIdentifier)sel);
            } else {
                this._context.addAllSelectToResolvedSelect();
            }
            fnVisitor.resolveFromNode(this._context.getFrom(), db, this._context.getResolvedSelect());
            this._context.setWhere(this.resolveSelectable(this._context.getWhere(), db, this._context.getResolvedSelect(), this._context.getTables()));
            FindAggregateFunctionVisitor findAggr = new FindAggregateFunctionVisitor();
            findAggr.visit(this._context.getWhere());
            if (findAggr.foundAggregateFunction()) {
                throw new AxionException("group function is not allowed here");
            }
            if (!this._context.getGroupBy().isEmpty()) {
                ArrayList<Selectable> temp = new ArrayList<Selectable>();
                int I2 = this._context.getGroupByCount();
                for (int i = 0; i < I2; ++i) {
                    Selectable gp = this._context.getGroupBy(i);
                    Selectable gp1 = this.resolveSelectable(gp, db, this._context.getResolvedSelect(), this._context.getTables());
                    temp.add(gp1);
                }
                this._context.setGroupBy(temp);
            }
            this._context.setFoundAggregateFunction(!(foundScalar = (gpVisitor = new AssertGroupByRulesVisitor()).visit(this._context.getSelect(), this._context.getGroupBy())));
            gpVisitor = new AssertGroupByRulesVisitor();
            this._context.setHaving(this.resolveSelectable(this._context.getHaving(), db, this._context.getResolvedSelect(), this._context.getTables()));
            gpVisitor.visit(Collections.singletonList(this._context.getHaving()), this._context.getGroupBy());
            if (!this._context.getOrderBy().isEmpty()) {
                int I3 = this._context.getOrderByCount();
                for (int i = 0; i < I3; ++i) {
                    OrderNode ob = this._context.getOrderBy(i);
                    ob.setSelectable(this.resolveSelectable(ob.getSelectable(), db, this._context.getResolvedSelect(), this._context.getTables()));
                }
            }
            if (!this._context.getOrderBy().isEmpty()) {
                AmbiguousColumnReferenceVisitor ambiguityCheck = new AmbiguousColumnReferenceVisitor();
                ambiguityCheck.visit(this._context.getSelect(), this._context.getOrderBy());
            }
            this._context.setResolved(true);
        }
    }

    private void addColumnIdentifiersForStar(Database db, List list, TableIdentifier[] tables, ColumnIdentifier colid) throws AxionException {
        if (null == colid.getTableName()) {
            int J = this._context.getFromCount();
            for (int j = 0; j < J; ++j) {
                list.addAll(this.getColIdentifierList(db.getTable(tables[j]), tables[j]));
            }
        } else {
            TableIdentifier tid = colid.getTableIdentifier();
            list.addAll(this.getColIdentifierList(db.getTable(tid), tid));
        }
    }

    private Selectable[] generateSelectArrayForResultSet() throws AxionException {
        List list = this._context.getResolvedSelect();
        return list.toArray(new Selectable[list.size()]);
    }

    private AxionResultSet makeExplainResultSet(RowIterator iter) {
        HashMap<ColumnIdentifier, Integer> map = new HashMap<ColumnIdentifier, Integer>();
        ColumnIdentifier resultcolumn = new ColumnIdentifier(null, "EXPLANATION", null, StringType.instance());
        map.put(resultcolumn, new Integer(0));
        RowIterator rowIter = this._planner.getPlanNodeRowIterator();
        return new AxionResultSet(new RowIteratorRowDecoratorIterator(rowIter, new RowDecorator(map)), new Selectable[]{resultcolumn}, null);
    }
}

