/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.OrderNode;
import org.axiondb.Row;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.VariableContext;
import org.axiondb.engine.commands.AxionQueryContext;
import org.axiondb.engine.commands.SelectCommand;
import org.axiondb.engine.tables.TableView;
import org.axiondb.jdbc.AxionResultSet;
import org.axiondb.types.AnyType;

public class SubSelectCommand
extends SelectCommand
implements Selectable {
    private Database _dbForSubSelect;
    private boolean _evaluteAsScalarValue = false;
    private boolean _foundCorrelatedColumnReference = false;
    private volatile transient TableView _view;

    public SubSelectCommand(AxionQueryContext context) {
        super(context);
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        if (this._evaluteAsScalarValue) {
            RowIterator rowIter = this.getRowIterator(this._dbForSubSelect, row);
            Object rval = null;
            if (rowIter.hasNext()) {
                Row rrow = rowIter.next();
                if (rowIter.hasNext()) {
                    throw new AxionException("single-row subquery returns more than one row");
                }
                if (rrow.size() > 1) {
                    throw new AxionException("too many values");
                }
                rval = rrow.get(0);
            }
            return rval;
        }
        return this.getRowIterator(this._dbForSubSelect, row);
    }

    public boolean execute(Database database) throws AxionException {
        throw new UnsupportedOperationException("Can't execute the sub-query directly");
    }

    public AxionResultSet executeQuery(Database db) throws AxionException {
        throw new UnsupportedOperationException("Can't execute the sub-query directly");
    }

    public int executeUpdate(Database database) throws AxionException {
        throw new UnsupportedOperationException("Can't execute the sub-query directly");
    }

    public String getAlias() {
        return this._context.getAliasName();
    }

    public DataType getDataType() {
        return AnyType.INSTANCE;
    }

    public String getLabel() {
        return this.getName();
    }

    public String getName() {
        return this._context.getAliasName() != null ? this._context.getAliasName() : "SELECT";
    }

    public RowIterator getRowIterator(Database db) throws AxionException {
        return this.getTableView(db, null).getRowIterator(true);
    }

    public RowIterator getRowIterator(Database db, RowDecorator rowDec) throws AxionException {
        this._context.setParentRow(rowDec);
        return this.getTableView(db, null).getRowIterator(true);
    }

    public Table getTableView(Database db, String name) throws AxionException {
        if (this._view == null) {
            this._view = new TableView(db, name, this);
        }
        return this._view;
    }

    public Table getTableView(Database db, String name, boolean addToDb) throws AxionException {
        if (this._view == null) {
            this._view = new TableView(db, name, this);
        }
        if (addToDb && !db.hasTable(this._view.getName())) {
            db.addTable(this._view);
        }
        return this._view;
    }

    public boolean isScalarSelect() {
        return this._evaluteAsScalarValue;
    }

    public boolean isCorrelated() {
        return this._foundCorrelatedColumnReference;
    }

    public RowIterator makeRowIterator(Database db, boolean readOnly) throws AxionException {
        if (this._context.getRows() == null || this._currentDatabase != db || this._context.getGroupByCount() > 0 || this._evaluteAsScalarValue && this._context.isCorrelatedSubQuery()) {
            super.makeRowIterator(db, readOnly, true);
        } else {
            this._context.getRows().reset();
        }
        return this._context.getRows();
    }

    public void setAlias(String aliasName) {
        this._context.setAliasName(aliasName);
    }

    public void setDB(Database db) {
        this._dbForSubSelect = db;
    }

    public void setEvaluteAsScalarValue() {
        this._evaluteAsScalarValue = true;
    }

    public void setParentTables(TableIdentifier[] tables) {
        this._context.setParentTables(tables);
    }

    public void setVariableContext(VariableContext context) {
    }

    protected void buildTableList(Database db) throws AxionException {
        TableIdentifier[] t = this._context.getFromArray();
        this.findCorrelatedColumnReference(db, t);
        this._context.setCorrelatedSubQuery(this.isCorrelated());
        if (this.isCorrelated()) {
            int i;
            TableIdentifier[] pt = this._context.getParentTables();
            int tableLen = t.length;
            TableIdentifier[] tables = new TableIdentifier[tableLen += pt.length];
            int pos = 0;
            for (i = 0; t != null && i < t.length; ++i) {
                tables[pos++] = t[i];
            }
            for (i = 0; pt != null && i < pt.length; ++i) {
                tables[pos++] = pt[i];
            }
            this._context.setTables(tables);
        } else {
            this._context.setParentTables(null);
            this._context.setParentRow(null);
            this._context.setTables(t);
        }
    }

    private boolean findCorrelatedColumnReference(Database db, TableIdentifier[] t) throws AxionException {
        this._foundCorrelatedColumnReference = false;
        try {
            int i;
            int I;
            if (this._context.getWhere() != null) {
                this.resolveSelectable(this._context.getWhere(), db, t);
            }
            if (null != this._context.getGroupBy()) {
                I = this._context.getGroupByCount();
                for (i = 0; i < I; ++i) {
                    this.resolveSelectable(this._context.getGroupBy(i), db, t);
                }
            }
            this.resolveSelectable(this._context.getHaving(), db, t);
            if (null != this._context.getOrderBy()) {
                I = this._context.getOrderByCount();
                for (i = 0; i < I; ++i) {
                    OrderNode ob = this._context.getOrderBy(i);
                    this.resolveSelectable(ob.getSelectable(), db, t);
                }
            }
        }
        catch (AxionException e) {
            this._foundCorrelatedColumnReference = true;
        }
        return this._foundCorrelatedColumnReference;
    }
}

