/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.indexes;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.primitives.IntList;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.IndexLoader;
import org.axiondb.engine.ObjectArrayIndexLoader;
import org.axiondb.engine.indexes.BaseArrayIndex;

public class ObjectArrayIndex
extends BaseArrayIndex {
    private static final IndexLoader LOADER = new ObjectArrayIndexLoader();
    private ArrayList _keys = null;

    public ObjectArrayIndex(String name, Column column, boolean unique) {
        super(name, column, unique);
        this._keys = new ArrayList();
    }

    public ObjectArrayIndex(String name, Column column, boolean unique, ArrayList keys, IntList values) {
        super(name, column, unique, values);
        this._keys = keys;
    }

    public IndexLoader getIndexLoader() {
        return LOADER;
    }

    public List getKeyList() {
        return this._keys;
    }

    public void truncate() throws AxionException {
        super.truncate();
        if (this._keys != null) {
            this._keys.clear();
        }
    }

    protected int find(Object seeking, boolean required) {
        int high = this._keys.size();
        int low = 0;
        int cur = 0;
        boolean found = false;
        while (low < high) {
            cur = (high + low) / 2;
            int comp = this.getComparator().compare(seeking, this._keys.get(cur));
            if (0 == comp) {
                found = true;
                break;
            }
            if (comp < 0) {
                high = cur;
                continue;
            }
            if (low == cur) {
                // empty if block
            }
            low = ++cur;
        }
        if (!this.isUnique()) {
            while (cur > 0 && this.getComparator().compare(seeking, this._keys.get(cur - 1)) == 0) {
                --cur;
            }
        }
        if (!found) {
            return required ? -1 : cur;
        }
        return cur;
    }

    protected List getKeyList(int minIndex, int maxIndex) {
        return this._keys.subList(minIndex, maxIndex);
    }

    protected int insertKey(Object seeking) throws AxionException {
        int high = this._keys.size();
        int low = 0;
        int cur = 0;
        while (low < high) {
            cur = (high + low) / 2;
            int comp = this.getComparator().compare(seeking, this._keys.get(cur));
            if (0 == comp) {
                if (!this.isUnique()) break;
                throw new AxionException("Expected " + this.getIndexedColumn() + " to be unique, found " + seeking + " already.");
            }
            if (comp < 0) {
                high = cur;
                continue;
            }
            if (low == cur) {
                // empty if block
            }
            low = ++cur;
        }
        this._keys.add(cur, seeking);
        return cur;
    }

    protected int removeKey(Comparable seeking) throws AxionException {
        int index = this.find(seeking, true);
        if (-1 != index) {
            this._keys.remove(index);
        }
        return index;
    }

    protected int removeKey(Object value) throws AxionException {
        return this.removeKey((Comparable)value);
    }

    protected void removeKeyAt(int index) throws AxionException {
        this._keys.remove(index);
    }
}

