/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.ExternalTable;
import org.axiondb.Row;
import org.axiondb.TableFactory;
import org.axiondb.TableOrganizationContext;
import org.axiondb.engine.tables.BaseDiskTable;
import org.axiondb.engine.tables.BaseTableOrganizationContext;
import org.axiondb.io.BufferedDataInputStream;
import org.axiondb.io.BufferedDataOutputStream;
import org.axiondb.io.FileUtil;
import org.axiondb.types.CharacterType;
import org.axiondb.types.LOBType;
import org.axiondb.types.ObjectType;
import org.axiondb.types.StringType;

public abstract class BaseFlatfileTable
extends BaseDiskTable
implements ExternalTable {
    protected static final int EOF = -1;
    protected static final char FILLER = ' ';
    public static final String PROP_FILENAME = "FILENAME";
    protected static final String PROP_ISFIRSTLINEHEADER = "ISFIRSTLINEHEADER";
    protected static final String PROP_RECORDDELIMITER = "RECORDDELIMITER";
    protected static final String PROP_ROWSTOSKIP = "ROWSTOSKIP";
    protected static final String PROP_MAXFAULTS = "MAXFAULTS";
    protected static final String PROP_TRIMWHITESPACE = "TRIMWHITESPACE";
    private static final Set PROPERTY_KEYS = new HashSet(4);
    public static String PARAM_KEY_FILE_NAME;
    public static String PARAM_KEY_TEMP_FILE_NAME;
    public static String PARAM_KEY_FILE_DIR;
    protected TableOrganizationContext context;
    protected String _fileName;
    protected boolean _isFirstLineHeader = false;
    protected int _rowsToSkip = 0;
    protected long _maxFaults = Long.MAX_VALUE;
    private boolean _isCreateDataFileIfNotExist = true;
    protected boolean _trimWhiteSpace = false;
    protected String _lineSep;

    public BaseFlatfileTable(String name, Database db, TableFactory factory) throws AxionException {
        super(name, db, factory);
    }

    public void addColumn(Column col, boolean metaUpdateNeeded) throws AxionException {
        if (col.getDataType() instanceof LOBType || col.getDataType() instanceof ObjectType) {
            throw new UnsupportedOperationException("Lob or Object Type not supported for this Table Type");
        }
        super.addColumn(col, metaUpdateNeeded);
    }

    public boolean loadExternalTable(Properties props) throws AxionException {
        try {
            this.context.readOrSetDefaultProperties(props);
            this.context.updateProperties();
            this.createOrLoadDataFile();
            this.initializeTable();
            this.writeMetaFile();
            return true;
        }
        catch (Exception e) {
            try {
                this.drop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new AxionException("Failed to create table using supplied properties. ", e);
        }
    }

    public void remount() throws AxionException {
        this.remount(this.getRootDir(), false);
    }

    public static String addEscapeSequence(String srcString) {
        StringBuffer buf = new StringBuffer(srcString.length() + 2);
        char[] srcArray = srcString.toCharArray();
        block7: for (int i = 0; i < srcArray.length; ++i) {
            char c = srcArray[i];
            switch (c) {
                case '\t': {
                    buf.append("\\t");
                    continue block7;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block7;
                }
                case '\b': {
                    buf.append("\\b");
                    continue block7;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block7;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    protected void createOrLoadDataFile() throws AxionException {
        this.createOrLoadDataFile(this._isCreateDataFileIfNotExist);
    }

    protected void createOrLoadDataFile(boolean createNewDataFile) throws AxionException {
        if (!createNewDataFile && !this.getDataFile().exists()) {
            throw new AxionException("Data file \"" + this.getDataFile() + "\" for table " + this.getName() + " not found.");
        }
        try {
            if (this.getDataFile().createNewFile()) {
                this.writeHeader(this.getOutputStream());
            } else {
                this.getOutputStream();
            }
            this.getInputStream();
        }
        catch (IOException ioex) {
            throw new AxionException("Unable to create data file \"" + this.getDataFile() + "\" for table " + this.getName() + ".", ioex);
        }
    }

    public static String fixEscapeSequence(String srcString) {
        if (srcString == null || srcString.length() < 2) {
            return srcString;
        }
        char[] srcArray = srcString.toCharArray();
        char[] tgtArray = (char[])srcArray.clone();
        Arrays.fill(tgtArray, ' ');
        int j = 0;
        for (int i = 0; i < srcArray.length; ++i) {
            int c = srcArray[i];
            if (i + 1 == srcArray.length) {
                tgtArray[j++] = c;
                break;
            }
            if (c == 92) {
                switch (srcArray[i + 1]) {
                    case 't': {
                        c = 9;
                        break;
                    }
                    case 'r': {
                        c = 13;
                        break;
                    }
                    case 'b': {
                        c = 8;
                        break;
                    }
                    case 'n': {
                        c = 10;
                        break;
                    }
                    case 'f': {
                        c = 12;
                    }
                }
                ++i;
            }
            tgtArray[j++] = c;
        }
        return new String(tgtArray, 0, j);
    }

    protected File getDataFile() {
        if (this._dataFile != null) {
            return this._dataFile;
        }
        this._dataFile = this._fileName.indexOf("\\") > -1 || this._fileName.indexOf("/") > -1 || this._fileName.indexOf(File.separator) > -1 ? new File(this._fileName) : new File(this._dbdir, this._fileName);
        return this._dataFile;
    }

    protected synchronized void renameTableFiles(String oldName, String name, Properties newFileProps) {
        String newDir = null;
        String oldFileName = null;
        File newDirObj = null;
        String newFileName = null;
        super.renameTableFiles(oldName, name);
        if (newFileProps != null) {
            newDir = newFileProps.getProperty(PARAM_KEY_FILE_DIR);
            newFileName = newFileProps.getProperty(PARAM_KEY_FILE_NAME);
            oldFileName = newFileProps.getProperty(PARAM_KEY_TEMP_FILE_NAME);
        }
        if (newDir != null) {
            newDirObj = new File(newDir);
            FileUtil.renameFile(newDirObj, oldFileName, newFileName);
            this._fileName = newDir + newFileName;
        } else {
            FileUtil.renameFile(this._dbdir, oldName, name, "." + this.getDefaultDataFileExtension());
            this._fileName = name + "." + this.getDefaultDataFileExtension();
        }
        this.context.setProperty(PROP_FILENAME, this._fileName);
    }

    protected synchronized void renameTableFiles(String oldName, String name) {
        this.renameTableFiles(oldName, name, null);
    }

    protected File getLobDir() {
        throw new UnsupportedOperationException("Lobs Datatype is not supported");
    }

    protected long ignoreRowsToSkip() throws AxionException {
        if (this._rowsToSkip > 0) {
            int offset = 0;
            int i = this._rowsToSkip;
            while (i-- > 0) {
                offset += this.nextLineLength(offset);
            }
            return offset;
        }
        if (this._isFirstLineHeader) {
            return this.nextLineLength(0L);
        }
        return 0L;
    }

    protected void initializeTable() throws AxionException {
        try {
            int faultCount = 0;
            this._rowCount = 0;
            long fileLength = FileUtil.getLength(this.getDataFile());
            long fileOffset = this.ignoreRowsToSkip();
            while (-1L != fileOffset && fileOffset + (long)this._lineSep.length() < fileLength - 1L) {
                block5: {
                    this.getPidxList().add(fileOffset);
                    int idToAssign = this.getPidxList().size() - 1;
                    try {
                        ++this._rowCount;
                        this.getRowByOffset(idToAssign, fileOffset);
                    }
                    catch (AxionException e) {
                        this.getPidxList().set(idToAssign, 0xFFFFFFFFL);
                        this._freeIds.add(idToAssign);
                        --this._rowCount;
                        if ((long)(++faultCount) <= this._maxFaults) break block5;
                        String msg = "Fault tolerance threshold (" + this._maxFaults + ") exceeded for table " + this.getName() + ". ";
                        throw new AxionException(msg + e.getMessage(), e);
                    }
                }
                fileOffset = this.getInputStream().getPos();
            }
            this.getPidxList().flush();
        }
        catch (Exception e) {
            throw new AxionException(e);
        }
    }

    protected abstract boolean isEndOfRecord(int var1, int var2, BufferedDataInputStream var3) throws IOException;

    protected boolean isEOF(int nextChar) {
        return nextChar == -1;
    }

    protected boolean isNullString(String str) {
        return str == null || str.trim().length() == 0;
    }

    protected String getDefaultDataFileExtension() {
        return "txt";
    }

    protected void reloadFilesAfterTruncate() throws AxionException {
        this._freeIds = new ArrayIntList();
        this.writeFridFile();
        this.initFiles(this.getDataFile(), true);
        this.createOrLoadDataFile(true);
        this.initializeTable();
        this.initializeRowCount();
    }

    protected Row trySettingColumn(int idToAssign, Row row, int i, String colValue) throws AxionException {
        DataType columnDataType = this.getColumn(i).getDataType();
        if ((colValue = this.evaluateForNull(colValue, columnDataType)) == null) {
            row.set(i, null);
        } else {
            Object val = columnDataType.convert(colValue);
            row.set(i, val);
        }
        return row;
    }

    protected String evaluateForNull(String colValue, DataType datatype) {
        if (null == colValue) {
            return null;
        }
        if (datatype instanceof CharacterType) {
            int colWidth = datatype.getPrecision();
            return colWidth <= 0 || colValue.length() == colWidth && colValue.trim().length() == 0 ? null : colValue;
        }
        if (!(datatype instanceof StringType) && colValue.trim().length() == 0) {
            return null;
        }
        return colValue;
    }

    protected abstract void writeHeader(BufferedDataOutputStream var1) throws AxionException;

    protected int nextLineLength(long fileOffset) throws AxionException {
        if (fileOffset < 0L) {
            return -1;
        }
        try {
            int nextChar;
            int recLength = 0;
            BufferedDataInputStream data = this.getInputStream();
            data.seek(fileOffset);
            do {
                nextChar = data.read();
                ++recLength;
                if (!this.isEOF(nextChar)) continue;
                if (recLength > 1) {
                    return recLength;
                }
                return -1;
            } while (!this.isEndOfRecord(recLength, nextChar, data));
            recLength = (int)(data.getPos() - fileOffset);
            return recLength;
        }
        catch (Exception e) {
            throw new AxionException("Unable to parse data file: ", e);
        }
    }

    static {
        PROPERTY_KEYS.add(PROP_FILENAME);
        PROPERTY_KEYS.add("CREATE_IF_NOT_EXIST");
        PROPERTY_KEYS.add(PROP_ISFIRSTLINEHEADER);
        PROPERTY_KEYS.add(PROP_RECORDDELIMITER);
        PROPERTY_KEYS.add(PROP_ROWSTOSKIP);
        PROPERTY_KEYS.add(PROP_MAXFAULTS);
        PROPERTY_KEYS.add(PROP_TRIMWHITESPACE);
        PROPERTY_KEYS.add("LOADTYPE");
        PARAM_KEY_FILE_NAME = "FLAT_FILE_NAME";
        PARAM_KEY_TEMP_FILE_NAME = "TEMP_FLAT_FILE_NAME";
        PARAM_KEY_FILE_DIR = "FLAT_FILE_DIR";
    }

    protected abstract class BaseFlatfileTableOrganizationContext
    extends BaseTableOrganizationContext {
        protected BaseFlatfileTableOrganizationContext() {
        }

        public Set getPropertyKeys() {
            HashSet keys = new HashSet(PROPERTY_KEYS.size());
            keys.addAll(PROPERTY_KEYS);
            return keys;
        }

        public void readOrSetDefaultProperties(Properties props) throws AxionException {
            this.assertValidPropertyKeys(props);
            String rawLineSep = props.getProperty(BaseFlatfileTable.PROP_RECORDDELIMITER);
            BaseFlatfileTable.this._lineSep = rawLineSep != null ? BaseFlatfileTable.fixEscapeSequence(rawLineSep) : "";
            String firstLineHeader = props.getProperty(BaseFlatfileTable.PROP_ISFIRSTLINEHEADER, "false");
            BaseFlatfileTable.this._isFirstLineHeader = Boolean.valueOf(firstLineHeader);
            BaseFlatfileTable.this._fileName = props.getProperty(BaseFlatfileTable.PROP_FILENAME);
            if (BaseFlatfileTable.this.isNullString(BaseFlatfileTable.this._fileName)) {
                BaseFlatfileTable.this._fileName = BaseFlatfileTable.this.getName() + "." + BaseFlatfileTable.this.getDefaultDataFileExtension();
            }
            if (props.getProperty("CREATE_IF_NOT_EXIST") != null && "FALSE".equalsIgnoreCase(props.getProperty("CREATE_IF_NOT_EXIST"))) {
                BaseFlatfileTable.this._isCreateDataFileIfNotExist = false;
            }
            String skipRowsStr = props.getProperty(BaseFlatfileTable.PROP_ROWSTOSKIP, "0");
            try {
                BaseFlatfileTable.this._rowsToSkip = Integer.parseInt(skipRowsStr);
            }
            catch (NumberFormatException e) {
                BaseFlatfileTable.this._rowsToSkip = 0;
            }
            String maxFaultStr = props.getProperty(BaseFlatfileTable.PROP_MAXFAULTS, Long.toString(Long.MAX_VALUE));
            try {
                BaseFlatfileTable.this._maxFaults = Long.parseLong(maxFaultStr);
            }
            catch (NumberFormatException e) {
                BaseFlatfileTable.this._maxFaults = Long.MAX_VALUE;
            }
            if (BaseFlatfileTable.this._maxFaults < 0L) {
                BaseFlatfileTable.this._maxFaults = Long.MAX_VALUE;
            }
            String trimWhiteSpaceStr = props.getProperty(BaseFlatfileTable.PROP_TRIMWHITESPACE, "false");
            BaseFlatfileTable.this._trimWhiteSpace = Boolean.valueOf(trimWhiteSpaceStr);
        }

        public void updateProperties() {
            super.updateProperties();
            this.setProperty(BaseFlatfileTable.PROP_RECORDDELIMITER, BaseFlatfileTable.addEscapeSequence(BaseFlatfileTable.this._lineSep));
            this.setProperty(BaseFlatfileTable.PROP_ISFIRSTLINEHEADER, Boolean.toString(BaseFlatfileTable.this._isFirstLineHeader));
            this.setProperty(BaseFlatfileTable.PROP_FILENAME, BaseFlatfileTable.this._fileName);
            this.setProperty(BaseFlatfileTable.PROP_ROWSTOSKIP, Integer.toString(BaseFlatfileTable.this._rowsToSkip));
            this.setProperty(BaseFlatfileTable.PROP_MAXFAULTS, Long.toString(BaseFlatfileTable.this._maxFaults));
            this.setProperty("CREATE_IF_NOT_EXIST", Boolean.toString(BaseFlatfileTable.this._isCreateDataFileIfNotExist));
            this.setProperty(BaseFlatfileTable.PROP_TRIMWHITESPACE, Boolean.toString(BaseFlatfileTable.this._trimWhiteSpace));
        }

        public Set getRequiredPropertyKeys() {
            return this.getBaseRequiredPropertyKeys();
        }
    }
}

