/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.IntegerType;
import org.axiondb.types.StringType;
import org.axiondb.util.ValuePool;

public class LengthFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType STRING_TYPE = new StringType();
    private static final DataType RETURN_TYPE = new IntegerType();

    public LengthFunction() {
        super("LENGTH");
    }

    public ConcreteFunction makeNewInstance() {
        return new LengthFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Object val = this.getArgument(0).evaluate(row);
        String strval = (String)STRING_TYPE.convert(val);
        if (null == strval) {
            return null;
        }
        return ValuePool.getInt(strval.length());
    }

    public boolean isValid() {
        return this.getArgumentCount() == 1;
    }
}

