/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import java.math.BigDecimal;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.BigDecimalType;

public class Log10Function
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType RETURN_TYPE = new BigDecimalType();

    public Log10Function() {
        super("LOG10");
    }

    public ConcreteFunction makeNewInstance() {
        return new Log10Function();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Selectable sel = this.getArgument(0);
        Object rawVal = sel.evaluate(row);
        DataType type = sel.getDataType();
        Object val = type.convert(rawVal);
        if (null == val) {
            return null;
        }
        BigDecimal bdVal = type.toBigDecimal(val);
        return new BigDecimal(Math.log(bdVal.doubleValue()) / Math.log(10.0));
    }

    public boolean isValid() {
        return this.getArgumentCount() == 1;
    }
}

