/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.StringType;

public class SoundexFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType ARG_TYPE = new StringType();
    private static final DataType RETURN_TYPE = new StringType();

    public SoundexFunction() {
        super("SOUNDEX");
    }

    public SoundexFunction(String name) {
        super(name);
    }

    public ConcreteFunction makeNewInstance() {
        return new SoundexFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Object val = this.getArgument(0).evaluate(row);
        String intVal = (String)ARG_TYPE.convert(val);
        return SoundexFunction.soundex(intVal);
    }

    public boolean isValid() {
        return this.getArgumentCount() == 1;
    }

    public static String soundex(String s) {
        if (s == null) {
            return s;
        }
        s = s.toUpperCase();
        int len = s.length();
        char[] b = new char[]{'0', '0', '0', '0'};
        int lastdigit = 48;
        int j = 0;
        for (int i = 0; i < len && j < 4; ++i) {
            int newdigit;
            char c = s.charAt(i);
            if ("AEIOUY".indexOf(c) != -1) {
                newdigit = 55;
            } else if (c == 'H' || c == 'W') {
                newdigit = 56;
            } else if ("BFPV".indexOf(c) != -1) {
                newdigit = 49;
            } else if ("CGJKQSXZ".indexOf(c) != -1) {
                newdigit = 50;
            } else if (c == 'D' || c == 'T') {
                newdigit = 51;
            } else if (c == 'L') {
                newdigit = 52;
            } else if (c == 'M' || c == 'N') {
                newdigit = 53;
            } else {
                if (c != 'R') continue;
                newdigit = 54;
            }
            if (j == 0) {
                b[j++] = c;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit <= 54) {
                if (newdigit == lastdigit) continue;
                b[j++] = newdigit;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit != 55) continue;
            lastdigit = newdigit;
        }
        return new String(b, 0, 4);
    }
}

