/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Comparator;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.types.BaseNumberDataType;

public class BigIntType
extends BaseNumberDataType {
    private static final BigDecimal MAX_BD = new BigDecimal(Long.MAX_VALUE);
    private static final BigDecimal MIN_BD = new BigDecimal(Long.MIN_VALUE);
    private static final long serialVersionUID = 249194398145634251L;

    public int getJdbcType() {
        return -5;
    }

    public String getPreferredValueClassName() {
        return "java.lang.Long";
    }

    public int getPrecision() {
        return String.valueOf(Long.MAX_VALUE).length();
    }

    public int getColumnDisplaySize() {
        return String.valueOf(Long.MIN_VALUE).length();
    }

    public String toString() {
        return "bigint";
    }

    public boolean accepts(Object value) {
        if (value instanceof Timestamp) {
            return true;
        }
        return super.accepts(value);
    }

    public Object convert(Object value) throws AxionException {
        BigDecimal rawValue = null;
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof BigDecimal) {
            rawValue = (BigDecimal)value;
        } else {
            if (value instanceof Number) {
                return new Long(((Number)value).longValue());
            }
            if (value instanceof String) {
                try {
                    rawValue = new BigDecimal(value.toString().trim());
                }
                catch (NumberFormatException e) {
                    throw new AxionException(22018);
                }
            } else {
                if (value instanceof Timestamp) {
                    return new Long(((Timestamp)value).getTime());
                }
                return super.convert(value);
            }
        }
        this.assertValueInRange(rawValue);
        return new Long(rawValue.longValue());
    }

    public Object successor(Object value) throws IllegalArgumentException {
        long v = (Long)value;
        if (v == Long.MAX_VALUE) {
            return value;
        }
        return new Long(++v);
    }

    public Object read(DataInput in) throws IOException {
        long value = in.readLong();
        if (Long.MIN_VALUE == value && !in.readBoolean()) {
            return null;
        }
        return new Long(value);
    }

    public void write(Object value, DataOutput out) throws IOException {
        if (null == value) {
            out.writeLong(Long.MIN_VALUE);
            out.writeBoolean(false);
        } else {
            try {
                long val = (Long)this.convert(value);
                out.writeLong(val);
                if (Long.MIN_VALUE == val) {
                    out.writeBoolean(true);
                }
            }
            catch (AxionException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public DataType makeNewInstance() {
        return new BigIntType();
    }

    public int compare(Object a, Object b) {
        long pb;
        long pa = ((Number)a).longValue();
        return pa < (pb = ((Number)b).longValue()) ? -1 : (pa == pb ? 0 : 1);
    }

    protected Comparator getComparator() {
        return this;
    }

    private void assertValueInRange(BigDecimal bdValue) throws AxionException {
        if (bdValue.compareTo(MIN_BD) < 0 || bdValue.compareTo(MAX_BD) > 0) {
            throw new AxionException(22003);
        }
    }
}

