/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.optimize.evaluation.Variables;
import proguard.optimize.evaluation.value.Value;

class TracedVariables
extends Variables {
    private Value producerValue;
    private Value collectedProducerValue;
    private Variables producerVariables;
    private int initializationIndex;

    public TracedVariables(int n) {
        super(n);
        this.producerVariables = new Variables(n);
    }

    public TracedVariables(TracedVariables tracedVariables) {
        super(tracedVariables);
        this.producerVariables = new Variables(tracedVariables.producerVariables);
    }

    public void setProducerValue(Value value) {
        this.producerValue = value;
    }

    public void setCollectedProducerValue(Value value) {
        this.collectedProducerValue = value;
    }

    public Value getCollectedProducerValue() {
        return this.collectedProducerValue;
    }

    public void resetInitialization() {
        this.initializationIndex = -1;
    }

    public int getInitializationIndex() {
        return this.initializationIndex;
    }

    public Value getStoredTraceValue(int n) {
        return this.producerVariables.load(n);
    }

    public void setStoredTraceValue(int n, Value value) {
        this.producerVariables.store(n, value);
    }

    public void reset(int n) {
        super.reset(n);
        this.producerVariables.reset(n);
    }

    public void initialize(TracedVariables tracedVariables) {
        super.initialize(tracedVariables);
        this.producerVariables.initialize(tracedVariables.producerVariables);
    }

    public boolean generalize(TracedVariables tracedVariables) {
        return super.generalize(tracedVariables) | this.producerVariables.generalize(tracedVariables.producerVariables);
    }

    public void store(int n, Value value) {
        Value value2 = super.load(n);
        if (value2 == null || value2.computationalType() != value.computationalType()) {
            this.initializationIndex = n;
        }
        super.store(n, value);
        this.producerVariables.store(n, this.producerValue);
    }

    public Value load(int n) {
        if (this.collectedProducerValue != null) {
            this.collectedProducerValue = this.collectedProducerValue.generalize(this.producerVariables.load(n));
        }
        return super.load(n);
    }

    public boolean equals(Object object) {
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TracedVariables tracedVariables = (TracedVariables)object;
        return super.equals(object) && this.producerVariables.equals(tracedVariables.producerVariables);
    }

    public int hashCode() {
        return super.hashCode() ^ this.producerVariables.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            Value value = this.values[i];
            Value value2 = this.producerVariables.values[i];
            stringBuffer = stringBuffer.append('[').append(value2 == null ? "empty" : value2.toString()).append('>').append(value == null ? "empty" : value.toString()).append(']');
        }
        return stringBuffer.toString();
    }
}

