/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.editor.CodeAttrInfoEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.optimize.peephole.BranchTargetFinder;

public class GotoCommonCodeReplacer
implements InstructionVisitor {
    private static final boolean DEBUG = false;
    private BranchTargetFinder branchTargetFinder;
    private CodeAttrInfoEditor codeAttrInfoEditor;
    private InstructionVisitor extraInstructionVisitor;

    public GotoCommonCodeReplacer(BranchTargetFinder branchTargetFinder, CodeAttrInfoEditor codeAttrInfoEditor) {
        this(branchTargetFinder, codeAttrInfoEditor, null);
    }

    public GotoCommonCodeReplacer(BranchTargetFinder branchTargetFinder, CodeAttrInfoEditor codeAttrInfoEditor, InstructionVisitor instructionVisitor) {
        this.branchTargetFinder = branchTargetFinder;
        this.codeAttrInfoEditor = codeAttrInfoEditor;
        this.extraInstructionVisitor = instructionVisitor;
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
        int n2;
        int n3;
        int n4;
        byte by = branchInstruction.opcode;
        if (!(by != -89 && by != -56 || this.branchTargetFinder.isBranchTarget(n) || (n4 = this.commonByteCodeCount(codeAttrInfo, n, n3 = n + (n2 = branchInstruction.branchOffset))) <= 0 || this.exceptionBoundary(codeAttrInfo, n, n3))) {
            int n5;
            for (n5 = 0; n5 <= n4; ++n5) {
                int n6 = n - n5;
                if (!this.branchTargetFinder.isInstruction(n6)) continue;
                this.codeAttrInfoEditor.replaceInstruction(n6, null);
                this.codeAttrInfoEditor.insertBeforeInstruction(n6, null);
                this.codeAttrInfoEditor.insertAfterInstruction(n6, null);
                this.codeAttrInfoEditor.deleteInstruction(n6);
            }
            n5 = n2 - n4;
            if (n5 != branchInstruction.length(n)) {
                BranchInstruction branchInstruction2 = new BranchInstruction(by, n5);
                this.codeAttrInfoEditor.replaceInstruction(n, branchInstruction2);
            }
            if (this.extraInstructionVisitor != null) {
                this.extraInstructionVisitor.visitBranchInstruction(classFile, methodInfo, codeAttrInfo, n, branchInstruction);
            }
        }
    }

    private int commonByteCodeCount(CodeAttrInfo codeAttrInfo, int n, int n2) {
        int n3;
        int n4;
        byte[] byArray = codeAttrInfo.code;
        int n5 = 0;
        for (int i = 1; i <= n && i <= n2 && n2 - i != n && byArray[n4 = n - i] == byArray[n3 = n2 - i] && !(this.branchTargetFinder.isInstruction(n4) ^ this.branchTargetFinder.isInstruction(n3)); ++i) {
            if (!this.branchTargetFinder.isInstruction(n4) || !this.branchTargetFinder.isInstruction(n3)) continue;
            if (this.branchTargetFinder.isBranchOrigin(n4) || this.branchTargetFinder.isBranchTarget(n4) || this.branchTargetFinder.isExceptionStart(n4) || this.branchTargetFinder.isExceptionEnd(n4) || this.branchTargetFinder.isInitializer(n4) || this.branchTargetFinder.isExceptionStart(n3) || this.branchTargetFinder.isExceptionEnd(n3) || this.isPop(byArray[n4])) break;
            if (this.branchTargetFinder.isBranchTarget(n3)) {
                n5 = i;
            }
            if (this.branchTargetFinder.isBranchTarget(n4)) break;
        }
        return n5;
    }

    private boolean isPop(byte by) {
        return by == 87 || by == 88 || by == -66;
    }

    private boolean exceptionBoundary(CodeAttrInfo codeAttrInfo, int n, int n2) {
        int n3;
        if (n2 < n) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        for (n3 = n; n3 <= n2; ++n3) {
            if (!this.branchTargetFinder.isExceptionStart(n3) && !this.branchTargetFinder.isExceptionEnd(n3)) continue;
            return true;
        }
        return false;
    }
}

