/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.tree.TreePath;
import org.netbeans.jellytools.JellyVersion;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.input.KeyRobotDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;
import org.netbeans.modules.visualweb.gravy.Util;
import org.openide.util.actions.SystemAction;

public class Action {
    public static final int MENU_MODE = 0;
    public static final int POPUP_MODE = 1;
    public static final int API_MODE = 2;
    public static final int SHORTCUT_MODE = 3;
    protected static final long SELECTION_WAIT_TIME = 300L;
    protected static final long AFTER_ACTION_WAIT_TIME = 0L;
    protected static final long WAIT_AFTER_SHORTCUT_TIMEOUT = 0L;
    private static final int[][] sequence = new int[][]{{0, 1, 3, 2}, {1, 0, 3, 2}, {2, 1, 0, 3}, {3, 1, 0, 2}};
    protected String menuPath;
    protected String popupPath;
    protected Class systemActionClass;
    protected Shortcut[] shortcuts;
    private static Operator.StringComparator defaultComparator;
    private Operator.StringComparator comparator;

    public Action(String menuPath, String popupPath) {
        this(menuPath, popupPath, null, (Shortcut[])null);
    }

    public Action(String menuPath, String popupPath, String systemActionClass) {
        this(menuPath, popupPath, systemActionClass, (Shortcut[])null);
    }

    public Action(String menuPath, String popupPath, Shortcut[] shortcuts) {
        this(menuPath, popupPath, null, shortcuts);
    }

    public Action(String menuPath, String popupPath, Shortcut shortcut) {
        this(menuPath, popupPath, null, new Shortcut[]{shortcut});
    }

    public Action(String menuPath, String popupPath, String systemActionClass, Shortcut[] shortcuts) {
        this.menuPath = menuPath;
        this.popupPath = popupPath;
        if (systemActionClass == null) {
            this.systemActionClass = null;
        } else {
            try {
                this.systemActionClass = Class.forName(systemActionClass);
            }
            catch (ClassNotFoundException e) {
                this.systemActionClass = null;
            }
        }
        this.shortcuts = shortcuts;
    }

    public Action(String menuPath, String popupPath, String systemActionClass, Shortcut shortcut) {
        this(menuPath, popupPath, systemActionClass, new Shortcut[]{shortcut});
    }

    private void perform(int mode) {
        switch (mode) {
            case 1: {
                this.performPopup();
                break;
            }
            case 0: {
                this.performMenu();
                break;
            }
            case 2: {
                this.performAPI();
                break;
            }
            case 3: {
                this.performShortcut();
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong Action.MODE");
            }
        }
    }

    private void perform(Node node, int mode) {
        switch (mode) {
            case 1: {
                this.performPopup(node);
                break;
            }
            case 0: {
                this.performMenu(node);
                break;
            }
            case 2: {
                this.performAPI(node);
                break;
            }
            case 3: {
                this.performShortcut(node);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong Action.MODE");
            }
        }
    }

    private void perform(Node[] nodes, int mode) {
        switch (mode) {
            case 1: {
                this.performPopup(nodes);
                break;
            }
            case 0: {
                this.performMenu(nodes);
                break;
            }
            case 2: {
                this.performAPI(nodes);
                break;
            }
            case 3: {
                this.performShortcut(nodes);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong Action.MODE");
            }
        }
    }

    private void perform(ComponentOperator component, int mode) {
        switch (mode) {
            case 1: {
                this.performPopup(component);
                break;
            }
            case 0: {
                this.performMenu(component);
                break;
            }
            case 2: {
                this.performAPI(component);
                break;
            }
            case 3: {
                this.performShortcut(component);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong Action.MODE");
            }
        }
    }

    public void perform() {
        int[] modes = sequence[this.getDefaultMode()];
        for (int i = 0; i < modes.length; ++i) {
            try {
                this.perform(modes[i]);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                continue;
            }
        }
    }

    public void perform(Node node) {
        int[] modes = sequence[this.getDefaultMode()];
        for (int i = 0; i < modes.length; ++i) {
            try {
                this.perform(node, modes[i]);
                return;
            }
            catch (UnsupportedOperationException e) {
                continue;
            }
        }
    }

    public void perform(Node[] nodes) {
        int[] modes = sequence[this.getDefaultMode()];
        for (int i = 0; i < modes.length; ++i) {
            try {
                this.perform(nodes, modes[i]);
                return;
            }
            catch (UnsupportedOperationException e) {
                continue;
            }
        }
    }

    public void perform(ComponentOperator component) {
        int[] modes = sequence[this.getDefaultMode()];
        for (int i = 0; i < modes.length; ++i) {
            try {
                this.perform(component, modes[i]);
                return;
            }
            catch (UnsupportedOperationException e) {
                continue;
            }
        }
    }

    public void performMenu() {
        if (this.menuPath == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define menu path");
        }
        new EventTool().waitNoEvent(500L);
        Util.getMainMenu().pushMenu(this.menuPath);
        try {
            Thread.sleep(0L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
    }

    public void performMenu(Node node) {
        this.performMenu(new Node[]{node});
    }

    public void performMenu(Node[] nodes) {
        if (this.menuPath == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define menu path");
        }
        this.testNodes(nodes);
        nodes[0].select();
        for (int i = 1; i < nodes.length; ++i) {
            nodes[i].addSelectionPath();
        }
        try {
            Thread.sleep(300L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
        this.performMenu();
    }

    public void performMenu(ComponentOperator component) {
        component.getFocus();
        try {
            Thread.sleep(300L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
        this.performMenu();
    }

    public void performPopup() {
        throw new UnsupportedOperationException(this.getClass().toString() + " does not implement performPopup()");
    }

    public void performPopup(Node node) {
        this.performPopup(new Node[]{node});
    }

    public void performPopup(Node[] nodes) {
        if (this.popupPath == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define popup path");
        }
        this.testNodes(nodes);
        TreePath[] paths = new TreePath[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            paths[i] = nodes[i].getTreePath();
        }
        Operator.ComponentVisualizer treeVisualizer = nodes[0].tree().getVisualizer();
        Operator.ComponentVisualizer oldVisualizer = null;
        if (treeVisualizer instanceof EmptyVisualizer) {
            oldVisualizer = Operator.getDefaultComponentVisualizer();
            Operator.setDefaultComponentVisualizer((Operator.ComponentVisualizer)treeVisualizer);
        }
        new EventTool().waitNoEvent(500L);
        JPopupMenuOperator popup = new JPopupMenuOperator(nodes[0].tree().callPopupOnPaths(paths));
        if (oldVisualizer != null) {
            Operator.setDefaultComponentVisualizer((Operator.ComponentVisualizer)oldVisualizer);
        }
        popup.pushMenu(this.popupPath, "|", this.getComparator());
        try {
            Thread.sleep(0L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
    }

    public void performPopup(ComponentOperator component) {
        if (this.popupPath == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define popup path");
        }
        new EventTool().waitNoEvent(500L);
        component.clickForPopup();
        new JPopupMenuOperator((Operator)component).pushMenu(this.popupPath, "|", this.getComparator());
        try {
            Thread.sleep(0L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
    }

    public void performAPI() {
        if (this.systemActionClass == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not support API call.");
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    if (SystemAction.class.isAssignableFrom(Action.this.systemActionClass)) {
                        SystemAction.get((Class)Action.this.systemActionClass).actionPerformed(new ActionEvent(new Container(), 0, null));
                    } else {
                        try {
                            ((javax.swing.Action)Action.this.systemActionClass.newInstance()).actionPerformed(null);
                        }
                        catch (Exception e) {
                            throw new JemmyException("Exception when trying to create instance of action \"" + Action.this.systemActionClass.getName() + "\".", (Throwable)e);
                        }
                    }
                }
            });
            Thread.sleep(0L);
        }
        catch (Exception e) {
            throw new JemmyException("Interrupted", (Throwable)e);
        }
    }

    public void performAPI(Node node) {
        this.performAPI(new Node[]{node});
    }

    public void performAPI(Node[] nodes) {
        if (this.systemActionClass == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define SystemAction");
        }
        this.testNodes(nodes);
        nodes[0].select();
        for (int i = 1; i < nodes.length; ++i) {
            nodes[i].addSelectionPath();
        }
        try {
            Thread.sleep(300L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
        this.performAPI();
    }

    public void performAPI(ComponentOperator component) {
        component.getFocus();
        try {
            Thread.sleep(300L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
        this.performAPI();
    }

    public void performShortcut() {
        if (this.shortcuts == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define shortcut");
        }
        for (int i = 0; i < this.shortcuts.length; ++i) {
            new KeyRobotDriver(null).pushKey(null, this.shortcuts[i].getKeyCode(), this.shortcuts[i].getKeyModifiers(), JemmyProperties.getCurrentTimeouts().create("Timeouts.DeltaTimeout"));
            JemmyProperties.getProperties().getTimeouts().sleep("Action.WaitAfterShortcutTimeout");
        }
        try {
            Thread.sleep(0L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
    }

    public void performShortcut(Node node) {
        this.performShortcut(new Node[]{node});
    }

    public void performShortcut(Node[] nodes) {
        if (this.shortcuts == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define shortcut");
        }
        this.testNodes(nodes);
        nodes[0].select();
        for (int i = 1; i < nodes.length; ++i) {
            nodes[i].addSelectionPath();
        }
        try {
            Thread.sleep(300L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
        this.performShortcut();
    }

    public void performShortcut(ComponentOperator component) {
        component.getFocus();
        try {
            Thread.sleep(300L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
        this.performShortcut();
    }

    protected void testNodes(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            throw new IllegalArgumentException("argument nodes is null or empty");
        }
        Class<?> myClass = this.getClass();
        Component nodesTree = nodes[0].tree().getSource();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] == null) {
                throw new IllegalArgumentException("argument nodes contains null value");
            }
            if (nodesTree.equals(nodes[i].tree().getSource())) continue;
            throw new IllegalArgumentException(nodes[i].toString() + " is from different tree");
        }
    }

    public int getDefaultMode() {
        int mode = (Integer)JemmyProperties.getCurrentProperty((String)"Action.DefaultMode");
        if (mode < 0 || mode > 3) {
            return 1;
        }
        return mode;
    }

    public int setDefaultMode(int mode) {
        int oldMode = (Integer)JemmyProperties.getCurrentProperty((String)"Action.DefaultMode");
        if (mode < 0 || mode > 3) {
            mode = 1;
        }
        JemmyProperties.setCurrentProperty((String)"Action.DefaultMode", (Object)new Integer(mode));
        return oldMode;
    }

    public void setComparator(Operator.StringComparator comparator) {
        this.comparator = comparator;
    }

    public Operator.StringComparator getComparator() {
        if (this.comparator == null) {
            this.comparator = defaultComparator;
        }
        return this.comparator;
    }

    public String getPopupPath() {
        return this.popupPath;
    }

    public String getMenuPath() {
        return this.menuPath;
    }

    public Class getSystemActionClass() {
        return this.systemActionClass;
    }

    public Shortcut[] getShortcuts() {
        return this.shortcuts;
    }

    public boolean isEnabled() {
        if (this.systemActionClass != null) {
            return SystemAction.get((Class)this.systemActionClass).isEnabled();
        }
        if (this.menuPath != null) {
            return Util.getMainMenu().showMenuItem(this.menuPath, "|", this.getComparator()).isEnabled();
        }
        throw new UnsupportedOperationException("Cannot detect if " + this.getClass().getName() + " is enabled.");
    }

    public boolean isEnabled(Node[] nodes) {
        this.testNodes(nodes);
        if (this.systemActionClass != null) {
            nodes[0].select();
            for (int i = 1; i < nodes.length; ++i) {
                nodes[i].addSelectionPath();
            }
            try {
                Thread.sleep(300L);
            }
            catch (Exception e) {
                throw new JemmyException("Sleeping interrupted", (Throwable)e);
            }
            return SystemAction.get((Class)this.systemActionClass).isEnabled();
        }
        if (this.popupPath != null) {
            TreePath[] paths = new TreePath[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                paths[i] = nodes[i].getTreePath();
            }
            Operator.ComponentVisualizer treeVisualizer = nodes[0].tree().getVisualizer();
            Operator.ComponentVisualizer oldVisualizer = null;
            if (treeVisualizer instanceof EmptyVisualizer) {
                oldVisualizer = Operator.getDefaultComponentVisualizer();
                Operator.setDefaultComponentVisualizer((Operator.ComponentVisualizer)treeVisualizer);
            }
            new EventTool().waitNoEvent(500L);
            JPopupMenuOperator popup = new JPopupMenuOperator(nodes[0].tree().callPopupOnPaths(paths));
            if (oldVisualizer != null) {
                Operator.setDefaultComponentVisualizer((Operator.ComponentVisualizer)oldVisualizer);
            }
            return popup.showMenuItem(this.popupPath, "|", this.getComparator()).isEnabled();
        }
        throw new UnsupportedOperationException("Cannot detect if " + this.getClass().getName() + " is enabled.");
    }

    public boolean isEnabled(Node node) {
        return this.isEnabled(new Node[]{node});
    }

    public boolean isEnabled(ComponentOperator componentOperator) {
        componentOperator.makeComponentVisible();
        componentOperator.getFocus();
        if (this.systemActionClass != null) {
            return SystemAction.get((Class)this.systemActionClass).isEnabled();
        }
        if (this.popupPath != null) {
            new EventTool().waitNoEvent(500L);
            componentOperator.clickForPopup();
            return new JPopupMenuOperator((Operator)componentOperator).showMenuItem(this.popupPath, "|", this.getComparator()).isEnabled();
        }
        if (this.menuPath != null) {
            return Util.getMainMenu().showMenuItem(this.menuPath, "|", this.getComparator()).isEnabled();
        }
        throw new UnsupportedOperationException("Cannot detect if " + this.getClass().getName() + " is enabled.");
    }

    static {
        JellyVersion.checkJemmyVersion();
        if (JemmyProperties.getCurrentProperty((String)"Action.DefaultMode") == null) {
            JemmyProperties.setCurrentProperty((String)"Action.DefaultMode", (Object)new Integer(1));
        }
        Timeouts.initDefault((String)"Action.WaitAfterShortcutTimeout", (long)0L);
        boolean compareExactly = !Operator.getDefaultStringComparator().equals("abc", "a");
        defaultComparator = new Operator.DefaultStringComparator(compareExactly, true);
    }

    public static class Shortcut {
        protected int keyCode;
        protected int keyModifiers;

        public Shortcut(int keyCode) {
            this(keyCode, 0);
        }

        public Shortcut(int keyCode, int keyModifiers) {
            this.keyCode = keyCode;
            this.keyModifiers = keyModifiers;
        }

        public int getKeyCode() {
            return this.keyCode;
        }

        public int getKeyModifiers() {
            return this.keyModifiers;
        }

        public String toString() {
            String s = KeyEvent.getKeyModifiersText(this.getKeyModifiers());
            return s + (s.length() > 0 ? "+" : "") + KeyEvent.getKeyText(this.getKeyCode());
        }
    }
}

