/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.properties.editors;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.table.TableModel;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.NbDialogOperator;
import org.netbeans.modules.visualweb.gravy.OptionsOperator;
import org.netbeans.modules.visualweb.gravy.properties.PropertySheetOperator;
import org.netbeans.modules.visualweb.gravy.properties.PropertySheetTabOperator;
import org.netbeans.modules.visualweb.gravy.properties.TextFieldProperty;
import org.netbeans.modules.visualweb.gravy.properties.editors.EnterAbbreviation;

public class AbbreviationsEditorOperator
extends NbDialogOperator {
    private JTableOperator _tabAbbreviations;
    private JButtonOperator _btMetalScrollButton;
    private JButtonOperator _btMetalScrollButton2;
    private JButtonOperator _btAdd;
    private JButtonOperator _btEdit;
    private JButtonOperator _btRemove;
    private JButtonOperator _btOK;
    private JButtonOperator _btCancel;
    private JButtonOperator _btHelp;

    public AbbreviationsEditorOperator() {
        super(ResourceBundle.getBundle("org/netbeans/modules/editor/options/Bundle").getString("PROP_Abbreviations"));
    }

    public AbbreviationsEditorOperator(JDialogOperator wrapper) {
        super((JDialog)wrapper.getSource());
    }

    public JTableOperator tabAbbreviations() {
        if (this._tabAbbreviations == null) {
            this._tabAbbreviations = new JTableOperator((ContainerOperator)this);
        }
        return this._tabAbbreviations;
    }

    public JButtonOperator btMetalScrollButton() {
        if (this._btMetalScrollButton == null) {
            this._btMetalScrollButton = new JButtonOperator((ContainerOperator)this, "");
        }
        return this._btMetalScrollButton;
    }

    public JButtonOperator btMetalScrollButton2() {
        if (this._btMetalScrollButton2 == null) {
            this._btMetalScrollButton2 = new JButtonOperator((ContainerOperator)this, "", 1);
        }
        return this._btMetalScrollButton2;
    }

    public JButtonOperator btAdd() {
        if (this._btAdd == null) {
            this._btAdd = new JButtonOperator((ContainerOperator)this, ResourceBundle.getBundle("org.netbeans.modules.editor.options.Bundle").getString("KBEP_Add"));
        }
        return this._btAdd;
    }

    public JButtonOperator btEdit() {
        if (this._btEdit == null) {
            this._btEdit = new JButtonOperator((ContainerOperator)this, ResourceBundle.getBundle("org/netbeans/modules/editor/options/Bundle").getString("AEP_Edit"));
        }
        return this._btEdit;
    }

    public JButtonOperator btRemove() {
        if (this._btRemove == null) {
            this._btRemove = new JButtonOperator((ContainerOperator)this, ResourceBundle.getBundle("org/netbeans/modules/editor/options/Bundle").getString("Remove"));
        }
        return this._btRemove;
    }

    public JButtonOperator btOK() {
        if (this._btOK == null) {
            this._btOK = new JButtonOperator((ContainerOperator)this, ResourceBundle.getBundle("org/netbeans/modules/editor/options/Bundle").getString("KBEP_OK_LABEL"));
        }
        return this._btOK;
    }

    public JButtonOperator btCancel() {
        if (this._btCancel == null) {
            this._btCancel = new JButtonOperator((ContainerOperator)this, ResourceBundle.getBundle("org.openide.explorer.propertysheet.Bundle").getString("CTL_Cancel"));
        }
        return this._btCancel;
    }

    public JButtonOperator btHelp() {
        if (this._btHelp == null) {
            this._btHelp = new JButtonOperator((ContainerOperator)this, ResourceBundle.getBundle("org.openide.explorer.propertysheet.Bundle").getString("CTL_Help"));
        }
        return this._btHelp;
    }

    public void metalScrollButton() {
        this.btMetalScrollButton().push();
    }

    public void metalScrollButton2() {
        this.btMetalScrollButton2().push();
    }

    public void add() {
        this.btAdd().push();
    }

    public void edit() {
        this.btEdit().push();
    }

    public void remove() {
        this.btRemove().push();
    }

    public void oK() {
        this.btOK().push();
    }

    public void cancel() {
        this.btCancel().push();
    }

    public void help() {
        this.btHelp().push();
    }

    public void verify() {
        this.tabAbbreviations();
        this.btMetalScrollButton();
        this.btMetalScrollButton2();
        this.btAdd();
        this.btEdit();
        this.btRemove();
        this.btOK();
        this.btCancel();
        this.btHelp();
    }

    public void addAbbreviation(String abbreviation, String expansion) {
        this.btAdd().pushNoBlock();
        EnterAbbreviation enter = new EnterAbbreviation();
        enter.fillAbbreviation(abbreviation, expansion);
        enter.oK();
    }

    public boolean editAbbreviation(String abbreviationName, String newAbbreviationName, String newExpansion) {
        int row = this.tabAbbreviations().findCellRow(abbreviationName);
        if (row == -1) {
            return false;
        }
        this.tabAbbreviations().selectCell(row, 0);
        this.btEdit().pushNoBlock();
        EnterAbbreviation enter = new EnterAbbreviation();
        enter.fillAbbreviation(newAbbreviationName, newExpansion);
        enter.oK();
        return true;
    }

    public void addOrEditAbbreviation(String abbreviationName, String newAbbreviationName, String newExpansion) {
        if (!this.editAbbreviation(abbreviationName, newAbbreviationName, newExpansion)) {
            this.addAbbreviation(newAbbreviationName, newExpansion);
        }
    }

    public boolean removeAbbreviation(String abbreviation) {
        int row = this.tabAbbreviations().findCellRow(abbreviation, (Operator.StringComparator)new Operator.DefaultStringComparator(true, true));
        if (row == -1) {
            return false;
        }
        this.tabAbbreviations().selectCell(row, 0);
        this.btRemove().pushNoBlock();
        return true;
    }

    public Map listAbbreviations() {
        TableModel model = this.tabAbbreviations().getModel();
        int rowCount = model.getRowCount();
        HashMap<String, String> result = new HashMap<String, String>();
        for (int cntr = 0; cntr < rowCount; ++cntr) {
            result.put((String)model.getValueAt(cntr, 0), (String)model.getValueAt(cntr, 1));
        }
        return result;
    }

    public static AbbreviationsEditorOperator invoke(String editorName) {
        OptionsOperator options = OptionsOperator.invoke();
        new EventTool().waitNoEvent(500L);
        options.advanced();
        new EventTool().waitNoEvent(500L);
        options.selectOption(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("UI/Services/Editing") + "|" + ResourceBundle.getBundle("org/netbeans/modules/editor/options/Bundle").getString("OPTIONS_all") + "|" + editorName);
        new EventTool().waitNoEvent(500L);
        PropertySheetOperator property = new PropertySheetOperator((ContainerOperator)options);
        PropertySheetTabOperator psto = new PropertySheetTabOperator((ContainerOperator)property);
        new TextFieldProperty((ContainerOperator)psto, ResourceBundle.getBundle("org/netbeans/modules/editor/options/Bundle").getString("PROP_Abbreviations")).openEditor();
        AbbreviationsEditorOperator abbs = new AbbreviationsEditorOperator();
        options.close();
        return abbs;
    }

    public static void addAbbreviation(String editorName, String abbreviation, String expansion) {
        AbbreviationsEditorOperator instance = AbbreviationsEditorOperator.invoke(editorName);
        instance.addAbbreviation(abbreviation, expansion);
        instance.oK();
    }

    public static void addOrEditAbbreviation(String editorName, String abbreviationName, String newAbbreviationName, String newExpansion) {
        AbbreviationsEditorOperator instance = AbbreviationsEditorOperator.invoke(editorName);
        instance.addOrEditAbbreviation(abbreviationName, newAbbreviationName, newExpansion);
        instance.oK();
    }

    public static boolean removeAbbreviation(String editorName, String abbreviation) {
        AbbreviationsEditorOperator instance = AbbreviationsEditorOperator.invoke(editorName);
        boolean result = instance.removeAbbreviation(abbreviation);
        instance.oK();
        return result;
    }

    public static boolean editAbbreviation(String editorName, String abbreviationName, String newAbbreviationName, String newExpansion) {
        AbbreviationsEditorOperator instance = AbbreviationsEditorOperator.invoke(editorName);
        boolean result = instance.editAbbreviation(abbreviationName, newAbbreviationName, newExpansion);
        instance.oK();
        return result;
    }

    public static Map listAbbreviations(String editorName) {
        AbbreviationsEditorOperator instance = AbbreviationsEditorOperator.invoke(editorName);
        Map result = instance.listAbbreviations();
        instance.oK();
        return result;
    }

    public static void main(String[] args) {
        AbbreviationsEditorOperator.addAbbreviation("Java Editor", "aaa", "All abbrev");
    }
}

