/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.engine;

import com.sun.etl.engine.utils.MessageManager;
import com.sun.sql.framework.utils.Logger;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ETLEngineContext {
    public static final String KEY_ERROR_MESSAGE = "errorMessage";
    public static final String KEY_RUNTIME_OUTPUTS = "runtimeOutputs";
    private List connCommitList = null;
    private Set connectionsToClose = null;
    private HashMap context = null;
    private final String logCategory = ETLEngineContext.class.getName();
    private CollabStatistics statistics;
    private List throwableList = null;

    public ETLEngineContext() {
        this.context = new HashMap();
        this.statistics = new CollabStatistics();
        this.connCommitList = new ArrayList();
        this.connectionsToClose = new HashSet(5);
        this.throwableList = new ArrayList();
    }

    public void addToThrowableList(Throwable t) {
        this.throwableList.add(t);
    }

    public void clearThrowableList() {
        this.throwableList.clear();
    }

    public synchronized void closeAndReleaseLater(Connection aConn) {
        this.connectionsToClose.add(aConn);
    }

    public void commitLater(Connection aConn) {
        this.connCommitList.add(aConn);
    }

    public synchronized void flush() {
        this.context.clear();
    }

    public String[] getAllParams() {
        Set keyset = this.context.keySet();
        return (String[])keyset.toArray();
    }

    public List getConnectionListToCommit() {
        ArrayList theList = new ArrayList(this.connCommitList);
        this.connCommitList.clear();
        return theList;
    }

    public synchronized Collection getConnectionsToClose() {
        ArrayList theList = new ArrayList(this.connectionsToClose);
        this.connectionsToClose.clear();
        return theList;
    }

    public CollabStatistics getStatistics() {
        return this.statistics;
    }

    public List getThrowableList() {
        return new ArrayList(this.throwableList);
    }

    public Object getValue(String key) {
        return this.context.get(key);
    }

    public synchronized void putValue(String key, Object value) {
        this.context.put(key, value);
    }

    public synchronized void setContext(HashMap theState) {
        if (this.context.isEmpty()) {
            this.context.putAll(theState);
        } else {
            MessageManager messageManager = MessageManager.getManager(ETLEngineContext.class);
            String err = messageManager.getString("ERR_ENGINE_CONTEXT");
            Logger.print(40000, this.logCategory, err);
        }
    }

    public static class CollabStatistics {
        private Timestamp collabFinish;
        private Timestamp collabStart;
        private Map tableStats = new HashMap(3);

        public void collabStarted() {
            if (this.collabStart == null) {
                this.collabStart = new Timestamp(System.currentTimeMillis());
            }
        }

        public void collabStopped() {
            if (this.collabFinish == null) {
                this.collabFinish = new Timestamp(System.currentTimeMillis());
            }
        }

        public Timestamp getCollabFinishTime() {
            return this.collabFinish != null ? this.collabFinish : new Timestamp(Long.MIN_VALUE);
        }

        public Timestamp getCollabStartTime() {
            return this.collabStart != null ? this.collabStart : new Timestamp(Long.MIN_VALUE);
        }

        public Collection getKnownTableNames() {
            return new HashSet(this.tableStats.keySet());
        }

        public long getRowsExtractedCount(String tableName) {
            TableData stats = this.getOrCreateTableStatistics(tableName);
            return stats.getRowsExtracted();
        }

        public long getRowsInsertedCount(String tableName) {
            TableData stats = this.getOrCreateTableStatistics(tableName);
            return stats.getRowsInserted();
        }

        public long getRowsRejectedCount(String tableName) {
            TableData stats = this.getOrCreateTableStatistics(tableName);
            return stats.getRowsRejected();
        }

        public int getTableExecutionId(String tableName) {
            TableData stats = this.getOrCreateTableStatistics(tableName);
            return stats.getExecutionId();
        }

        public Timestamp getTableFinishTime(String tableName) {
            TableData stats = this.getOrCreateTableStatistics(tableName);
            return stats.getTimeFinished();
        }

        public Timestamp getTableStartTime(String tableName) {
            TableData stats = this.getOrCreateTableStatistics(tableName);
            return stats.getTimeStarted();
        }

        public void setRowsExtractedCount(String tableName, long newCt) {
            TableData stats = this.getOrCreateTableStatistics(tableName);
            stats.setRowsExtracted(newCt);
        }

        public void setRowsInsertedCount(String tableName, long newCt) {
            TableData stats = this.getOrCreateTableStatistics(tableName);
            stats.setRowsInserted(newCt);
        }

        public void setRowsRejectedCount(String tableName, long newCt) {
            TableData stats = this.getOrCreateTableStatistics(tableName);
            stats.setRowsRejected(newCt);
        }

        public void setTableExecutionId(String tableName, int newId) {
            TableData stats = this.getOrCreateTableStatistics(tableName);
            stats.setExecutionId(newId);
        }

        public void setTableFinishTime(String tableName, Timestamp newTime) {
            TableData stats = this.getOrCreateTableStatistics(tableName);
            stats.setTimeFinished(newTime);
        }

        public void setTableStartTime(String tableName, Timestamp newTime) {
            TableData stats = this.getOrCreateTableStatistics(tableName);
            stats.setTimeStarted(newTime);
        }

        private TableData getOrCreateTableStatistics(String tableName) {
            TableData stats = (TableData)this.tableStats.get(tableName);
            if (stats == null) {
                stats = new TableData(tableName);
                this.tableStats.put(tableName, stats);
            }
            return stats;
        }

        class TableData {
            private int executionId;
            private long rowsExtracted;
            private long rowsInserted;
            private long rowsRejected;
            private String tableName;
            private Timestamp timeFinished;
            private Timestamp timeStarted;

            public TableData(String name) {
                this.tableName = name;
            }

            public int getExecutionId() {
                return this.executionId;
            }

            public long getRowsExtracted() {
                return this.rowsExtracted;
            }

            public long getRowsInserted() {
                return this.rowsInserted;
            }

            public long getRowsRejected() {
                return this.rowsRejected;
            }

            public String getTableName() {
                return this.tableName;
            }

            public Timestamp getTimeFinished() {
                return this.timeFinished;
            }

            public Timestamp getTimeStarted() {
                return this.timeStarted;
            }

            public void setExecutionId(int newId) {
                this.executionId = newId;
            }

            public void setRowsExtracted(long newCt) {
                this.rowsExtracted = newCt;
            }

            public void setRowsInserted(long newCt) {
                this.rowsInserted = newCt;
            }

            public void setRowsRejected(long newCt) {
                this.rowsRejected = newCt;
            }

            public void setTimeFinished(Timestamp newTime) {
                this.timeFinished = newTime;
            }

            public void setTimeStarted(Timestamp newTime) {
                this.timeStarted = newTime;
            }
        }
    }
}

