/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sql.framework.jdbc;

import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.utils.ScEncrypt;
import com.sun.sql.framework.utils.StringUtil;
import com.sun.sql.framework.utils.XmlUtil;
import java.util.Properties;
import org.w3c.dom.Element;

public class DBConnectionParameters
implements Cloneable,
Comparable {
    public static final String CONNECTION_DEFINITION_TAG = "connectiondef";
    public static final String CONNECTION_DESC_TAG = "description";
    public static final String CONNECTION_NAME_TAG = "name";
    public static final String DB_VENDOR_ATTR = "dbName";
    public static final String DRIVER_NAME_ATTR = "driverName";
    public static final String DS_JNDI_PATH_ATTR = "dsJndiPath";
    public static final String OTD_PATH_NAME_ATTR = "otdPathName";
    public static final String PASSWORD_ATTR = "password";
    public static final String URL_ATTR = "dbUrl";
    public static final String USER_NAME_ATTR = "userName";
    private static final String LOG_CATEGORY = DBConnectionParameters.class.getName();
    protected String dbType = "";
    protected volatile String description;
    protected String driverClass = "";
    protected String dsJndiPath = "";
    protected String jdbcUrl = "";
    protected volatile String name;
    protected String otdPathName = "";
    protected String password = "";
    protected String userName = "";

    public DBConnectionParameters() {
    }

    public DBConnectionParameters(Element theElement) throws BaseException {
        this.parseXML(theElement);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public int compareTo(Object refObj) {
        DBConnectionParameters defn = (DBConnectionParameters)refObj;
        return this.name.compareTo(defn.name);
    }

    public boolean equals(Object refObj) {
        boolean result;
        if (!(refObj instanceof DBConnectionParameters)) {
            return false;
        }
        if (this == refObj) {
            return true;
        }
        DBConnectionParameters defn = (DBConnectionParameters)refObj;
        boolean bl = this.name != null ? this.name.equals(defn.name) : (result = defn.name == null);
        result &= this.dbType != null ? this.dbType.equals(defn.dbType) : defn.dbType == null;
        result &= this.driverClass != null ? this.driverClass.equals(defn.driverClass) : defn.driverClass == null;
        result &= this.jdbcUrl != null ? this.jdbcUrl.equals(defn.jdbcUrl) : defn.jdbcUrl == null;
        result &= this.userName != null ? this.userName.equals(defn.userName) : defn.userName == null;
        result &= this.password != null ? this.password.equals(defn.password) : defn.password == null;
        result &= this.otdPathName != null ? this.otdPathName.equals(defn.otdPathName) : defn.otdPathName == null;
        return result &= this.dsJndiPath != null ? this.dsJndiPath.equals(defn.dsJndiPath) : defn.dsJndiPath == null;
    }

    public Properties getConnectionProperties() {
        Properties props = new Properties();
        props.put("dbType", this.getDBType());
        props.put("DRIVER", this.getDriverClass());
        props.put("url", this.getConnectionURL());
        props.put("username", this.getUserName());
        props.put(PASSWORD_ATTR, this.getPassword());
        props.put(OTD_PATH_NAME_ATTR, this.getOTDPathName());
        props.put(DS_JNDI_PATH_ATTR, this.getJNDIPath());
        return props;
    }

    public String getConnectionURL() {
        return this.jdbcUrl;
    }

    public String getDBType() {
        return this.dbType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getJNDIPath() {
        return this.dsJndiPath;
    }

    public synchronized String getName() {
        return this.name;
    }

    public String getOTDPathName() {
        return this.otdPathName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.userName;
    }

    public int hashCode() {
        int myHash = this.name != null ? this.name.hashCode() : 0;
        myHash += this.dbType != null ? this.dbType.hashCode() : 0;
        myHash += this.driverClass != null ? this.driverClass.hashCode() : 0;
        myHash += this.jdbcUrl != null ? this.jdbcUrl.hashCode() : 0;
        myHash += this.userName != null ? this.userName.hashCode() : 0;
        myHash += this.password != null ? this.password.hashCode() : 0;
        myHash += this.otdPathName != null ? this.otdPathName.hashCode() : 0;
        return myHash += this.dsJndiPath != null ? this.dsJndiPath.hashCode() : 0;
    }

    public void parseXML(Element xmlElement) throws BaseException {
        try {
            this.setName(xmlElement.getAttribute(CONNECTION_NAME_TAG));
            this.setDescription(xmlElement.getAttribute(CONNECTION_DESC_TAG));
            this.setConnectionURL(XmlUtil.getAttributeFrom(xmlElement, URL_ATTR, false));
            this.setDBType(XmlUtil.getAttributeFrom(xmlElement, DB_VENDOR_ATTR, false));
            this.setUserName(XmlUtil.getAttributeFrom(xmlElement, USER_NAME_ATTR, false));
            String passwd = XmlUtil.getAttributeFrom(xmlElement, PASSWORD_ATTR, false);
            if (!StringUtil.isNullString(passwd)) {
                String newPass = ScEncrypt.decrypt(this.getUserName(), passwd);
                this.setPassword(newPass);
            }
            this.setDriverClass(XmlUtil.getAttributeFrom(xmlElement, DRIVER_NAME_ATTR, false));
            this.setOTDPathName(XmlUtil.getAttributeFrom(xmlElement, OTD_PATH_NAME_ATTR, false));
            this.setJNDIPath(XmlUtil.getAttributeFrom(xmlElement, DS_JNDI_PATH_ATTR, false));
        }
        catch (Exception ex) {
            throw new BaseException(LOG_CATEGORY + ": Could not parse Connection Definition ", ex);
        }
    }

    public void setConnectionURL(String newUrl) {
        this.jdbcUrl = newUrl;
    }

    public void setDBType(String newDBType) {
        this.dbType = newDBType != null ? newDBType : "";
    }

    public void setDescription(String newDesc) {
        this.description = newDesc != null && newDesc.trim().length() != 0 ? newDesc.trim() : "";
    }

    public void setDriverClass(String newDriverClass) {
        this.driverClass = newDriverClass;
    }

    public void setJNDIPath(String dsJndiPath) {
        this.dsJndiPath = dsJndiPath;
    }

    public void setName(String newName) {
        this.name = newName != null && newName.trim().length() != 0 ? newName.trim() : "";
    }

    public void setOTDPathName(String newPathName) {
        this.otdPathName = newPathName;
    }

    public void setPassword(String newPassword) {
        this.password = newPassword;
    }

    public void setUserName(String newUserName) {
        this.userName = newUserName;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(1000);
        String nl = ", ";
        buf.append("{ name: \"").append(this.name).append("\"").append(", ");
        buf.append("DBType: \"").append(this.dbType).append("\"").append(", ");
        buf.append("driverClass: \"").append(this.driverClass).append("\"").append(", ");
        buf.append("jdbcUrl: \"").append(this.jdbcUrl).append("\"").append(", ");
        buf.append("userName: \"").append(this.userName).append("\"").append(", ");
        buf.append("otdPathName: \"").append(this.otdPathName).append("\"").append(", ");
        buf.append("dsJndiPath: \"").append(this.dsJndiPath).append("\"");
        buf.append(" }");
        return buf.toString();
    }

    public synchronized String toXMLString() {
        return this.toXMLString("\t");
    }

    public synchronized String toXMLString(String prefix) {
        StringBuffer xml = new StringBuffer(1000);
        if (prefix == null) {
            prefix = "";
        }
        xml.append(prefix);
        xml.append("<").append(CONNECTION_DEFINITION_TAG);
        if (!StringUtil.isNullString(this.name)) {
            xml.append(" ").append(CONNECTION_NAME_TAG).append("=\"").append(this.name.trim()).append("\"");
        }
        if (!StringUtil.isNullString(this.description)) {
            xml.append(" ").append(CONNECTION_DESC_TAG).append("=\"").append(this.description.trim()).append("\"");
        }
        if (!StringUtil.isNullString(this.driverClass)) {
            xml.append(" ").append(DRIVER_NAME_ATTR).append("=\"").append(this.driverClass.trim()).append("\"");
        }
        if (!StringUtil.isNullString(this.dbType)) {
            xml.append(" ").append(DB_VENDOR_ATTR).append("=\"").append(this.dbType.trim()).append("\"");
        }
        if (!StringUtil.isNullString(this.jdbcUrl)) {
            xml.append(" ").append(URL_ATTR).append("=\"").append(this.jdbcUrl.trim()).append("\"");
        }
        if (!StringUtil.isNullString(this.userName)) {
            xml.append(" ").append(USER_NAME_ATTR).append("=\"").append(this.userName.trim()).append("\"");
        }
        if (!StringUtil.isNullString(this.password) && !StringUtil.isNullString(this.userName)) {
            String newPass = ScEncrypt.encrypt(this.userName.trim(), this.password.trim());
            xml.append(" ").append(PASSWORD_ATTR).append("=\"").append(newPass).append("\"");
        }
        if (!StringUtil.isNullString(this.otdPathName)) {
            xml.append(" ").append(OTD_PATH_NAME_ATTR).append("=\"").append(this.otdPathName).append("\"");
        }
        if (!StringUtil.isNullString(this.dsJndiPath)) {
            xml.append(" ").append(DS_JNDI_PATH_ATTR).append("=\"").append(this.dsJndiPath).append("\"");
        }
        xml.append(">\n");
        xml.append(prefix).append("</").append(CONNECTION_DEFINITION_TAG).append(">").append("\n");
        return xml.toString();
    }
}

