/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.rubyforge.debugcommons.ClassicDebuggerCommandFactory;
import org.rubyforge.debugcommons.ICommandFactory;
import org.rubyforge.debugcommons.ReadersSupport;
import org.rubyforge.debugcommons.RubyDebugCommandFactory;
import org.rubyforge.debugcommons.RubyDebugEvent;
import org.rubyforge.debugcommons.RubyDebugEventListener;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.IRubyBreakpoint;
import org.rubyforge.debugcommons.model.RubyDebugTarget;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyFrameInfo;
import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.RubyThreadInfo;
import org.rubyforge.debugcommons.model.RubyVariable;
import org.rubyforge.debugcommons.model.RubyVariableInfo;
import org.rubyforge.debugcommons.model.SuspensionPoint;

public final class RubyDebuggerProxy {
    public static final DebuggerType CLASSIC_DEBUGGER = DebuggerType.CLASSIC_DEBUGGER;
    public static final DebuggerType RUBY_DEBUG = DebuggerType.RUBY_DEBUG;
    public static final List<RubyDebuggerProxy> PROXIES = new CopyOnWriteArrayList<RubyDebuggerProxy>();
    private final List<RubyDebugEventListener> listeners;
    private final Map<Integer, IRubyBreakpoint> breakpointsIDs;
    private final int timeout;
    private final DebuggerType debuggerType;
    private RubyDebugTarget debugTarged;
    private Socket commandSocket;
    private boolean connected;
    private boolean finished;
    private PrintWriter commandWriter;
    private RubyLoop rubyLoop;
    private ICommandFactory commandFactory;
    private ReadersSupport readersSupport;

    public RubyDebuggerProxy(DebuggerType debuggerType) {
        this(debuggerType, 10);
    }

    public RubyDebuggerProxy(DebuggerType debuggerType, int timeout) {
        this.debuggerType = debuggerType;
        this.listeners = new CopyOnWriteArrayList<RubyDebugEventListener>();
        this.breakpointsIDs = new HashMap<Integer, IRubyBreakpoint>();
        this.timeout = timeout;
    }

    public void connect(RubyDebugTarget debugTarged) throws IOException, RubyDebuggerException {
        this.debugTarged = debugTarged;
        this.readersSupport = new ReadersSupport(this.timeout);
    }

    public RubyDebugTarget getDebugTarged() {
        return this.debugTarged;
    }

    ReadersSupport getReadersSupport() throws RubyDebuggerException {
        return this.readersSupport;
    }

    public void startDebugging(IRubyBreakpoint[] initialBreakpoints) throws RubyDebuggerException {
        try {
            switch (this.debuggerType) {
                case CLASSIC_DEBUGGER: {
                    this.startClassicDebugger(initialBreakpoints);
                    break;
                }
                case RUBY_DEBUG: {
                    this.startRubyDebug(initialBreakpoints);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled debugger type: " + (Object)((Object)this.debuggerType));
                }
            }
        }
        catch (RubyDebuggerException e) {
            PROXIES.remove(this);
            throw e;
        }
        this.startRubyLoop();
    }

    public synchronized boolean checkConnection() {
        return !this.finished && this.connected;
    }

    private void startClassicDebugger(IRubyBreakpoint[] initialBreakpoints) throws RubyDebuggerException {
        try {
            this.commandFactory = new ClassicDebuggerCommandFactory();
            this.readersSupport.startCommandLoop(this.getCommandSocket().getInputStream());
            this.setBreakpoints(initialBreakpoints);
            this.sendCommand("cont");
        }
        catch (IOException ex) {
            throw new RubyDebuggerException(ex);
        }
    }

    private void startRubyDebug(IRubyBreakpoint[] initialBreakpoints) throws RubyDebuggerException {
        try {
            this.commandFactory = new RubyDebugCommandFactory();
            this.readersSupport.startCommandLoop(this.getCommandSocket().getInputStream());
            this.setBreakpoints(initialBreakpoints);
            this.sendCommand("start");
        }
        catch (IOException ex) {
            throw new RubyDebuggerException(ex);
        }
    }

    public void fireDebugEvent(RubyDebugEvent e) {
        for (RubyDebugEventListener listener : this.listeners) {
            listener.onDebugEvent(e);
        }
    }

    public void addRubyDebugEventListener(RubyDebugEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeRubyDebugEventListener(RubyDebugEventListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized PrintWriter getCommandWriter() throws RubyDebuggerException {
        if (this.commandWriter == null) {
            try {
                this.commandWriter = new PrintWriter(this.getCommandSocket().getOutputStream(), true);
                this.connected = true;
            }
            catch (IOException e) {
                throw new RubyDebuggerException(e);
            }
        }
        return this.commandWriter;
    }

    protected void setBreakpoints(IRubyBreakpoint[] breakpoints) throws RubyDebuggerException {
        for (IRubyBreakpoint breakpoint : breakpoints) {
            this.addBreakpoint(breakpoint);
        }
    }

    public void addBreakpoint(IRubyBreakpoint breakpoint) throws RubyDebuggerException {
        if (breakpoint.isEnabled()) {
            String command = this.commandFactory.createAddBreakpoint(breakpoint.getFilePath(), breakpoint.getLineNumber());
            this.sendCommand(command);
            Integer id = this.getReadersSupport().readAddedBreakpointNo();
            this.breakpointsIDs.put(id, breakpoint);
        }
    }

    public void removeBreakpoint(IRubyBreakpoint breakpoint) {
        this.removeBreakpoint(breakpoint, false);
    }

    public void removeBreakpoint(IRubyBreakpoint breakpoint, boolean silent) {
        Integer id = this.findBreakpointId(breakpoint);
        if (id != null) {
            String command = this.commandFactory.createRemoveBreakpoint(id);
            try {
                this.sendCommand(command);
                this.getReadersSupport().waitForRemovedBreakpoint(id);
                this.breakpointsIDs.remove(id);
            }
            catch (RubyDebuggerException e) {
                Util.severe("Exception during removing breakpoint.", e);
            }
        } else if (!silent) {
            Util.fine("Breakpoint [" + breakpoint + "] cannot be removed since " + "its ID cannot be found. Might have been alread removed.");
        }
    }

    public void updateBreakpoint(IRubyBreakpoint breakpoint) throws RubyDebuggerException {
        this.removeBreakpoint(breakpoint, true);
        this.addBreakpoint(breakpoint);
    }

    private Integer findBreakpointId(IRubyBreakpoint wantedBP) {
        for (Map.Entry<Integer, IRubyBreakpoint> breakpointID : this.breakpointsIDs.entrySet()) {
            IRubyBreakpoint bp = breakpointID.getValue();
            int id = breakpointID.getKey();
            if (!wantedBP.getFilePath().equals(bp.getFilePath()) || wantedBP.getLineNumber() != bp.getLineNumber()) continue;
            return id;
        }
        return null;
    }

    private void startRubyLoop() {
        this.rubyLoop = new RubyLoop();
        this.rubyLoop.start();
    }

    public Socket getCommandSocket() throws RubyDebuggerException {
        if (this.commandSocket == null) {
            this.commandSocket = this.attach();
        }
        return this.commandSocket;
    }

    public void resume(RubyThread thread) {
        try {
            this.sendCommand(this.commandFactory.createResume(thread));
        }
        catch (RubyDebuggerException e) {
            Util.severe("resuming of " + thread.getId() + " failed", e);
        }
    }

    private void sendCommand(String s) throws RubyDebuggerException {
        Util.fine("Sending command debugger: " + s);
        if (!this.debugTarged.isRunning()) {
            throw new RubyDebuggerException("Trying to send a command [" + s + "] to terminated process");
        }
        this.getCommandWriter().println(s);
    }

    public void sendStepOver(RubyFrame frame, boolean forceNewLine) {
        try {
            if (forceNewLine) {
                this.sendCommand(this.commandFactory.createForcedStepOver(frame));
            } else {
                this.sendCommand(this.commandFactory.createStepOver(frame));
            }
        }
        catch (RubyDebuggerException e) {
            Util.severe("Stepping failed", e);
        }
    }

    public void sendStepReturnEnd(RubyFrame frame) {
        try {
            this.sendCommand(this.commandFactory.createStepReturn(frame));
        }
        catch (RubyDebuggerException e) {
            Util.severe("Stepping failed", e);
        }
    }

    public void sendStepIntoEnd(RubyFrame frame, boolean forceNewLine) {
        try {
            if (forceNewLine) {
                this.sendCommand(this.commandFactory.createForcedStepInto(frame));
            } else {
                this.sendCommand(this.commandFactory.createStepInto(frame));
            }
        }
        catch (RubyDebuggerException e) {
            Util.severe("Stepping failed", e);
        }
    }

    public RubyThreadInfo[] readThreadInfo() throws RubyDebuggerException {
        this.sendCommand(this.commandFactory.createReadThreads());
        return this.getReadersSupport().readThreads();
    }

    public RubyFrame[] readFrames(RubyThread thread) throws RubyDebuggerException {
        RubyFrameInfo[] infos;
        try {
            this.sendCommand(this.commandFactory.createReadFrames(thread));
            infos = this.getReadersSupport().readFrames();
        }
        catch (RubyDebuggerException e) {
            if (this.checkConnection()) {
                throw e;
            }
            infos = new RubyFrameInfo[]{};
        }
        RubyFrame[] frames = new RubyFrame[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            RubyFrameInfo info = infos[i];
            frames[i] = new RubyFrame(thread, info);
        }
        return frames;
    }

    public RubyVariable[] readVariables(RubyFrame frame) throws RubyDebuggerException {
        this.sendCommand(this.commandFactory.createReadLocalVariables(frame));
        RubyVariableInfo[] infos = this.getReadersSupport().readVariables();
        RubyVariable[] variables = new RubyVariable[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            RubyVariableInfo info = infos[i];
            variables[i] = new RubyVariable(info, frame);
        }
        return variables;
    }

    public RubyVariable[] readInstanceVariables(RubyVariable variable) throws RubyDebuggerException {
        this.sendCommand(this.commandFactory.createReadInstanceVariable(variable));
        RubyVariableInfo[] infos = this.getReadersSupport().readVariables();
        RubyVariable[] variables = new RubyVariable[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            RubyVariableInfo info = infos[i];
            variables[i] = new RubyVariable(info, variable);
        }
        return variables;
    }

    public RubyVariable[] readGlobalVariables() throws RubyDebuggerException {
        this.sendCommand(this.commandFactory.createReadGlobalVariables());
        RubyVariableInfo[] infos = this.getReadersSupport().readVariables();
        RubyVariable[] variables = new RubyVariable[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            RubyVariableInfo info = infos[i];
            variables[i] = new RubyVariable(this, info);
        }
        return variables;
    }

    public RubyVariable inspectExpression(RubyFrame frame, String expression) throws RubyDebuggerException {
        expression = expression.replaceAll("\n", "\\\\n");
        this.sendCommand(this.commandFactory.createInspect(frame, expression));
        RubyVariableInfo[] infos = this.getReadersSupport().readVariables();
        return infos.length == 0 ? null : new RubyVariable(infos[0], frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(boolean forced) {
        RubyDebuggerProxy rubyDebuggerProxy = this;
        synchronized (rubyDebuggerProxy) {
            if (this.finished) {
                Util.fine("Trying to finish the same proxy more than once: " + this);
                return;
            }
            this.finished = true;
            PROXIES.remove(this);
            if (forced) {
                this.sendExit();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Util.LOGGER.log(Level.INFO, "Interrupted during IO readers waiting", e);
                }
                this.getDebugTarged().getProcess().destroy();
            }
        }
        this.fireDebugEvent(new RubyDebugEvent(RubyDebugEvent.Type.TERMINATE));
    }

    private synchronized void sendExit() {
        if (this.commandSocket != null && this.debugTarged.isRunning()) {
            try {
                this.sendCommand("exit");
            }
            catch (RubyDebuggerException ex) {
                Util.fine("'exit' command failed. Process died? " + this.debugTarged.isRunning());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket attach() throws RubyDebuggerException {
        int port = this.debugTarged.getPort();
        Socket socket = null;
        int tryCount = this.timeout * 2;
        for (int i = 0; i < tryCount && socket == null; ++i) {
            try {
                socket = new Socket("localhost", port);
                continue;
            }
            catch (ConnectException e) {
                RubyDebuggerProxy rubyDebuggerProxy = this;
                synchronized (rubyDebuggerProxy) {
                    if (this.finished) {
                        throw new RubyDebuggerException("Process was terminated before debugger connection was established.");
                    }
                    if (i == tryCount - 1) {
                        String info = RubyDebuggerProxy.dumpProcess(this.debugTarged.getProcess());
                        throw new RubyDebuggerException("Cannot connect to the debugged process in " + this.timeout + "s:\n\n" + info, e);
                    }
                }
                try {
                    Util.finest("Cannot connect to localhost:" + port + ". Trying again...(" + (tryCount - i - 1) + ')');
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    Util.severe("Interrupted during attaching.", e1);
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            catch (IOException e) {
                throw new RubyDebuggerException(e);
            }
        }
        return socket;
    }

    private static String dumpProcess(Process process) {
        StringBuilder info = new StringBuilder();
        boolean running = Util.isRunning(process);
        if (running) {
            info.append("But server process is running. You might try to increase the timeout. Killing...\n\n");
        }
        info.append(RubyDebuggerProxy.dumpStream(process.getInputStream(), Level.INFO, "Standard Output: ", running));
        info.append(RubyDebuggerProxy.dumpStream(process.getErrorStream(), Level.SEVERE, "Error Output: ", running));
        if (running) {
            process.destroy();
        }
        return info.toString();
    }

    private static String dumpStream(final InputStream stream, Level level, String msgPrefix, boolean asynch) {
        final StringBuilder output = new StringBuilder();
        if (asynch) {
            Thread collector = new Thread(new Runnable(){

                public void run() {
                    RubyDebuggerProxy.collect(stream, output);
                }
            });
            collector.start();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Util.severe(ex);
            }
            collector.interrupt();
        } else {
            RubyDebuggerProxy.collect(stream, output);
        }
        if (output.length() > 0) {
            Util.LOGGER.log(level, msgPrefix);
            String outputS = output.toString();
            Util.LOGGER.log(level, outputS);
            return msgPrefix + '\n' + outputS;
        }
        return "";
    }

    private static void collect(InputStream stream, StringBuilder output) {
        try {
            int c;
            while ((c = stream.read()) != -1) {
                output.append((char)c);
            }
        }
        catch (IOException e) {
            Util.LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
        }
    }

    private class RubyLoop
    extends Thread {
        RubyLoop() {
            this.setName("RubyDebuggerLoop [" + System.currentTimeMillis() + ']');
        }

        public void suspensionOccurred(final SuspensionPoint hit) {
            new Thread(){

                public void run() {
                    RubyDebuggerProxy.this.debugTarged.suspensionOccurred(hit);
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                SuspensionPoint hit;
                Util.finest("Waiting for breakpoints.");
                while ((hit = RubyDebuggerProxy.this.getReadersSupport().readSuspension()) != SuspensionPoint.END) {
                    Util.finest(hit.toString());
                    this.suspensionOccurred(hit);
                }
            }
            catch (RubyDebuggerException e) {
                Util.severe("Exception in socket reader loop.", e);
            }
            finally {
                RubyDebuggerProxy.this.finish(false);
            }
            Util.finest("Socket reader loop finished.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DebuggerType {
        CLASSIC_DEBUGGER,
        RUBY_DEBUG;

    }
}

