/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.generator.bcm;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorbaEnumAdapter
extends ClassAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(CorbaEnumAdapter.class);
    private String internalClassName = null;
    private boolean corbaEnum = false;
    private List<String> enumLabelList = new ArrayList<String>();

    public CorbaEnumAdapter(ClassVisitor cv) {
        super(cv);
        LOG.debug("new CorbaEnumAdapter; ClassVisitor=" + cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        LOG.debug(">>>>> visit - begin");
        LOG.debug("VISIT.\n version=" + version + ";\n access=" + access + ";\n name=" + name + ";\n signature=" + signature + ";\n superName=" + superName + ";\n interfaces=" + interfaces);
        this.setInternalClassName(name);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        LOG.debug(">>>>> visitField - begin. access=" + access + "; name=" + name + "; desc=" + desc + "; signature=" + signature + "; value=" + value);
        int __arrayFieldAccess = 10;
        String __arrayFieldDesc = "[L" + this.getInternalClassName() + ";";
        if ("__array".equals(name) && __arrayFieldAccess == access && __arrayFieldDesc.equals(desc)) {
            LOG.debug("The class " + this.getInternalClassName() + " is a CorbaEnum.");
            this.setCorbaEnum(true);
        } else {
            this.checkLabel(access, name, desc);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    protected void checkLabel(int access, String name, String desc) {
        int labelAccess = 25;
        String labelDesc = "L" + this.getInternalClassName() + ";";
        if (labelAccess == access && labelDesc.equals(desc)) {
            LOG.debug("The field " + name + " is a label of the enumeration.");
            this.getEnumLabelList().add(name);
        }
    }

    public List<String> getEnumLabelList() {
        return this.enumLabelList;
    }

    public void setEnumLabelList(List<String> val) {
        this.enumLabelList = val;
    }

    public boolean isCorbaEnum() {
        return this.corbaEnum;
    }

    public void setCorbaEnum(boolean val) {
        this.corbaEnum = val;
    }

    public String getInternalClassName() {
        return this.internalClassName;
    }

    public void setInternalClassName(String val) {
        this.internalClassName = val;
    }
}

