/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.generator.bcm;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.webservice.generator.bcm.CorbaOnewayMethodVisitor;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorbaOnewayAdapter
extends ClassAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(CorbaOnewayAdapter.class);
    private String internalClassName = null;
    private String associatedInterface = null;
    private List<String> onewayOperationList = new ArrayList<String>();
    protected StringWriter stringWriter = null;

    public CorbaOnewayAdapter(ClassVisitor cv, StringWriter cw) {
        super(cv);
        this.stringWriter = cw;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        LOG.debug(">>>>> visit - begin");
        LOG.debug("VISIT.\n version=" + version + ";\n access=" + access + ";\n name=" + name + ";\n signature=" + signature + ";\n superName=" + superName + ";\n interfaces=" + interfaces);
        this.setInternalClassName(name);
        int underscoreIndex = name.lastIndexOf(47) + 1;
        String tempSimpleName = name.substring(underscoreIndex + 1, name.length() - 4);
        String tempPackage = name.substring(0, underscoreIndex);
        String temp = tempPackage.replace('/', '.') + tempSimpleName;
        this.setAssociatedInterface(temp + "Operations");
        LOG.debug("<<<<< visit - end");
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        LOG.debug(">>>>> visitMethod - begin");
        LOG.debug("visitMethod. access=" + access + "; name=" + name + "; desc=" + desc + "; signature=" + signature + "; exceptions=" + exceptions);
        CorbaOnewayMethodVisitor corbaOnewayMethodVisitor = new CorbaOnewayMethodVisitor(this.getInternalClassName(), name, this.getOnewayOperationList());
        MethodVisitor mv = corbaOnewayMethodVisitor.visitMethod(access, name, desc, signature, exceptions);
        LOG.debug("<<<<< visitMethod - end. methodName=" + name + "; methodDescription=" + desc);
        return mv;
    }

    public String getInternalClassName() {
        return this.internalClassName;
    }

    public void setInternalClassName(String internalClassName) {
        this.internalClassName = internalClassName;
    }

    public List<String> getOnewayOperationList() {
        return this.onewayOperationList;
    }

    public void setOnewayOperationList(List<String> onewayOperationList) {
        this.onewayOperationList = onewayOperationList;
    }

    public String getAssociatedInterface() {
        return this.associatedInterface;
    }

    public void setAssociatedInterface(String associatedInterface) {
        this.associatedInterface = associatedInterface;
    }
}

