/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.ant.taskdefs;

import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.webdav.ant.Utils;
import org.apache.webdav.ant.taskdefs.WebdavTask;

public class Lock
extends WebdavTask {
    private String lockTokenProperty = null;
    private int timeout = 3600;
    private String ownerInfo = null;
    private int depth = Integer.MAX_VALUE;

    public void execute() throws BuildException {
        this.validate();
        try {
            this.log("Locking " + this.getUrl(), 2);
            String locktoken = Utils.lockResource(this.getHttpClient(), this.getUrl(), this.ownerInfo, this.depth, this.timeout);
            this.getProject().setProperty(this.lockTokenProperty, locktoken);
        }
        catch (IOException e) {
            throw Utils.makeBuildException("Can't lock!", e);
        }
    }

    protected void validate() throws BuildException {
        super.validate();
        if (this.lockTokenProperty == null) {
            throw new BuildException("Attribute property required!");
        }
        if (this.ownerInfo == null) {
            this.ownerInfo = "ant-webdav " + this.getUserid();
        }
    }

    public void setProperty(String name) {
        this.lockTokenProperty = name;
    }

    public void setTimeout(int value) {
        if (value <= 0) {
            throw new BuildException("Invalid timeout value (Must be positive integer)");
        }
        this.timeout = value;
    }

    public void setOwnerinfo(String value) {
        this.ownerInfo = value;
    }

    public void setDepth(String value) {
        if ("0".trim().equals(value)) {
            this.depth = 0;
        } else if ("infinity".trim().toLowerCase().equals(value)) {
            this.depth = Integer.MAX_VALUE;
        } else {
            throw new BuildException("Invalid value of depth attribute. (One of '0' or 'infinity' exprected)");
        }
    }
}

