<%-- 
/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/ 
--%>
<%@ taglib prefix="sql" uri="http://java.sun.com/jsp/jstl/sql" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %> 
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="waf" uri="/WEB-INF/waftags.tld" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@page contentType="text/html"%>

<fmt:setLocale value="en_US" />

<sql:setDataSource dataSource="jdbc/CatalogDB"/>
<sql:query var="activities"> 
select activityid,name, description, price, imageuri from activity where location = ? and locale = ?
 <sql:param>${cart.destination}</sql:param>
 <sql:param>en_US</sql:param>
</sql:query>


<script language="javascript">
   function disableUpdateButton() {
       activitiesForm.updateButton.disabled = true;
   }

   function changePeople() {
       activitiesForm.updateButton.disabled = false;
   }
</script>

<body onLoad="disableUpdateButton()">
<table>
<form name="activitiesForm" action="cart.do" method="POST">
 <input type="HIDDEN" name ="target_action" value="purchase_activities">
 <input type="HIDDEN" name ="tab" value="${param.tab}">
<c:forEach var="activity"  varStatus="activityStatus" items="${activities.rows}">
  <tr>
   <td>
     <c:url var="imageURL" value="images/${activity.imageuri}"/>
     <image src="${imageURL}" alt="${activity.name} Image">
   </td>
   <td>
    <h2>${activity.name}</h2>
     ${activity.description}
    </td>
    <td><b>Price</b> <fmt:formatNumber value="${activity.price}" type="currency" /> per person</td>
    <td colspan="2">
      <label>Number of People</label>:<br>
     <waf:select name="activity_${fn:trim(activity.activityid)}" onChange="changePeople()">
      <c:choose>
       <c:when test="${cart.activities[fn:trim(activity.activityid)] != null}">
        <waf:selected>${cart.activities[fn:trim(activity.activityid)]}</waf:selected>
        <waf:option value="0">None - Cancel</waf:option>
       </c:when>
       <c:otherwise>
           <waf:selected>0</waf:selected>
           <waf:option value="0">None</waf:option>
       </c:otherwise>
      </c:choose>
      
      <c:forEach varStatus="status" begin="1" end="${cart.headCount}">
       <waf:option value="${status.index}">${status.index}</waf:option>
      </c:forEach>
     </waf:select>
    </td>
    <td>
  </tr>
  <c:choose>
   <c:when test="${activityStatus.last == false}">
      <tr><td colspan="5"><hr width="90%"></td></tr>
   </c:when>
  </c:choose>
 </c:forEach>
  <tr>
   <td></td><td></td><td></td>
   <td valign="center">
      <input type="SUBMIT"  value="Update Activities" name="updateButton">
   </form>
   </td>
   <td valign="center">
   <form action="cart.do" method="POST">
     <input type="SUBMIT" value="Cancel Update" name="cancelButton">
   </form>
    </td>
 </tr>
</table>
</body>
