<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0">

  <xsl:output method="html" indent="yes"/>

  <!-- template rule matching source root element -->
  <xsl:template match="/">
    <html> <head> 
    <title>Java AVK for the Enterprise Report Tool </title>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
    <LINK href="./appVerification.css" rel="stylesheet" type="text/css"> 
    </LINK>
    </meta>
    </head>

    <xsl:apply-templates select="app-verification"/>
    </html>
  </xsl:template>

  <xsl:template match="app-verification">
     <body bgcolor="#FFFFFF" background="./Lt_BluePaperTexture.gif">
     <form method="post" action="">
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
           <tr bgcolor="7171A5">
             <td width="100%"> 
                <div class="page-title-text" align="left">Java AVK for the Enterprise - Web Component Coverage </div>
             </td>
           </tr>
        </table>

          <xsl:apply-templates select="percentage"/>

          <br>
          <table class="back-table" border="0" cellspacing="0" cellpadding="1" width="100%">
            <tr> 
            <td> 
            <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
              <tr class="header-row"> 
              <td width="28%"> 
              <div class="table-header-text" align="left">Context Root </div>
              </td>
              <td width="28%"> 
              <div class="table-header-text" align="left">Web Component Name </div>
              </td>
              <td width="27%"> 
              <div class="table-header-text" align="left">Called </div>
              </td>
              </tr>
		  <xsl:for-each select="//web-entity">
               <tr height="1">
                 <td class="line-row" colspan="3"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
               </tr>
                     <tr> 
                     <td width="18%" valign="top"> 
                     <div class="table-normal-text"><xsl:value-of select="../context"/> </div>
                     </td>
                     <td width="52%" valign="top"> 
                     <div class="table-normal-text"><xsl:value-of select="name"/> </div>
                     </td>
                     <td width="30%" valign="bottom"> 
		     <xsl:variable name="counter" select="normalize-space(counter)"/>
		     <xsl:choose>
		     <xsl:when test="$counter='0'">
			<div class="table-failed-text">Not called </div>
		     </xsl:when>
		     <xsl:otherwise>
		       <xsl:if test="count(exception) !=0">
			<xsl:variable name="context" select="normalize-space(../context)"/>
			<div class="table-failed-text"> <a href="webException.html#{$context}"><xsl:value-of select="count(exception)"/>Exception Found </a> </div>
		       </xsl:if>
		       <xsl:if test="count(exception) =0">
			<div class="table-normal-text">Called </div>
		       </xsl:if>
		     </xsl:otherwise>
		     </xsl:choose>
		     </td>
		     </tr>
		   </xsl:for-each>
	       </table>
	    </td>
	    </tr>
	    </table>
          </br>

     </form>
     </body>
  </xsl:template>

  <xsl:template match="percentage">
  <table border="0" cellspacing="0" cellpadding="0" width="100%">
   <tr height="1">
   <td class="line-row" colspan="2" alt="" width="1" height="1" border="0"/>
   </tr>
   <tr>
   <td width="35%" valign="top">
        <div class="table-title-text">Application File: </div>
    </td>
    <td width="65%">
        <div class="table-label-text"> <xsl:value-of select="//app-name"/> 
        </div>
    </td>
   </tr>
   <tr>
   <td width="35%" valign="top">
       <div class="table-title-text">Status: </div>          
    </td>
    <td width="65%">
        <xsl:variable name="web-percent" select="normalize-space(//web-percentage)"/>
	  <xsl:choose>
	    <xsl:when test="$web-percent != '100'">
               <div class="table-failed-label-text">Failed <xsl:value-of select="//web-percentage"/>% of all web components called </div>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:choose>
	       <xsl:when test="count(//web-component/web-entity/exception) != 0">
               <div class="table-failed-text">Failed <xsl:value-of select="//web-percentage"/>% of all web componenets called, exception found </div>
	       </xsl:when>
	       <xsl:otherwise>
               <div class="table-normal-text">Passed <xsl:value-of select="//web-percentage"/>% of all web componenets called </div>
	       </xsl:otherwise>
	      </xsl:choose>
	    </xsl:otherwise>
	  </xsl:choose>
      </td>
    </tr>
  </table>
  </xsl:template>

<xsl:template/>
</xsl:stylesheet>