/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.model.validation.staticanalysis;

import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import junit.framework.*;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.validation.common.TestCatalogModel;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.Validation.ValidationType;
import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.xml.xam.spi.Validator.ResultItem;

/**
 * @author Praveen Savur
 * @author changed by ads
 */
public class BPELStaticAnalysisValidatorTest extends TestCase {


    private static final String RESOURCES_VALID = 
        "resources/valid/";
    
    private static final String RESOURCE_INVALID = 
        "resources/invalid/";


    static final String STATIC_ANALYSYS_VALIDATOR = 
        BPELStaticAnalysisValidator.class.getCanonicalName();
    
    private static final ResourceBundle mMessages = ResourceBundle
        .getBundle( BPELStaticAnalysisValidator.class.getPackage().getName()+
                ".Bundle");

    //
    private static Pattern p = Pattern.compile("\"?+\\{\\d\\}\"?+");

    public BPELStaticAnalysisValidatorTest( String testName ) {
        super(testName);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }


    /**
     * Test of validate method, of class
     * org.netbeans.modules.xml.wsdl.model.extensions.soap.validation.SOAPComponentValidator.
     */
    public void testValidBPELs() throws Exception {
        // Grab all our BPEL files to test using a known WSDL
        URL resource = getClass().getResource(RESOURCES_VALID);
        URI resourceURI = resource.toURI();
        File resourceFile = new File(resourceURI);
        File[] bpels = resourceFile.listFiles(new FileFilter() {

            public boolean accept( File pathname ) {
                return pathname.getName().endsWith(".bpel");
            }
        });
        for (int ii = 0; ii < bpels.length; ii++) {
            File bpel = bpels[ii];
            URI bpelURI = bpel.toURI();
            ValidationResult result = validate(bpelURI);
            int resultSize = result.getValidationResult().size();
            if (resultSize != 0) {
                Iterator<ResultItem> it = result.getValidationResult()
                        .iterator();
                while (it.hasNext()) {
                    ResultItem ri = it.next();
                    System.out.println(bpel + " " + ri.getDescription());
                }
            }
            assertTrue("expected no error in " + bpel + ", found " + resultSize
                    + " errors." + resultSize, resultSize == 0);
        }
    }

    public void testPartnerLinkRole() throws Exception {
        HashSet<String> expectedErrors = new HashSet<String>();
        expectedErrors.add(mMessages.getString(
                BPELStaticAnalysisVisitor.FIX_PARTNER_LINK_ERROR));
        String fileName = RESOURCE_INVALID+"invalidPartnerLink1.bpel";
        URL url = getClass().getResource(fileName);
        URI uri = url.toURI();
        validate(uri, expectedErrors);

        expectedErrors = new HashSet<String>();
        fileName = RESOURCES_VALID+"validPartnerLink1.bpel";
        url = getClass().getResource(fileName);
        uri = url.toURI();
        validate(uri, expectedErrors);
    }

    public void testInitialisePartnerRole() throws Exception {
        HashSet<String> expectedErrors = new HashSet<String>();
        expectedErrors.add(mMessages.getString(
                BPELStaticAnalysisVisitor.FIX_INITIALISE_PARTNER_ROLE));
        String fileName = RESOURCE_INVALID+"invalidInitialisePartnerRole.bpel";
        URL url = getClass().getResource(fileName);
        URI uri = url.toURI();
        validate(uri, expectedErrors);

        expectedErrors = new HashSet<String>();
        fileName = RESOURCES_VALID+"validInitialisePartnerRole.bpel";
        url = getClass().getResource(fileName);
        uri = url.toURI();
        validate(uri, expectedErrors);
    }

    public void testSolicitResponseNotificationPortTypes() throws Exception {
        HashSet<String> expectedErrors = new HashSet<String>();
        expectedErrors.add(mMessages
                .getString(BPELStaticAnalysisHelper.
                        FIX_WSDLOPERATION_SOLICIT_RESPONSE_NOTIFICATION));
        String fileName = RESOURCE_INVALID+"solicitResponseNotification.bpel";
        URL url = getClass().getResource(fileName);
        URI uri = url.toURI();
        validate(uri, expectedErrors);
    }

    public void testOverloadedOperationNames() throws Exception {
        HashSet<String> expectedErrors = new HashSet<String>();
        expectedErrors.add(mMessages
                .getString(BPELStaticAnalysisHelper.
                        FIX_PORT_TYPE_OVERLOADED_OPERATION_NAME));
        String fileName = RESOURCE_INVALID + "overloadedOperationNames.bpel";
        URL url = getClass().getResource(fileName);
        URI uri = url.toURI();
        validate(uri, expectedErrors);
    }

    // RIT: This is failing when running outside ide mode need to fix in XAM.
     /*public void testInputVariableToPartCombination() throws Exception {
        HashSet<String> expectedErrors = new HashSet<String>();
        expectedErrors.add(mMessages
                .getString("FIX_InputVariableToPartCombination"));
        String fileName = "/org/netbeans/modules/bpel/model/validation/staticanalysis/resources/invalid/inputVariabletoPartCombination.bpel";
        URL url = getClass().getResource(fileName);
        URI uri = url.toURI();
        validate(uri, expectedErrors);
    }*/

    public void testOutputVariableFromPartCombination() throws Exception {
        HashSet<String> expectedErrors = new HashSet<String>();
        expectedErrors.add(mMessages
                .getString(BPELStaticAnalysisHelper.
                        FIX_OUTPUTVARIABLE_FROMPART_COMBINATION));
        String fileName = RESOURCE_INVALID + "outputVariableFromPartCombination.bpel";
        URL url = getClass().getResource(fileName);
        URI uri = url.toURI();
        validate(uri, expectedErrors);
    }

    public void testInValidFromPartElementPartAttribute() throws Exception {
        HashSet<String> expectedErrors = new HashSet<String>();
        expectedErrors.add(mMessages
                .getString(BPELStaticAnalysisHelper.
                        FIX_INVALID_FROMPART_PARTATTR));
        String fileName = RESOURCE_INVALID + "fromPartElement_invalidPartAttr.bpel";
        URL url = getClass().getResource(fileName);
        URI uri = url.toURI();
        validate(uri, expectedErrors);

        expectedErrors = new HashSet<String>();
        fileName = RESOURCES_VALID + "fromPartElement_validPartAttr.bpel";
        url = getClass().getResource(fileName);
        uri = url.toURI();
        validate(uri, expectedErrors);
    }

    public void testInValidToPartElementPartAttribute() throws Exception {
        HashSet<String> expectedErrors = new HashSet<String>();
        expectedErrors.add(mMessages
                .getString(BPELStaticAnalysisHelper.
                        FIX_INVALID_TOPART_PARTATTR));
        String fileName = RESOURCE_INVALID + "toPartElement_invalidPartAttr.bpel";
        URL url = getClass().getResource(fileName);
        URI uri = url.toURI();
        validate(uri, expectedErrors);

        expectedErrors = new HashSet<String>();
        fileName = RESOURCES_VALID + "toPartElement_validPartAttr.bpel";
        url = getClass().getResource(fileName);
        uri = url.toURI();
        validate(uri, expectedErrors);
    }

    public void testReceiveVariableFromPartCombination() throws Exception {
        HashSet<String> expectedErrors = new HashSet<String>();
        expectedErrors.add(mMessages
                .getString(BPELStaticAnalysisHelper.
                        FIX_RECEIVE_VARIABLE_FROMPART_COMBINATION));
        String fileName = RESOURCE_INVALID + "receiveVariableFromPartCombination.bpel";
        URL url = getClass().getResource(fileName);
        URI uri = url.toURI();
        validate(uri, expectedErrors);
    }

     //Fails in outside IDE mode.
     /*public void testOnMessageVariableFromPartCombination() throws Exception {
        HashSet<String> expectedErrors = new HashSet<String>();
        expectedErrors.add(mMessages
                .getString("FIX_OnMessage_Variable_FromPart_Combination"));
        String fileName = "/org/netbeans/modules/bpel/model/validation/staticanalysis/resources/invalid/onMessageVariableFromPartCombination.bpel";
        URL url = getClass().getResource(fileName);
        URI uri = url.toURI();
        validate(uri, expectedErrors);
    }*/

    public void testReplyVariableToPartCombination() throws Exception {
        Collection<String> expectedErrors = new ArrayList<String>();
        expectedErrors.add(mMessages
                .getString(BPELStaticAnalysisHelper.
                        FIX_REPLY_VARIABLE_TOPART_COMBINATION));
        expectedErrors.add(mMessages
                .getString(BPELStaticAnalysisHelper.
                        FIX_REPLY_VARIABLE_TOPART_COMBINATION));
        String fileName = RESOURCE_INVALID + "replyVariableToPartCombination.bpel";
        URL url = getClass().getResource(fileName);
        URI uri = url.toURI();
        validate(uri, expectedErrors);
    }

    public void testInvokeMessageNotCompletelyInitialisedByToPart()
            throws Exception
    {
        Collection<String> expectedErrors = new ArrayList<String>();
        expectedErrors.add(mMessages
                .getString(BPELStaticAnalysisHelper.
                        FIX_WSDL_MESSAGE_NOT_COMPLETELY_INITIALISED));
        String fileName = RESOURCE_INVALID + 
            "invokeMessageNotCompletelyIntialisedBytoPart.bpel";
        URL url = getClass().getResource(fileName);
        URI uri = url.toURI();
        validate(uri, expectedErrors);
    }

    public void testReplyMessageNotCompletelyInitialisedByToPart()
            throws Exception
    {
        Collection<String> expectedErrors = new ArrayList<String>();
        expectedErrors.add(mMessages
                .getString(BPELStaticAnalysisHelper.
                        FIX_WSDL_MESSAGE_NOT_COMPLETELY_INITIALISED));
        String fileName = RESOURCE_INVALID + 
            "replyMessageNotCompletelyInitialisedBytoPart.bpel";
        URL url = getClass().getResource(fileName);
        URI uri = url.toURI();
        validate(uri, expectedErrors);
    }

    private boolean containsExpectedError( Collection<String> expectedErrors,
            String actualError )
    {
        boolean result = false;
        Iterator<String> it = expectedErrors.iterator();
        while (it.hasNext()) {
            String[] needToMatch = null;
            String expectedError = it.next();
            needToMatch = p.split(expectedError);

            // now let see if expected error can be matched with actual error.
            if (needToMatch != null) {
                // assume we have a match unless we found a mismatch below
                boolean foundMatch = true;
                for (int i = 0; i < needToMatch.length; i++) {
                    String match = needToMatch[i];
                    if (!actualError.contains(match)) {
                        // no exact match found.
                        foundMatch = false;
                        break;
                    }
                }

                result = foundMatch;
                if (result) {
                    break;
                }
            }

        }
        return result;
    }

    private void dumpExpectedErrors( Collection<String> expectedErrors ) {
        int counter = 1;
        Iterator<String> it = expectedErrors.iterator();
        while (it.hasNext()) {
            String expectedError = it.next();
            System.out.println("expected error :" + counter + " "
                    + expectedError);
            counter++;
        }
    }
    private ValidationResult validate( URI relativePath ) throws Exception {
        BpelModel model = TestCatalogModel.getDefault().getBPELModel(
                relativePath);
        Validation validation = new Validation();
        ValidationType validationType = Validation.ValidationType.COMPLETE;
        BPELStaticAnalysisValidator instance = new BPELStaticAnalysisValidator();
        ValidationResult result = instance.validate(model, validation,
                validationType);
        return result;
    }

    private void validate( URI relativePath, Collection<String> expectedErrors )
            throws Exception
    {
        System.out.println(relativePath);
        ValidationResult result = validate(relativePath);
        Iterator<ResultItem> it = result.getValidationResult().iterator();
        dumpExpectedErrors(expectedErrors);
        while (it.hasNext()) {
            ResultItem item = it.next();
            System.out.println("    " + item.getDescription());
            assertTrue(item.getDescription(), containsExpectedError(
                    expectedErrors, item.getDescription()));
        }

        int resultCount = 0;
        for (ResultItem item : result.getValidationResult()) {
            if (item.getValidator().getName().equals(STATIC_ANALYSYS_VALIDATOR)){
                resultCount++;
                // check ONLY errors from BPELStaticAnalysisValidator
            }
        }
        if (resultCount != expectedErrors.size()) {
            fail("Expected " + expectedErrors.size() + " but got"
                    + result.getValidationResult().size() + " results.");
        }
    }
}
