/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.impl;

import java.util.Iterator;
import java.util.List;

import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import java.util.logging.Level;
import org.netbeans.modules.bpel.model.api.BooleanExpr;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.ConditionHolder;
import org.netbeans.modules.bpel.xpath.model.node.visitor.XPathGeneratorVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.bpel.xpath.view.BPELElementXPathExpressionBuilder;
import org.openide.util.NbBundle;

/**
 *
 * @author radval
 *
 */
public class ConditionReferenceXPathExpressionBuilder extends BPELElementXPathExpressionBuilder {
    
    public ConditionReferenceXPathExpressionBuilder(BpelEntity element,
                                                    IBasicMapper mapper) {
        super(element, mapper);
        if(!(element instanceof ConditionHolder)) {
            throw new IllegalArgumentException(
                    NbBundle.getMessage(ConditionReferenceXPathExpressionBuilder.class,
                        "STR_ELEMENT_SHOULD_BE_BPEL_CONDITION_HOLDER_BUT_FOUND_X",  // NOI18N
                        element));
        }
    }
    
    
    public void handleLinkCreationToNonTargetTreeNode(List links) {
        Iterator it = links.iterator();
        while(it.hasNext()) {
            IMapperLink link = (IMapperLink) it.next();
            ConditionHolder cReference = (ConditionHolder) link.getLinkObject();
            if(cReference != null) {
                IMapperNode startNode = link.getStartNode();
                Node node = (Node) startNode.getNodeObject();
                if(node != null) {
                    XPathGeneratorVisitor xGenerator = new XPathGeneratorVisitor(getBPELElement());
                    node.accept(xGenerator);
                    String sourceExpression = xGenerator.getXPath();
                    BooleanExpr expression = getBPELDocument().getBuilder().createCondition();
                    try {
                        expression.setContent(sourceExpression);
                        xGenerator.addNewPrefixToProcess();
                    } catch (Exception ex) {
                        LOGGER.log(Level.SEVERE,
                                NbBundle.getMessage(ConditionReferenceXPathExpressionBuilder.class,
                                    "STR_FAILED_TO_SET_CONDITION_CONTENT_TO_X", // NOI18N
                                    sourceExpression), ex);
                    }
                    cReference.setCondition(expression);
                }
            }
        }
    }
    
    
    public void handleLinkCreationToTargetTreeNode(
            List links,
            String sourceExpression,
            String targetExpression,
            Node targetTreeNode) {
        Iterator it = links.iterator();
        while(it.hasNext()) {
            IMapperLink link = (IMapperLink) it.next();
            ConditionHolder cReference = (ConditionHolder) getBPELElement();
            BooleanExpr expression = getBPELDocument().getBuilder().createCondition();
            try {
                expression.setContent(sourceExpression);
            } catch (Exception ex) {
                LOGGER.log(Level.SEVERE,
                        NbBundle.getMessage(ConditionReferenceXPathExpressionBuilder.class,
                            "STR_FAILED_TO_SET_CONDITION_CONTENT_TO_X", // NOI18N
                            sourceExpression), ex);
            }
            cReference.setCondition(expression);
            link.setLinkObject(cReference);
        }
    }
}

